/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.Closure;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.MutationGuard;
import org.gradle.api.internal.WithEstimatedSize;
import org.gradle.api.internal.WithMutationGuard;
import org.gradle.api.internal.collections.CollectionEventRegister;
import org.gradle.api.internal.collections.CollectionFilter;
import org.gradle.api.internal.collections.DefaultCollectionEventRegister;
import org.gradle.api.internal.collections.ElementSource;
import org.gradle.api.internal.collections.FilteredCollection;
import org.gradle.api.internal.provider.CollectionProviderInternal;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.internal.Cast;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.util.internal.ConfigureUtil;

public class DefaultDomainObjectCollection<T>
extends AbstractCollection<T>
implements DomainObjectCollection<T>,
WithEstimatedSize,
WithMutationGuard {
    private final Class<? extends T> type;
    private final CollectionEventRegister<T> eventRegister;
    private final ElementSource<T> store;

    protected DefaultDomainObjectCollection(Class<? extends T> type, ElementSource<T> store, CollectionCallbackActionDecorator callbackActionDecorator) {
        this(type, store, new DefaultCollectionEventRegister<T>(type, callbackActionDecorator));
    }

    protected DefaultDomainObjectCollection(Class<? extends T> type, ElementSource<T> store, final CollectionEventRegister<T> eventRegister) {
        this.type = type;
        this.store = store;
        this.eventRegister = eventRegister;
        this.store.onRealize(new Action<T>(){

            @Override
            public void execute(T value) {
                DefaultDomainObjectCollection.this.doAddRealized(value, eventRegister.getAddActions());
            }
        });
    }

    protected DefaultDomainObjectCollection(DefaultDomainObjectCollection<? super T> collection, CollectionFilter<T> filter) {
        this(filter.getType(), collection.filteredStore(filter), collection.filteredEvents(filter));
    }

    protected void realized(ProviderInternal<? extends T> provider) {
        this.getStore().realizeExternal(provider);
    }

    public Class<? extends T> getType() {
        return this.type;
    }

    protected ElementSource<T> getStore() {
        return this.store;
    }

    protected CollectionEventRegister<T> getEventRegister() {
        return this.eventRegister;
    }

    protected CollectionFilter<T> createFilter(Spec<? super T> filter) {
        return this.createFilter(this.getType(), filter);
    }

    protected <S extends T> CollectionFilter<S> createFilter(Class<S> type) {
        return new CollectionFilter<S>(type);
    }

    protected <S extends T> CollectionFilter<S> createFilter(Class<? extends S> type, Spec<? super S> spec) {
        return new CollectionFilter<S>(type, spec);
    }

    protected <S extends T> DefaultDomainObjectCollection<S> filtered(CollectionFilter<S> filter) {
        return new DefaultDomainObjectCollection<S>(this, filter);
    }

    protected <S extends T> ElementSource<S> filteredStore(CollectionFilter<S> filter) {
        return this.filteredStore(filter, this.store);
    }

    protected <S extends T> ElementSource<S> filteredStore(CollectionFilter<S> filter, ElementSource<T> elementSource) {
        return new FilteredCollection<T, S>(elementSource, filter);
    }

    protected <S extends T> CollectionEventRegister<S> filteredEvents(CollectionFilter<S> filter) {
        return this.eventRegister.filtered(filter);
    }

    @Override
    public DomainObjectCollection<T> matching(Spec<? super T> spec) {
        return this.filtered(this.createFilter(spec));
    }

    @Override
    public DomainObjectCollection<T> matching(Closure spec) {
        return this.matching(Specs.convertClosureToSpec(spec));
    }

    @Override
    public <S extends T> DomainObjectCollection<S> withType(Class<S> type) {
        return this.filtered(this.createFilter(type));
    }

    @Override
    public Iterator<T> iterator() {
        return new IteratorImpl(this.store.iterator());
    }

    Iterator<T> iteratorNoFlush() {
        if (this.store.constantTimeIsEmpty()) {
            return Collections.emptyIterator();
        }
        return new IteratorImpl(this.store.iteratorNoFlush());
    }

    @Override
    public void all(Action<? super T> action) {
        this.assertMutable("all(Action)");
        Action<T> decoratedAction = this.addEagerAction(action);
        if (this.store.constantTimeIsEmpty()) {
            return;
        }
        Collection copied = null;
        for (Object t : this) {
            if (copied == null) {
                copied = Lists.newArrayListWithExpectedSize((int)this.estimatedSize());
            }
            copied.add(t);
        }
        if (copied != null) {
            for (Object t : copied) {
                decoratedAction.execute(t);
            }
        }
    }

    @Override
    public void configureEach(Action<? super T> action) {
        this.assertMutable("configureEach(Action)");
        Action<? super T> wrappedAction = this.withMutationDisabled(this.decorate(action));
        Action registerLazyAddActionDecorated = this.eventRegister.registerLazyAddAction(wrappedAction);
        Collection copied = null;
        Iterator<T> iterator = this.iteratorNoFlush();
        while (iterator.hasNext()) {
            if (copied == null) {
                copied = Lists.newArrayListWithExpectedSize((int)this.estimatedSize());
            }
            copied.add(iterator.next());
        }
        if (copied != null) {
            for (Object next : copied) {
                registerLazyAddActionDecorated.execute(next);
            }
        }
    }

    protected <I extends T> Action<? super I> withMutationDisabled(Action<? super I> action) {
        return this.getMutationGuard().withMutationDisabled(action);
    }

    @Override
    public void all(Closure action) {
        this.all(this.toAction(action));
    }

    @Override
    public <S extends T> DomainObjectCollection<S> withType(Class<S> type, Action<? super S> configureAction) {
        this.assertMutable("withType(Class, Action)");
        DomainObjectCollection<S> result = this.withType(type);
        result.all(configureAction);
        return result;
    }

    @Override
    public <S extends T> DomainObjectCollection<S> withType(Class<S> type, Closure configureClosure) {
        return this.withType(type, this.toAction(configureClosure));
    }

    @Override
    public Action<? super T> whenObjectAdded(Action<? super T> action) {
        this.assertMutable("whenObjectAdded(Action)");
        return this.addEagerAction(action);
    }

    @Override
    public void whenObjectAdded(Closure action) {
        this.whenObjectAdded(this.toAction(action));
    }

    private Action<? super T> addEagerAction(Action<? super T> action) {
        this.store.realizePending(this.type);
        return this.eventRegister.registerEagerAddAction(this.type, this.decorate(action));
    }

    @Override
    public Action<? super T> whenObjectRemoved(Action<? super T> action) {
        this.eventRegister.registerRemoveAction(this.type, this.decorate(action));
        return action;
    }

    @Override
    public void whenObjectRemoved(Closure action) {
        this.whenObjectRemoved(this.toAction(action));
    }

    private Action<? super T> decorate(Action<? super T> action) {
        return this.eventRegister.getDecorator().decorate(action);
    }

    private Action<? super T> toAction(Closure action) {
        return ConfigureUtil.configureUsing(action);
    }

    @Override
    public boolean add(T toAdd) {
        this.assertMutable("add(T)");
        this.assertMutableCollectionContents();
        return this.doAdd(toAdd, this.eventRegister.getAddActions());
    }

    protected <I extends T> boolean add(I toAdd, Action<? super I> notification) {
        this.assertMutableCollectionContents();
        return this.doAdd(toAdd, notification);
    }

    protected <I extends T> boolean doAdd(I toAdd, Action<? super I> notification) {
        if (this.getStore().add(toAdd)) {
            this.didAdd(toAdd);
            notification.execute(toAdd);
            return true;
        }
        return false;
    }

    private <I extends T> boolean doAddRealized(I toAdd, Action<? super I> notification) {
        if (this.getStore().addRealized(toAdd)) {
            this.didAdd(toAdd);
            notification.execute(toAdd);
            return true;
        }
        return false;
    }

    @Override
    public void addLater(Provider<? extends T> provider) {
        this.assertMutable("addLater(Provider)");
        this.assertMutableCollectionContents();
        ProviderInternal<T> providerInternal = Providers.internal(provider);
        this.store.addPending(providerInternal);
        if (this.eventRegister.isSubscribed(providerInternal.getType())) {
            this.doAddRealized(provider.get(), this.eventRegister.getAddActions());
        }
    }

    @Override
    public void addAllLater(Provider<? extends Iterable<T>> provider) {
        this.assertMutable("addAllLater(Provider)");
        this.assertMutableCollectionContents();
        CollectionProviderInternal providerInternal = (CollectionProviderInternal)Cast.uncheckedCast(provider);
        this.store.addPendingCollection(providerInternal);
        if (this.eventRegister.isSubscribed(providerInternal.getElementType())) {
            for (T value : provider.get()) {
                this.doAddRealized(value, this.eventRegister.getAddActions());
            }
        }
    }

    protected void didAdd(T toAdd) {
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        this.assertMutable("addAll(Collection<T>)");
        this.assertMutableCollectionContents();
        boolean changed = false;
        for (T o : c) {
            if (!this.doAdd(o, this.eventRegister.getAddActions())) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public void clear() {
        this.assertMutable("clear()");
        this.assertMutableCollectionContents();
        if (this.store.constantTimeIsEmpty()) {
            return;
        }
        ArrayList c = Lists.newArrayList(this.store.iteratorNoFlush());
        this.getStore().clear();
        for (Object o : c) {
            this.eventRegister.fireObjectRemoved(o);
        }
    }

    @Override
    public boolean contains(Object o) {
        return this.getStore().contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.getStore().containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.getStore().isEmpty();
    }

    @Override
    public boolean remove(Object o) {
        this.assertMutable("remove(Object)");
        this.assertMutableCollectionContents();
        return this.doRemove(o);
    }

    private boolean doRemove(Object o) {
        if (o instanceof ProviderInternal) {
            ProviderInternal providerInternal = (ProviderInternal)Cast.uncheckedCast(o);
            if (this.getStore().removePending(providerInternal)) {
                this.didRemove(providerInternal);
                return true;
            }
            if (this.getType().isAssignableFrom(providerInternal.getType()) && providerInternal.isPresent()) {
                o = providerInternal.get();
            }
        }
        if (this.getStore().remove(o)) {
            Object cast = o;
            this.didRemove(cast);
            this.eventRegister.fireObjectRemoved(cast);
            return true;
        }
        return false;
    }

    protected void didRemove(T t) {
    }

    protected void didRemove(ProviderInternal<? extends T> t) {
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.assertMutable("removeAll(Collection)");
        this.assertMutableCollectionContents();
        if (this.store.constantTimeIsEmpty()) {
            return false;
        }
        boolean changed = false;
        for (Object o : c) {
            if (!this.doRemove(o)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> target) {
        this.assertMutable("retainAll(Collection)");
        this.assertMutableCollectionContents();
        Object[] existingItems = this.toArray();
        boolean changed = false;
        for (Object existingItem : existingItems) {
            if (target.contains(existingItem)) continue;
            this.doRemove(existingItem);
            changed = true;
        }
        return changed;
    }

    @Override
    public int size() {
        return this.store.size();
    }

    @Override
    public int estimatedSize() {
        return this.store.estimatedSize();
    }

    @Override
    public MutationGuard getMutationGuard() {
        return this.store.getMutationGuard();
    }

    @Override
    public Collection<T> findAll(Closure cl) {
        return this.findAll(cl, new ArrayList());
    }

    protected <S extends Collection<? super T>> S findAll(Closure cl, S matches) {
        if (this.store.constantTimeIsEmpty()) {
            return matches;
        }
        for (Object t : this.filteredStore(this.createFilter(Specs.convertClosureToSpec(cl)))) {
            matches.add(t);
        }
        return matches;
    }

    protected final void assertMutable(String methodName) {
        this.getMutationGuard().assertMutationAllowed(methodName, this);
    }

    protected void assertMutableCollectionContents() {
    }

    protected class IteratorImpl
    implements Iterator<T>,
    WithEstimatedSize {
        private final Iterator<T> iterator;
        private T currentElement;

        public IteratorImpl(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            this.currentElement = this.iterator.next();
            return this.currentElement;
        }

        @Override
        public void remove() {
            DefaultDomainObjectCollection.this.assertMutable("iterator().remove()");
            DefaultDomainObjectCollection.this.assertMutableCollectionContents();
            this.iterator.remove();
            DefaultDomainObjectCollection.this.didRemove(this.currentElement);
            DefaultDomainObjectCollection.this.getEventRegister().fireObjectRemoved(this.currentElement);
            this.currentElement = null;
        }

        @Override
        public int estimatedSize() {
            return DefaultDomainObjectCollection.this.estimatedSize();
        }
    }
}

