/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy;

import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ArtifactIdentifier;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedModuleVersion;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.cache.ArtifactResolutionControl;
import org.gradle.api.internal.artifacts.cache.DependencyResolutionControl;
import org.gradle.api.internal.artifacts.cache.ModuleResolutionControl;
import org.gradle.api.internal.artifacts.cache.ResolutionControl;
import org.gradle.api.internal.artifacts.configurations.MutationValidator;
import org.gradle.api.internal.artifacts.configurations.dynamicversion.CachePolicy;
import org.gradle.api.internal.artifacts.configurations.dynamicversion.Expiry;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.dynamicversions.DefaultResolvedModuleVersion;

public class DefaultCachePolicy
implements CachePolicy {
    private static final int SECONDS_IN_DAY = 86400;
    private static final int MILLISECONDS_IN_DAY = 86400000;
    final List<Action<? super DependencyResolutionControl>> dependencyCacheRules;
    final List<Action<? super ModuleResolutionControl>> moduleCacheRules;
    final List<Action<? super ArtifactResolutionControl>> artifactCacheRules;
    private MutationValidator mutationValidator = MutationValidator.IGNORE;
    private long keepDynamicVersionsFor = 86400000L;
    private long keepChangingModulesFor = 86400000L;

    public DefaultCachePolicy() {
        this.dependencyCacheRules = new ArrayList<Action<? super DependencyResolutionControl>>();
        this.moduleCacheRules = new ArrayList<Action<? super ModuleResolutionControl>>();
        this.artifactCacheRules = new ArrayList<Action<? super ArtifactResolutionControl>>();
        this.cacheDynamicVersionsFor(86400, TimeUnit.SECONDS);
        this.cacheChangingModulesFor(86400, TimeUnit.SECONDS);
        this.cacheMissingArtifactsFor(86400, TimeUnit.SECONDS);
    }

    DefaultCachePolicy(DefaultCachePolicy policy) {
        this.dependencyCacheRules = new ArrayList<Action<? super DependencyResolutionControl>>(policy.dependencyCacheRules);
        this.moduleCacheRules = new ArrayList<Action<? super ModuleResolutionControl>>(policy.moduleCacheRules);
        this.artifactCacheRules = new ArrayList<Action<? super ArtifactResolutionControl>>(policy.artifactCacheRules);
    }

    public void setMutationValidator(MutationValidator validator) {
        this.mutationValidator = validator;
    }

    @Override
    public void setOffline() {
        this.eachDependency(ResolutionControl::useCachedResult);
        this.eachModule(ResolutionControl::useCachedResult);
        this.eachArtifact(ResolutionControl::useCachedResult);
    }

    @Override
    public void setRefreshDependencies() {
        this.eachDependency(dependencyResolutionControl -> dependencyResolutionControl.refresh());
        this.eachModule(moduleResolutionControl -> moduleResolutionControl.refresh());
        this.eachArtifact(artifactResolutionControl -> artifactResolutionControl.refresh());
    }

    public void cacheDynamicVersionsFor(int value, TimeUnit unit) {
        this.keepDynamicVersionsFor = unit.toMillis(value);
        this.eachDependency(dependencyResolutionControl -> {
            if (!((Set)dependencyResolutionControl.getCachedResult()).isEmpty()) {
                dependencyResolutionControl.cacheFor(value, unit);
            }
        });
    }

    public void cacheChangingModulesFor(int value, TimeUnit units) {
        this.keepChangingModulesFor = units.toMillis(value);
        this.eachModule(moduleResolutionControl -> {
            if (moduleResolutionControl.isChanging()) {
                moduleResolutionControl.cacheFor(value, units);
            }
        });
        this.eachArtifact(artifactResolutionControl -> {
            if (artifactResolutionControl.belongsToChangingModule()) {
                artifactResolutionControl.cacheFor(value, units);
            }
        });
    }

    private void cacheMissingArtifactsFor(int value, TimeUnit units) {
        this.eachArtifact(artifactResolutionControl -> {
            if (artifactResolutionControl.getCachedResult() == null) {
                artifactResolutionControl.cacheFor(value, units);
            }
        });
    }

    private void eachDependency(Action<? super DependencyResolutionControl> rule) {
        this.mutationValidator.validateMutation(MutationValidator.MutationType.STRATEGY);
        this.dependencyCacheRules.add(0, rule);
    }

    private void eachModule(Action<? super ModuleResolutionControl> rule) {
        this.mutationValidator.validateMutation(MutationValidator.MutationType.STRATEGY);
        this.moduleCacheRules.add(0, rule);
    }

    private void eachArtifact(Action<? super ArtifactResolutionControl> rule) {
        this.mutationValidator.validateMutation(MutationValidator.MutationType.STRATEGY);
        this.artifactCacheRules.add(0, rule);
    }

    @Override
    public Expiry versionListExpiry(ModuleIdentifier moduleIdentifier, Set<ModuleVersionIdentifier> moduleVersions, Duration age) {
        CachedDependencyResolutionControl dependencyResolutionControl = new CachedDependencyResolutionControl(moduleIdentifier, moduleVersions, age.toMillis(), this.keepDynamicVersionsFor);
        for (Action<? super DependencyResolutionControl> rule : this.dependencyCacheRules) {
            rule.execute(dependencyResolutionControl);
            if (!dependencyResolutionControl.ruleMatch()) continue;
            break;
        }
        return dependencyResolutionControl;
    }

    @Override
    public Expiry missingModuleExpiry(ModuleComponentIdentifier component, Duration age) {
        return this.mustRefreshModule(component, null, age, false);
    }

    @Override
    public Expiry moduleExpiry(ModuleComponentIdentifier component, ResolvedModuleVersion resolvedModuleVersion, Duration age) {
        return this.mustRefreshModule(component, resolvedModuleVersion, age, false);
    }

    @Override
    public Expiry moduleExpiry(ResolvedModuleVersion resolvedModuleVersion, Duration age, boolean changing) {
        return this.mustRefreshModule(resolvedModuleVersion.getId(), resolvedModuleVersion, age, changing);
    }

    @Override
    public Expiry changingModuleExpiry(ModuleComponentIdentifier component, ResolvedModuleVersion resolvedModuleVersion, Duration age) {
        return this.mustRefreshModule(component, resolvedModuleVersion, age, true);
    }

    private Expiry mustRefreshModule(ModuleComponentIdentifier component, ResolvedModuleVersion version, Duration age, boolean changingModule) {
        return this.mustRefreshModule(DefaultModuleVersionIdentifier.newId(component.getModuleIdentifier(), component.getVersion()), version, age, changingModule);
    }

    private CachedModuleResolutionControl mustRefreshModule(ModuleVersionIdentifier moduleVersionId, ResolvedModuleVersion version, Duration age, boolean changingModule) {
        CachedModuleResolutionControl moduleResolutionControl = new CachedModuleResolutionControl(moduleVersionId, version, changingModule, age.toMillis(), changingModule ? this.keepChangingModulesFor : Long.MAX_VALUE);
        for (Action<? super ModuleResolutionControl> rule : this.moduleCacheRules) {
            rule.execute(moduleResolutionControl);
            if (!moduleResolutionControl.ruleMatch()) continue;
            break;
        }
        return moduleResolutionControl;
    }

    @Override
    public Expiry moduleArtifactsExpiry(ModuleVersionIdentifier moduleVersionId, Set<ArtifactIdentifier> artifacts2, Duration age, boolean belongsToChangingModule, boolean moduleDescriptorInSync) {
        CachedModuleResolutionControl resolutionControl = this.mustRefreshModule(moduleVersionId, (ResolvedModuleVersion)new DefaultResolvedModuleVersion(moduleVersionId), age, belongsToChangingModule);
        if (belongsToChangingModule && !moduleDescriptorInSync) {
            resolutionControl.refresh();
        }
        return resolutionControl;
    }

    @Override
    public Expiry artifactExpiry(ArtifactIdentifier artifactIdentifier, File cachedArtifactFile, Duration age, boolean belongsToChangingModule, boolean moduleDescriptorInSync) {
        CachedArtifactResolutionControl artifactResolutionControl = new CachedArtifactResolutionControl(artifactIdentifier, cachedArtifactFile, age.toMillis(), this.keepChangingModulesFor, belongsToChangingModule);
        for (Action<? super ArtifactResolutionControl> rule : this.artifactCacheRules) {
            rule.execute(artifactResolutionControl);
            if (!artifactResolutionControl.ruleMatch()) continue;
            break;
        }
        if (belongsToChangingModule && !moduleDescriptorInSync) {
            artifactResolutionControl.refresh();
        }
        return artifactResolutionControl;
    }

    DefaultCachePolicy copy() {
        return new DefaultCachePolicy(this);
    }

    private class CachedArtifactResolutionControl
    extends AbstractResolutionControl<ArtifactIdentifier, File>
    implements ArtifactResolutionControl {
        private final boolean belongsToChangingModule;

        private CachedArtifactResolutionControl(ArtifactIdentifier artifactIdentifier, File cachedResult, long ageMillis, long keepForMillis, boolean belongsToChangingModule) {
            super(artifactIdentifier, cachedResult, ageMillis, keepForMillis);
            this.belongsToChangingModule = belongsToChangingModule;
        }

        @Override
        public boolean belongsToChangingModule() {
            return this.belongsToChangingModule;
        }
    }

    private class CachedModuleResolutionControl
    extends AbstractResolutionControl<ModuleVersionIdentifier, ResolvedModuleVersion>
    implements ModuleResolutionControl {
        private final boolean changing;

        private CachedModuleResolutionControl(ModuleVersionIdentifier moduleVersionId, ResolvedModuleVersion cachedVersion, boolean changing, long ageMillis, long keepForMillis) {
            super(moduleVersionId, cachedVersion, ageMillis, keepForMillis);
            this.changing = changing;
        }

        @Override
        public boolean isChanging() {
            return this.changing;
        }
    }

    private class CachedDependencyResolutionControl
    extends AbstractResolutionControl<ModuleIdentifier, Set<ModuleVersionIdentifier>>
    implements DependencyResolutionControl {
        private CachedDependencyResolutionControl(ModuleIdentifier request, Set<ModuleVersionIdentifier> result, long ageMillis, long keepForMillis) {
            super(request, result, ageMillis, keepForMillis);
        }
    }

    private static abstract class AbstractResolutionControl<A, B>
    implements ResolutionControl<A, B>,
    Expiry {
        private final A request;
        private final B cachedResult;
        private final long ageMillis;
        private long keepForMillis;
        private boolean ruleMatch;
        private boolean mustCheck;

        private AbstractResolutionControl(A request, B cachedResult, long ageMillis, long keepForMillis) {
            this.request = request;
            this.cachedResult = cachedResult;
            this.ageMillis = this.correctForClockShift(ageMillis);
            this.keepForMillis = keepForMillis;
        }

        private long correctForClockShift(long ageMillis) {
            if (ageMillis < 0L) {
                return 1L;
            }
            return ageMillis;
        }

        @Override
        public A getRequest() {
            return this.request;
        }

        @Override
        public B getCachedResult() {
            return this.cachedResult;
        }

        @Override
        public void cacheFor(int value, TimeUnit units) {
            this.keepForMillis = TimeUnit.MILLISECONDS.convert(value, units);
            this.setMustCheck(this.ageMillis > this.keepForMillis);
        }

        @Override
        public void useCachedResult() {
            this.setMustCheck(false);
        }

        @Override
        public void refresh() {
            this.setMustCheck(true);
        }

        private void setMustCheck(boolean val) {
            this.ruleMatch = true;
            this.mustCheck = val;
        }

        public boolean ruleMatch() {
            return this.ruleMatch;
        }

        @Override
        public Duration getKeepFor() {
            if (this.mustCheck && this.ageMillis > 0L) {
                return Duration.ZERO;
            }
            if (this.keepForMillis == Long.MAX_VALUE) {
                return Duration.ofMillis(Long.MAX_VALUE);
            }
            return Duration.ofMillis(Math.max(0L, this.keepForMillis - this.ageMillis));
        }

        @Override
        public boolean isMustCheck() {
            return this.mustCheck && this.ageMillis > 0L;
        }
    }
}

