/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.runtimeshaded;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.ErroringAction;
import org.gradle.internal.IoActions;
import org.gradle.internal.util.Trie;

@CacheableTask
public class PackageListGenerator
extends DefaultTask {
    public static final List<String> DEFAULT_EXCLUDES = Arrays.asList("org/gradle", "java", "javax/annotation", "javax/inject", "javax/xml", "kotlin", "groovy", "groovyjarjarantlr", "net/rubygrapefruit", "org/codehaus/groovy", "org/apache/groovy", "org/apache/tools/ant", "org/apache/commons/logging", "org/slf4j", "org/apache/log4j", "org/apache/xerces", "org/w3c/dom", "org/xml/sax", "sun/misc");
    private File outputFile;
    private FileCollection classpath;
    private List<String> excludes = DEFAULT_EXCLUDES;

    @Classpath
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(FileCollection classpath) {
        this.classpath = classpath;
    }

    @OutputFile
    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    @Input
    public List<String> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    @Inject
    protected DirectoryFileTreeFactory getDirectoryFileTreeFactory() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    public void generate() {
        IoActions.writeTextFile(this.getOutputFile(), (Action<? super BufferedWriter>)new ErroringAction<BufferedWriter>(){

            @Override
            public void doExecute(final BufferedWriter bufferedWriter) throws Exception {
                Trie packages = PackageListGenerator.this.collectPackages();
                packages.dump(false, (Action<? super String>)new ErroringAction<String>(){

                    @Override
                    public void doExecute(String s) throws Exception {
                        bufferedWriter.write(s);
                        bufferedWriter.write(10);
                    }
                });
            }
        });
    }

    private Trie collectPackages() throws IOException {
        Trie.Builder builder = new Trie.Builder();
        for (File file : this.getClasspath()) {
            if (!file.exists()) continue;
            if (file.getName().endsWith(".jar")) {
                this.processJarFile(file, builder);
                continue;
            }
            this.processDirectory(file, builder);
        }
        return builder.build();
    }

    private void processDirectory(File file, final Trie.Builder builder) {
        this.getDirectoryFileTreeFactory().create(file).visit(new FileVisitor(){

            @Override
            public void visitDir(FileVisitDetails dirDetails) {
            }

            @Override
            public void visitFile(FileVisitDetails fileDetails) {
                try {
                    ZipEntry zipEntry = new ZipEntry(fileDetails.getPath());
                    PackageListGenerator.this.processEntry(zipEntry, builder);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        });
    }

    private void processJarFile(File file, final Trie.Builder builder) throws IOException {
        IoActions.withResource(PackageListGenerator.openJarFile(file), new ErroringAction<ZipInputStream>(){

            @Override
            protected void doExecute(ZipInputStream inputStream) throws Exception {
                ZipEntry zipEntry = inputStream.getNextEntry();
                while (zipEntry != null) {
                    PackageListGenerator.this.processEntry(zipEntry, builder);
                    zipEntry = inputStream.getNextEntry();
                }
            }
        });
    }

    private void processEntry(ZipEntry zipEntry, Trie.Builder builder) throws IOException {
        String name = zipEntry.getName();
        if (name.endsWith(".class")) {
            this.processClassFile(zipEntry, builder);
        }
    }

    private void processClassFile(ZipEntry zipEntry, Trie.Builder builder) throws IOException {
        int endIndex = zipEntry.getName().lastIndexOf("/");
        if (endIndex > 0) {
            String packageName = zipEntry.getName().substring(0, endIndex);
            for (String exclude : this.getExcludes()) {
                if (!(packageName + "/").startsWith(exclude + "/")) continue;
                return;
            }
            builder.addWord(packageName);
        }
    }

    private static ZipInputStream openJarFile(File file) throws IOException {
        return new ZipInputStream(new FileInputStream(file));
    }
}

