/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.recomp;

import java.io.File;
import java.util.Collection;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.incremental.compilerapi.deps.DependentsSet;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysis;
import org.gradle.api.internal.tasks.compile.incremental.recomp.CurrentCompilationAccess;
import org.gradle.api.internal.tasks.compile.incremental.recomp.PreviousCompilation;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;

public class CurrentCompilation {
    private final JavaCompileSpec spec;
    private final CurrentCompilationAccess classpathSnapshotter;

    public CurrentCompilation(JavaCompileSpec spec, CurrentCompilationAccess classpathSnapshotter) {
        this.spec = spec;
        this.classpathSnapshotter = classpathSnapshotter;
    }

    public Collection<File> getAnnotationProcessorPath() {
        return this.spec.getAnnotationProcessorPath();
    }

    public DependentsSet findDependentsOfClasspathChanges(PreviousCompilation previous) {
        ClassSetAnalysis currentClasspath = this.getClasspath();
        ClassSetAnalysis previousClasspath = previous.getClasspath();
        if (previousClasspath == null) {
            return DependentsSet.dependencyToAll("classpath data of previous compilation is incomplete");
        }
        ClassSetAnalysis.ClassSetDiff classpathChanges = currentClasspath.findChangesSince(previousClasspath);
        return previous.findDependents(classpathChanges);
    }

    private ClassSetAnalysis getClasspath() {
        return new ClassSetAnalysis(this.classpathSnapshotter.getClasspathSnapshot(Iterables.concat(this.spec.getCompileClasspath(), this.spec.getModulePath())));
    }
}

