/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.internal.tasks.testing.filter.TestSelectionMatcher;
import org.gradle.api.internal.tasks.testing.junit.CategoryFilter;
import org.gradle.api.internal.tasks.testing.junit.JUnitSpec;
import org.gradle.api.internal.tasks.testing.junit.JUnitTestEventAdapter;
import org.gradle.api.internal.tasks.testing.junit.TestClassExecutionListener;
import org.gradle.internal.concurrent.ThreadSafe;
import org.gradle.internal.impldep.org.junit.experimental.runners.Enclosed;
import org.gradle.internal.impldep.org.junit.runner.Description;
import org.gradle.internal.impldep.org.junit.runner.Request;
import org.gradle.internal.impldep.org.junit.runner.RunWith;
import org.gradle.internal.impldep.org.junit.runner.Runner;
import org.gradle.internal.impldep.org.junit.runner.manipulation.Filter;
import org.gradle.internal.impldep.org.junit.runner.manipulation.Filterable;
import org.gradle.internal.impldep.org.junit.runner.manipulation.NoTestsRemainException;
import org.gradle.internal.impldep.org.junit.runner.notification.RunListener;
import org.gradle.internal.impldep.org.junit.runner.notification.RunNotifier;

public class JUnitTestClassExecutor
implements Action<String> {
    private final ClassLoader applicationClassLoader;
    private final RunListener listener;
    private final JUnitSpec options;
    private final TestClassExecutionListener executionListener;

    public JUnitTestClassExecutor(ClassLoader applicationClassLoader, JUnitSpec spec, RunListener listener, TestClassExecutionListener executionListener) {
        assert (executionListener instanceof ThreadSafe);
        this.applicationClassLoader = applicationClassLoader;
        this.listener = listener;
        this.options = spec;
        this.executionListener = executionListener;
    }

    @Override
    public void execute(String testClassName) {
        this.executionListener.testClassStarted(testClassName);
        Throwable failure = null;
        try {
            this.runTestClass(testClassName);
        }
        catch (Throwable throwable) {
            failure = throwable;
        }
        this.executionListener.testClassFinished(failure);
    }

    private void runTestClass(String testClassName) throws ClassNotFoundException {
        Class<?> testClass = Class.forName(testClassName, false, this.applicationClassLoader);
        if (JUnitTestClassExecutor.isNestedClassInsideEnclosedRunner(testClass)) {
            return;
        }
        ArrayList<Filter> filters = new ArrayList<Filter>();
        if (this.options.hasCategoryConfiguration()) {
            this.verifyJUnitCategorySupport();
            filters.add(new CategoryFilter(this.options.getIncludeCategories(), this.options.getExcludeCategories(), this.applicationClassLoader));
        }
        Request request = Request.aClass(testClass);
        Runner runner = request.getRunner();
        if (!(this.options.getIncludedTests().isEmpty() && this.options.getIncludedTestsCommandLine().isEmpty() && this.options.getExcludedTests().isEmpty())) {
            TestSelectionMatcher matcher = new TestSelectionMatcher(this.options.getIncludedTests(), this.options.getExcludedTests(), this.options.getIncludedTestsCommandLine());
            if (!runner.getDescription().isSuite() || !matcher.matchesTest(testClassName, null)) {
                filters.add(new MethodNameFilter(matcher));
            }
        }
        if (runner instanceof Filterable) {
            Filterable filterable = (Filterable)runner;
            for (Filter filter : filters) {
                try {
                    filterable.filter(filter);
                }
                catch (NoTestsRemainException e) {
                    return;
                }
            }
        } else if (this.allTestsFiltered(runner, filters)) {
            return;
        }
        RunNotifier notifier = new RunNotifier();
        notifier.addListener(this.listener);
        runner.run(notifier);
    }

    public static boolean isNestedClassInsideEnclosedRunner(Class<?> testClass) {
        if (testClass.getEnclosingClass() == null) {
            return false;
        }
        Class<?> outermostClass = testClass;
        while (outermostClass.getEnclosingClass() != null) {
            outermostClass = outermostClass.getEnclosingClass();
        }
        RunWith runWith = outermostClass.getAnnotation(RunWith.class);
        return runWith != null && Enclosed.class.equals((Object)runWith.value());
    }

    private void verifyJUnitCategorySupport() {
        try {
            this.applicationClassLoader.loadClass("org.gradle.internal.impldep.org.junit.experimental.categories.Category");
        }
        catch (ClassNotFoundException e) {
            throw new GradleException("JUnit Categories defined but declared JUnit version does not support Categories.");
        }
    }

    private boolean allTestsFiltered(Runner runner, List<Filter> filters) {
        LinkedList<Description> queue = new LinkedList<Description>();
        queue.add(runner.getDescription());
        while (!queue.isEmpty()) {
            Description description = (Description)queue.removeFirst();
            queue.addAll(description.getChildren());
            boolean run2 = true;
            for (Filter filter : filters) {
                if (filter.shouldRun(description)) continue;
                run2 = false;
                break;
            }
            if (!run2) continue;
            return false;
        }
        return true;
    }

    private static class MethodNameFilter
    extends Filter {
        private final TestSelectionMatcher matcher;

        public MethodNameFilter(TestSelectionMatcher matcher) {
            this.matcher = matcher;
        }

        public boolean shouldRun(Description description) {
            if (this.matcher.matchesTest(JUnitTestEventAdapter.className(description), JUnitTestEventAdapter.methodName(description))) {
                return true;
            }
            for (Description child : description.getChildren()) {
                if (!this.shouldRun(child)) continue;
                return true;
            }
            return false;
        }

        public String describe() {
            return "Includes matching test methods";
        }
    }
}

