/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal;

import java.util.List;
import org.gradle.api.tasks.diagnostics.internal.ProjectDetails;
import org.gradle.api.tasks.diagnostics.internal.RuleDetails;
import org.gradle.api.tasks.diagnostics.internal.TaskDetails;
import org.gradle.api.tasks.diagnostics.internal.TextReportRenderer;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.util.internal.CollectionUtils;
import org.gradle.util.internal.GUtil;

public class TaskReportRenderer
extends TextReportRenderer {
    private boolean currentProjectHasTasks;
    private boolean currentProjectHasRules;
    private boolean hasContent;
    private boolean detail;

    @Override
    public void startProject(ProjectDetails project) {
        this.currentProjectHasTasks = false;
        this.currentProjectHasRules = false;
        this.hasContent = false;
        this.detail = false;
        super.startProject(project);
    }

    @Override
    protected String createHeader(ProjectDetails project) {
        String header = super.createHeader(project);
        return "Tasks runnable from " + StringUtils.uncapitalize((String)header);
    }

    public void showDetail(boolean detail) {
        this.detail = detail;
    }

    public void addDefaultTasks(List<String> defaultTaskNames) {
        if (defaultTaskNames.size() > 0) {
            this.getTextOutput().formatln("Default tasks: %s", CollectionUtils.join(", ", defaultTaskNames));
            this.hasContent = true;
        }
    }

    public void startTaskGroup(String taskGroup) {
        if (!GUtil.isTrue(taskGroup)) {
            this.addSubheading("Tasks");
        } else {
            this.addSubheading(StringUtils.capitalize((String)taskGroup) + " tasks");
        }
        this.currentProjectHasTasks = true;
    }

    public void addTask(TaskDetails task) {
        this.writeTask(task, "");
    }

    private void writeTask(TaskDetails task, String prefix) {
        this.getTextOutput().text(prefix);
        this.getTextOutput().withStyle(StyledTextOutput.Style.Identifier).text(task.getPath());
        if (GUtil.isTrue(task.getDescription())) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Description).format(" - %s", task.getDescription());
        }
        this.getTextOutput().println();
    }

    private void addSubheading(String header) {
        if (this.hasContent) {
            this.getTextOutput().println();
        }
        this.hasContent = true;
        this.getBuilder().subheading(header);
    }

    public void completeTasks() {
        if (!this.currentProjectHasTasks) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Info).println("No tasks");
            this.hasContent = true;
        }
    }

    public void addRule(RuleDetails rule) {
        if (!this.currentProjectHasRules) {
            this.addSubheading("Rules");
        }
        this.getTextOutput().println(GUtil.elvis(rule.getDescription(), ""));
        this.currentProjectHasRules = true;
    }

    @Override
    public void complete() {
        if (!this.detail) {
            StyledTextOutput output = this.getTextOutput();
            BuildClientMetaData clientMetaData = this.getClientMetaData();
            output.println();
            output.text("To see all tasks and more detail, run ");
            clientMetaData.describeCommand(output.withStyle(StyledTextOutput.Style.UserInput), "tasks --all");
            output.println();
            output.println();
            output.text("To see more detail about a task, run ");
            clientMetaData.describeCommand(output.withStyle(StyledTextOutput.Style.UserInput), "help --task <task>");
            output.println();
        }
        super.complete();
    }
}

