/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.internal;

import java.io.File;
import java.util.List;
import java.util.Set;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.ide.visualstudio.internal.DefaultVisualStudioProject;
import org.gradle.ide.visualstudio.internal.VisualStudioProjectConfiguration;
import org.gradle.ide.visualstudio.internal.VisualStudioProjectConfigurationMetadata;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.plugins.ide.internal.IdeProjectMetadata;
import org.gradle.util.internal.CollectionUtils;

public class VisualStudioProjectMetadata
implements IdeProjectMetadata {
    private final DefaultVisualStudioProject project;

    public VisualStudioProjectMetadata(DefaultVisualStudioProject project) {
        this.project = project;
    }

    @Override
    public DisplayName getDisplayName() {
        return Describables.withTypeAndName("Visual Studio project", this.project.getName());
    }

    public String getName() {
        return this.project.getName();
    }

    @Override
    public File getFile() {
        return this.project.getProjectFile().getLocation();
    }

    @Override
    public Set<? extends Task> getGeneratorTasks() {
        return this.project.getBuildDependencies().getDependencies(null);
    }

    public List<VisualStudioProjectConfigurationMetadata> getConfigurations() {
        return CollectionUtils.collect(this.project.getConfigurations(), new Transformer<VisualStudioProjectConfigurationMetadata, VisualStudioProjectConfiguration>(){

            @Override
            public VisualStudioProjectConfigurationMetadata transform(VisualStudioProjectConfiguration configuration) {
                return new VisualStudioProjectConfigurationMetadata(configuration.getName(), configuration.isBuildable());
            }
        });
    }
}

