/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.initialization.ConfigurationCache;
import org.gradle.internal.build.BuildModelController;

public class ConfigurationCacheAwareBuildModelController
implements BuildModelController {
    private final GradleInternal model;
    private final BuildModelController delegate;
    private final ConfigurationCache configurationCache;
    private State state = State.Created;

    public ConfigurationCacheAwareBuildModelController(GradleInternal model, BuildModelController delegate, ConfigurationCache configurationCache) {
        this.model = model;
        this.delegate = delegate;
        this.configurationCache = configurationCache;
    }

    @Override
    public SettingsInternal getLoadedSettings() {
        if (this.maybeLoadFromCache()) {
            return this.model.getSettings();
        }
        return this.delegate.getLoadedSettings();
    }

    @Override
    public GradleInternal getConfiguredModel() {
        if (this.maybeLoadFromCache()) {
            throw new IllegalStateException("Cannot query configured model when model has been loaded from configuration cache.");
        }
        return this.delegate.getConfiguredModel();
    }

    @Override
    public void scheduleTasks(Iterable<String> tasks) {
        if (this.maybeLoadFromCache()) {
            throw new IllegalStateException("Cannot schedule specific tasks when model has been loaded from configuration cache.");
        }
        this.delegate.scheduleTasks(tasks);
    }

    @Override
    public void scheduleRequestedTasks() {
        if (!this.maybeLoadFromCache()) {
            this.delegate.scheduleRequestedTasks();
            this.configurationCache.save();
        }
    }

    private boolean maybeLoadFromCache() {
        ConfigurationCacheAwareBuildModelController configurationCacheAwareBuildModelController = this;
        synchronized (configurationCacheAwareBuildModelController) {
            switch (this.state) {
                case Created: {
                    if (this.configurationCache.canLoad()) {
                        this.configurationCache.load();
                        this.state = State.Loaded;
                        return true;
                    }
                    this.configurationCache.prepareForConfiguration();
                    this.state = State.DoNotReuse;
                    return false;
                }
                case Loaded: {
                    return true;
                }
                case DoNotReuse: {
                    return false;
                }
            }
            throw new IllegalStateException();
        }
    }

    private static enum State {
        Created,
        Loaded,
        DoNotReuse;

    }
}

