/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.TaskExecutionRequest;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.collect.Lists;

public class DefaultTaskExecutionRequest
implements TaskExecutionRequest,
Serializable {
    private final List<String> args;
    private final String projectPath;
    private final File rootDir;

    public DefaultTaskExecutionRequest(Iterable<String> args) {
        this(args, null, null);
    }

    public DefaultTaskExecutionRequest(Iterable<String> args, @Nullable String projectPath) {
        this(args, projectPath, null);
    }

    public DefaultTaskExecutionRequest(Iterable<String> args, @Nullable String projectPath, @Nullable File rootDir) {
        this.args = Lists.newArrayList(args);
        this.projectPath = projectPath;
        this.rootDir = rootDir;
    }

    @Override
    public List<String> getArgs() {
        return this.args;
    }

    @Override
    public String getProjectPath() {
        return this.projectPath;
    }

    @Override
    public File getRootDir() {
        return this.rootDir;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultTaskExecutionRequest that = (DefaultTaskExecutionRequest)o;
        if (!Objects.equal((Object)this.projectPath, (Object)that.projectPath)) {
            return false;
        }
        return Objects.equal(this.args, that.args);
    }

    public int hashCode() {
        int result = this.getArgs().hashCode();
        result = 31 * result + (this.projectPath != null ? this.projectPath.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DefaultTaskExecutionRequest{args=" + this.args + ",projectPath='" + this.projectPath + '\'' + ",rootDir='" + this.rootDir + '\'' + '}';
    }
}

