/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import java.util.Optional;
import java.util.SortedMap;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.history.AfterPreviousExecutionState;
import org.gradle.internal.execution.history.ExecutionHistoryStore;
import org.gradle.internal.execution.history.changes.ChangeDetectorVisitor;
import org.gradle.internal.execution.history.changes.OutputFileChanges;
import org.gradle.internal.execution.steps.BeforeExecutionContext;
import org.gradle.internal.execution.steps.CurrentSnapshotResult;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.snapshot.FileSystemSnapshot;

public class StoreExecutionStateStep<C extends BeforeExecutionContext>
implements Step<C, CurrentSnapshotResult> {
    private final Step<? super C, ? extends CurrentSnapshotResult> delegate;

    public StoreExecutionStateStep(Step<? super C, ? extends CurrentSnapshotResult> delegate) {
        this.delegate = delegate;
    }

    @Override
    public CurrentSnapshotResult execute(UnitOfWork work, C context) {
        CurrentSnapshotResult result = this.delegate.execute(work, context);
        UnitOfWork.Identity identity = context.getIdentity();
        context.getHistory().ifPresent(history -> this.storeState(context, (ExecutionHistoryStore)history, identity.getUniqueId(), result));
        return result;
    }

    private void storeState(C context, ExecutionHistoryStore executionHistoryStore, String uniqueId, CurrentSnapshotResult result) {
        ImmutableSortedMap<String, FileSystemSnapshot> outputFilesProducedByWork = result.getOutputFilesProduceByWork();
        context.getBeforeExecutionState().ifPresent(beforeExecutionState -> {
            boolean successful = result.getExecutionResult().isSuccessful();
            if (successful || StoreExecutionStateStep.didChangeOutput(context.getAfterPreviousExecutionState(), outputFilesProducedByWork)) {
                executionHistoryStore.store(uniqueId, result.getOriginMetadata(), beforeExecutionState.getImplementation(), beforeExecutionState.getAdditionalImplementations(), beforeExecutionState.getInputProperties(), beforeExecutionState.getInputFileProperties(), outputFilesProducedByWork, successful);
            }
        });
    }

    private static boolean didChangeOutput(Optional<AfterPreviousExecutionState> afterPreviousExecutionState, ImmutableSortedMap<String, FileSystemSnapshot> current) {
        if (!afterPreviousExecutionState.isPresent()) {
            return true;
        }
        ImmutableSortedMap<String, FileSystemSnapshot> previous = afterPreviousExecutionState.get().getOutputFilesProducedByWork();
        if (!previous.keySet().equals((Object)current.keySet())) {
            return true;
        }
        ChangeDetectorVisitor visitor = new ChangeDetectorVisitor();
        OutputFileChanges changes = new OutputFileChanges((SortedMap<String, FileSystemSnapshot>)previous, (SortedMap<String, FileSystemSnapshot>)current);
        changes.accept(visitor);
        return visitor.hasAnyChanges();
    }
}

