/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.jvm.inspection;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import org.gradle.api.GradleException;
import org.gradle.internal.ErroringAction;
import org.gradle.internal.IoActions;
import org.gradle.internal.impldep.com.google.common.base.Supplier;
import org.gradle.internal.impldep.com.google.common.base.Suppliers;
import org.gradle.internal.impldep.org.objectweb.asm.ClassWriter;
import org.gradle.internal.impldep.org.objectweb.asm.Label;
import org.gradle.internal.impldep.org.objectweb.asm.MethodVisitor;
import org.gradle.internal.jvm.inspection.ProbedSystemProperty;

class MetadataProbe {
    private final Supplier<byte[]> probeClass = Suppliers.memoize(() -> MetadataProbe.createProbeClass());

    MetadataProbe() {
    }

    public File writeClass(File outputDirectory) {
        File probeFile = new File(outputDirectory, "JavaProbe.class");
        try {
            IoActions.withResource(new FileOutputStream(probeFile), new ErroringAction<FileOutputStream>(){

                @Override
                protected void doExecute(FileOutputStream thing) throws Exception {
                    thing.write((byte[])MetadataProbe.this.probeClass.get());
                }
            });
        }
        catch (FileNotFoundException e) {
            throw new GradleException("Unable to write Java probe file", e);
        }
        return probeFile;
    }

    private static byte[] createProbeClass() {
        ClassWriter cw = new ClassWriter(0);
        MetadataProbe.createClassHeader(cw);
        MetadataProbe.createConstructor(cw);
        MetadataProbe.createMainMethod(cw);
        cw.visitEnd();
        return cw.toByteArray();
    }

    private static void createClassHeader(ClassWriter cw) {
        cw.visit(196653, 33, "JavaProbe", null, "java/lang/Object", null);
    }

    private static void createMainMethod(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(9, "main", "([Ljava/lang/String;)V", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        for (ProbedSystemProperty type : ProbedSystemProperty.values()) {
            if (type == ProbedSystemProperty.Z_ERROR) continue;
            MetadataProbe.dumpProperty(mv, type.getSystemPropertyKey());
        }
        mv.visitInsn(177);
        Label l3 = new Label();
        mv.visitLabel(l3);
        mv.visitLocalVariable("args", "[Ljava/lang/String;", null, l0, l3, 0);
        mv.visitMaxs(3, 1);
        mv.visitEnd();
    }

    private static void dumpProperty(MethodVisitor mv, String property) {
        mv.visitFieldInsn(178, "java/lang/System", "out", "Ljava/io/PrintStream;");
        mv.visitLdcInsn((Object)property);
        mv.visitLdcInsn((Object)"unknown");
        mv.visitMethodInsn(184, "java/lang/System", "getProperty", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", false);
        mv.visitMethodInsn(182, "java/io/PrintStream", "println", "(Ljava/lang/String;)V", false);
    }

    private static void createConstructor(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLocalVariable("this", "LJavaProbe;", null, l0, l1, 0);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }
}

