/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.watch.registry.impl;

import java.util.concurrent.BlockingQueue;
import java.util.function.Predicate;
import net.rubygrapefruit.platform.NativeIntegrationUnavailableException;
import net.rubygrapefruit.platform.file.FileEvents;
import net.rubygrapefruit.platform.file.FileWatchEvent;
import net.rubygrapefruit.platform.file.FileWatcher;
import net.rubygrapefruit.platform.internal.jni.WindowsFileEventFunctions;
import org.gradle.internal.watch.registry.FileWatcherUpdater;
import org.gradle.internal.watch.registry.impl.AbstractFileWatcherRegistryFactory;
import org.gradle.internal.watch.registry.impl.HierarchicalFileWatcherUpdater;
import org.gradle.internal.watch.registry.impl.WatchableHierarchies;
import org.gradle.internal.watch.vfs.WatchableFileSystemDetector;

public class WindowsFileWatcherRegistryFactory
extends AbstractFileWatcherRegistryFactory<WindowsFileEventFunctions> {
    private static final int BUFFER_SIZE = 65536;

    public WindowsFileWatcherRegistryFactory(WatchableFileSystemDetector watchableFileSystemDetector, Predicate<String> watchFilter) throws NativeIntegrationUnavailableException {
        super(FileEvents.get(WindowsFileEventFunctions.class), watchableFileSystemDetector, watchFilter);
    }

    @Override
    protected FileWatcher createFileWatcher(BlockingQueue<FileWatchEvent> fileEvents) throws InterruptedException {
        return ((WindowsFileEventFunctions.WatcherBuilder)((WindowsFileEventFunctions)this.fileEventFunctions).newWatcher((BlockingQueue)fileEvents)).withBufferSize(65536).start();
    }

    @Override
    protected FileWatcherUpdater createFileWatcherUpdater(FileWatcher watcher, WatchableHierarchies watchableHierarchies) {
        return new HierarchicalFileWatcherUpdater(watcher, HierarchicalFileWatcherUpdater.FileSystemLocationToWatchValidator.NO_VALIDATION, watchableHierarchies);
    }
}

