/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.io.File;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.Transformer;
import org.gradle.api.internal.provider.DefaultProvider;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.internal.jvm.Jvm;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.install.internal.JavaToolchainProvisioningService;
import org.gradle.jvm.toolchain.internal.CurrentJvmToolchainSpec;
import org.gradle.jvm.toolchain.internal.InstallationLocation;
import org.gradle.jvm.toolchain.internal.JavaInstallationRegistry;
import org.gradle.jvm.toolchain.internal.JavaToolchain;
import org.gradle.jvm.toolchain.internal.JavaToolchainComparator;
import org.gradle.jvm.toolchain.internal.JavaToolchainFactory;
import org.gradle.jvm.toolchain.internal.JavaToolchainInput;
import org.gradle.jvm.toolchain.internal.NoToolchainAvailableException;
import org.gradle.jvm.toolchain.internal.SpecificInstallationToolchainSpec;
import org.gradle.jvm.toolchain.internal.ToolchainMatcher;
import org.gradle.jvm.toolchain.internal.ToolchainSpecInternal;

public class JavaToolchainQueryService {
    private final JavaInstallationRegistry registry;
    private final JavaToolchainFactory toolchainFactory;
    private final JavaToolchainProvisioningService installService;
    private final Provider<Boolean> detectEnabled;
    private final Provider<Boolean> downloadEnabled;
    private final Map<JavaToolchainSpec, JavaToolchain> matchingToolchains;

    @Inject
    public JavaToolchainQueryService(JavaInstallationRegistry registry, JavaToolchainFactory toolchainFactory, JavaToolchainProvisioningService provisioningService, ProviderFactory factory) {
        this.registry = registry;
        this.toolchainFactory = toolchainFactory;
        this.installService = provisioningService;
        this.detectEnabled = factory.gradleProperty("org.gradle.java.installations.auto-detect").forUseAtConfigurationTime().map(Boolean::parseBoolean);
        this.downloadEnabled = factory.gradleProperty("org.gradle.java.installations.auto-download").forUseAtConfigurationTime().map(Boolean::parseBoolean);
        this.matchingToolchains = new ConcurrentHashMap<JavaToolchainSpec, JavaToolchain>();
    }

    <T> Provider<T> toolFor(JavaToolchainSpec spec, Transformer<T, JavaToolchain> toolFunction) {
        return this.findMatchingToolchain(spec).map(toolFunction);
    }

    Provider<JavaToolchain> findMatchingToolchain(JavaToolchainSpec filter) {
        return new DefaultProvider<JavaToolchain>(() -> {
            if (((ToolchainSpecInternal)filter).isConfigured()) {
                return this.matchingToolchains.computeIfAbsent(filter, k -> this.query((JavaToolchainSpec)k));
            }
            return null;
        });
    }

    private JavaToolchain query(JavaToolchainSpec filter) {
        if (filter instanceof CurrentJvmToolchainSpec) {
            return this.asToolchain(Jvm.current().getJavaHome(), filter).get();
        }
        if (filter instanceof SpecificInstallationToolchainSpec) {
            return this.asToolchain(((SpecificInstallationToolchainSpec)filter).getJavaHome(), filter).get();
        }
        return this.registry.listInstallations().stream().map(InstallationLocation::getLocation).map(javaHome -> this.asToolchain((File)javaHome, filter)).filter(Optional::isPresent).map(Optional::get).filter(new ToolchainMatcher(filter)).sorted(new JavaToolchainComparator()).findFirst().orElseGet(() -> this.downloadToolchain(filter));
    }

    private JavaToolchain downloadToolchain(JavaToolchainSpec spec) {
        Optional<File> installation = this.installService.tryInstall(spec);
        Optional toolchain = installation.map(home -> this.asToolchain((File)home, spec)).orElseThrow(this.noToolchainAvailable(spec));
        return (JavaToolchain)toolchain.orElseThrow(this.provisionedToolchainIsInvalid(installation::get));
    }

    private Supplier<GradleException> noToolchainAvailable(JavaToolchainSpec spec) {
        return () -> new NoToolchainAvailableException(spec, this.detectEnabled.getOrElse(true), this.downloadEnabled.getOrElse(true));
    }

    private Supplier<GradleException> provisionedToolchainIsInvalid(Supplier<File> javaHome) {
        return () -> new GradleException("Provisioned toolchain '" + javaHome.get() + "' could not be probed.");
    }

    private Optional<JavaToolchain> asToolchain(File javaHome, JavaToolchainSpec spec) {
        return this.toolchainFactory.newInstance(javaHome, new JavaToolchainInput(spec));
    }
}

