/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal.task;

import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.impldep.com.google.common.base.Strings;
import org.gradle.internal.jvm.inspection.JvmInstallationMetadata;
import org.gradle.internal.jvm.inspection.JvmMetadataDetector;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.jvm.toolchain.internal.InstallationLocation;
import org.gradle.jvm.toolchain.internal.JavaInstallationRegistry;
import org.gradle.jvm.toolchain.internal.task.ReportableToolchain;
import org.gradle.jvm.toolchain.internal.task.ToolchainReportRenderer;

public class ShowToolchainsTask
extends DefaultTask {
    private static final Comparator<ReportableToolchain> TOOLCHAIN_COMPARATOR = Comparator.comparing(t -> t.metadata.getDisplayName()).thenComparing(t -> t.metadata.getLanguageVersion());
    private final ToolchainReportRenderer toolchainRenderer = new ToolchainReportRenderer();

    public ShowToolchainsTask() {
        this.getOutputs().upToDateWhen(element -> false);
    }

    @TaskAction
    public void showToolchains() {
        StyledTextOutput output = this.getTextOutputFactory().create(this.getClass());
        this.toolchainRenderer.setOutput(output);
        output.println();
        List<ReportableToolchain> toolchains = this.allReportableToolchains();
        List<ReportableToolchain> validToolchains = this.validToolchains(toolchains);
        List<ReportableToolchain> invalidToolchains = this.invalidToolchains(toolchains);
        this.printOptions(output);
        validToolchains.forEach(this.toolchainRenderer::printToolchain);
        this.toolchainRenderer.printInvalidToolchains(invalidToolchains);
    }

    private void printOptions(StyledTextOutput output) {
        boolean detectionEnabled = this.getBooleanProperty("org.gradle.java.installations.auto-detect");
        boolean downloadEnabled = this.getBooleanProperty("org.gradle.java.installations.auto-download");
        output.withStyle(StyledTextOutput.Style.Identifier).println(" + Options");
        output.withStyle(StyledTextOutput.Style.Normal).format("     | %s", Strings.padEnd((String)"Auto-detection:", (int)20, (char)' '));
        output.withStyle(StyledTextOutput.Style.Description).println(detectionEnabled ? "Enabled" : "Disabled");
        output.withStyle(StyledTextOutput.Style.Normal).format("     | %s", Strings.padEnd((String)"Auto-download:", (int)20, (char)' '));
        output.withStyle(StyledTextOutput.Style.Description).println(downloadEnabled ? "Enabled" : "Disabled");
        output.println();
    }

    private Boolean getBooleanProperty(String propertyKey) {
        return this.getProviderFactory().gradleProperty(propertyKey).forUseAtConfigurationTime().map(Boolean::parseBoolean).getOrElse(true);
    }

    private List<ReportableToolchain> invalidToolchains(List<ReportableToolchain> toolchains) {
        return toolchains.stream().filter(t -> !this.isValidToolchain().test((ReportableToolchain)t)).collect(Collectors.toList());
    }

    private List<ReportableToolchain> validToolchains(List<ReportableToolchain> toolchains) {
        return toolchains.stream().filter(this.isValidToolchain()).sorted(TOOLCHAIN_COMPARATOR).collect(Collectors.toList());
    }

    private Predicate<? super ReportableToolchain> isValidToolchain() {
        return t -> t.metadata.isValidInstallation();
    }

    private List<ReportableToolchain> allReportableToolchains() {
        return this.getInstallationRegistry().listInstallations().parallelStream().map(this::asReportableToolchain).collect(Collectors.toList());
    }

    private ReportableToolchain asReportableToolchain(InstallationLocation location) {
        JvmInstallationMetadata metadata = this.getMetadataDetector().getMetadata(location.getLocation());
        return new ReportableToolchain(metadata, location);
    }

    @Inject
    protected JavaInstallationRegistry getInstallationRegistry() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected JvmMetadataDetector getMetadataDetector() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected StyledTextOutputFactory getTextOutputFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ProviderFactory getProviderFactory() {
        throw new UnsupportedOperationException();
    }
}

