/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.internal.tasks;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.execution.history.OutputsCleaner;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.file.FileType;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;

public abstract class StaleOutputCleaner {
    @CheckReturnValue
    public static boolean cleanOutputs(Deleter deleter, Iterable<File> filesToDelete, File directoryToClean) {
        return StaleOutputCleaner.cleanOutputs(deleter, filesToDelete, (ImmutableSet<File>)ImmutableSet.of((Object)directoryToClean));
    }

    @CheckReturnValue
    public static boolean cleanOutputs(Deleter deleter, Iterable<File> filesToDelete, ImmutableSet<File> directoriesToClean) {
        Set prefixes = directoriesToClean.stream().map(directoryToClean -> directoryToClean.getAbsolutePath() + File.separator).collect(Collectors.toSet());
        OutputsCleaner outputsCleaner = new OutputsCleaner(deleter, file -> {
            String absolutePath = file.getAbsolutePath();
            return prefixes.stream().anyMatch(absolutePath::startsWith);
        }, dir -> !directoriesToClean.contains(dir));
        try {
            for (File f : filesToDelete) {
                if (!f.isFile()) continue;
                outputsCleaner.cleanupOutput(f, FileType.RegularFile);
            }
            outputsCleaner.cleanupDirectories();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to clean up stale outputs", e);
        }
        return outputsCleaner.getDidWork();
    }
}

