/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.toolchain.internal.SystemLibraries;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsKitInstall;
import org.gradle.util.internal.VersionNumber;

public class UcrtInstall
extends WindowsKitInstall {
    public UcrtInstall(File baseDir, VersionNumber version, String name) {
        super(baseDir, version, name);
    }

    public SystemLibraries getCRuntime(NativePlatformInternal platform) {
        if (platform.getArchitecture().isAmd64()) {
            return new UcrtSystemLibraries("x64");
        }
        if (platform.getArchitecture().isArm()) {
            return new UcrtSystemLibraries("arm");
        }
        if (platform.getArchitecture().isI386()) {
            return new UcrtSystemLibraries("x86");
        }
        throw new UnsupportedOperationException(String.format("Supported %s for %s.", platform.getArchitecture().getDisplayName(), this.toString()));
    }

    private class UcrtSystemLibraries
    implements SystemLibraries {
        private final String platformDirName;

        UcrtSystemLibraries(String platformDirName) {
            this.platformDirName = platformDirName;
        }

        @Override
        public List<File> getIncludeDirs() {
            return Collections.singletonList(new File(UcrtInstall.this.getBaseDir(), "Include/" + UcrtInstall.this.getVersion() + "/ucrt"));
        }

        @Override
        public List<File> getLibDirs() {
            return Collections.singletonList(new File(UcrtInstall.this.getBaseDir(), "Lib/" + UcrtInstall.this.getVersion() + "/ucrt/" + this.platformDirName));
        }

        @Override
        public Map<String, String> getPreprocessorMacros() {
            return Collections.emptyMap();
        }
    }
}

