/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.signing;

import groovy.lang.Closure;
import java.io.File;
import java.util.Date;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.gradle.api.Buildable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.internal.artifacts.publish.AbstractPublishArtifact;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.impldep.com.google.common.util.concurrent.Callables;
import org.gradle.plugins.signing.SignatureSpec;
import org.gradle.plugins.signing.signatory.Signatory;
import org.gradle.plugins.signing.type.SignatureType;
import org.gradle.util.internal.GUtil;

public class Signature
extends AbstractPublishArtifact {
    private SignatureSpec signatureSpec;
    private Buildable source;
    private String name;
    private String extension;
    private String type;
    private String classifier;
    private Date date;
    private Callable<File> toSignGenerator;
    private Callable<String> classifierGenerator;
    private Callable<String> nameGenerator;

    public Signature(final PublishArtifact toSign, SignatureSpec signatureSpec, Object ... tasks) {
        this((Buildable)toSign, new Callable<File>(){

            @Override
            public File call() {
                return toSign.getFile();
            }
        }, new Callable<String>(){

            @Override
            public String call() {
                return toSign.getClassifier();
            }
        }, new Callable<String>(){

            @Override
            public String call() {
                return toSign.getName();
            }
        }, signatureSpec, tasks);
    }

    Signature(Buildable source, Callable<File> toSign, Callable<String> classifier, Callable<String> name, SignatureSpec signatureSpec, Object ... tasks) {
        super(tasks);
        this.init(toSign, classifier, name, signatureSpec);
        this.source = source;
    }

    public Signature(File toSign, SignatureSpec signatureSpec, Object ... tasks) {
        super(tasks);
        this.init(Callables.returning((Object)toSign), null, null, signatureSpec);
    }

    public Signature(File toSign, String classifier, SignatureSpec signatureSpec, Object ... tasks) {
        super(tasks);
        this.init(Callables.returning((Object)toSign), Callables.returning((Object)classifier), null, signatureSpec);
    }

    public Signature(Closure<File> toSign, Closure<String> classifier, SignatureSpec signatureSpec, Object ... tasks) {
        super(tasks);
        this.toSignGenerator = toSign;
        this.classifierGenerator = classifier;
        this.signatureSpec = signatureSpec;
    }

    public Signature(Callable<File> toSign, Callable<String> classifier, SignatureSpec signatureSpec, Object ... tasks) {
        super(tasks);
        this.toSignGenerator = toSign;
        this.classifierGenerator = classifier;
        this.signatureSpec = signatureSpec;
    }

    private void init(Callable<File> toSign, Callable<String> classifier, Callable<String> name, SignatureSpec signatureSpec) {
        this.toSignGenerator = toSign;
        this.classifierGenerator = classifier;
        this.nameGenerator = name;
        this.signatureSpec = signatureSpec;
    }

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    public File getToSign() {
        File toSign = GUtil.uncheckedCall(this.toSignGenerator);
        return toSign != null ? toSign : null;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    @Internal
    public String getName() {
        return this.name != null ? this.name : this.defaultName();
    }

    @Nullable
    private String defaultName() {
        return this.nameGenerator != null ? GUtil.uncheckedCall(this.nameGenerator) : this.fileName();
    }

    @Nullable
    private String fileName() {
        File file = this.getFile();
        return file != null ? file.getName() : null;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    @Override
    @Internal
    public String getExtension() {
        return this.extension != null ? this.extension : this.signatureTypeExtension();
    }

    @Nullable
    private String signatureTypeExtension() {
        SignatureType signatureType = this.getSignatureType();
        return signatureType != null ? signatureType.getExtension() : null;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    @Internal
    public String getType() {
        return this.type != null ? this.type : this.defaultType();
    }

    @Nullable
    private String defaultType() {
        File toSign = this.getToSign();
        SignatureType signatureType = this.getSignatureType();
        return toSign != null && signatureType != null ? signatureType.combinedExtension(toSign) : null;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    @Override
    @Internal
    public String getClassifier() {
        return this.classifier != null ? this.classifier : this.defaultClassifier();
    }

    private String defaultClassifier() {
        return this.classifierGenerator == null ? null : GUtil.uncheckedCall(this.classifierGenerator);
    }

    public void setDate(Date date) {
        this.date = date;
    }

    @Override
    @Internal
    public Date getDate() {
        return this.date != null ? this.date : this.defaultDate();
    }

    @Nullable
    private Date defaultDate() {
        File file = this.getFile();
        if (file == null) {
            return null;
        }
        long modified = file.lastModified();
        if (modified == 0L) {
            return null;
        }
        return new Date(modified);
    }

    @Override
    @OutputFile
    public File getFile() {
        File toSign = this.getToSign();
        SignatureType signatureType = this.getSignatureType();
        return toSign != null && signatureType != null ? signatureType.fileFor(toSign) : null;
    }

    @Internal(value="already tracked as part of the Sign task")
    public Signatory getSignatory() {
        return this.signatureSpec.getSignatory();
    }

    @Internal(value="already tracked as part of the Sign task")
    public SignatureType getSignatureType() {
        return this.signatureSpec.getSignatureType();
    }

    public void setSignatureSpec(SignatureSpec signatureSpec) {
        this.signatureSpec = signatureSpec;
    }

    @Internal
    public SignatureSpec getSignatureSpec() {
        return this.signatureSpec;
    }

    @Internal
    Buildable getSource() {
        return this.source;
    }

    @Override
    @Internal
    public TaskDependency getBuildDependencies() {
        return super.getBuildDependencies();
    }

    String toKey() {
        return String.join((CharSequence)":", this.getName(), this.getType(), this.getExtension(), this.getClassifier());
    }

    public void generate() {
        File toSign = this.getToSign();
        if (toSign == null) {
            if (this.signatureSpec.isRequired()) {
                throw new InvalidUserDataException("Unable to generate signature as the file to sign has not been specified");
            }
            return;
        }
        Signatory signatory = this.getSignatory();
        if (signatory == null) {
            if (this.signatureSpec.isRequired()) {
                throw new InvalidUserDataException("Unable to generate signature for '" + toSign + "' as no signatory is available to sign");
            }
            return;
        }
        SignatureType signatureType = this.getSignatureType();
        if (signatureType == null) {
            if (this.signatureSpec.isRequired()) {
                throw new InvalidUserDataException("Unable to generate signature for '" + toSign + "' as no signature type has been configured");
            }
            return;
        }
        signatureType.sign(signatory, toSign);
    }

    @Override
    public boolean shouldBePublished() {
        return true;
    }
}

