/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.process.JavaDebugOptions;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.internal.DefaultJavaDebugOptions;
import org.gradle.util.internal.ArgumentsSplitter;
import org.gradle.util.internal.GUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JvmOptions {
    private static final String XMS_PREFIX = "-Xms";
    private static final String XMX_PREFIX = "-Xmx";
    private static final String BOOTCLASSPATH_PREFIX = "-Xbootclasspath:";
    public static final String FILE_ENCODING_KEY = "file.encoding";
    public static final String USER_LANGUAGE_KEY = "user.language";
    public static final String USER_COUNTRY_KEY = "user.country";
    public static final String USER_VARIANT_KEY = "user.variant";
    public static final String JMX_REMOTE_KEY = "com.sun.management.jmxremote";
    public static final String JAVA_IO_TMPDIR_KEY = "java.io.tmpdir";
    private static final Logger LOGGER = LoggerFactory.getLogger(JvmOptions.class);
    public static final Set<String> IMMUTABLE_SYSTEM_PROPERTIES = ImmutableSet.of((Object)"file.encoding", (Object)"user.language", (Object)"user.country", (Object)"user.variant", (Object)"com.sun.management.jmxremote", (Object)"java.io.tmpdir", (Object[])new String[0]);
    private static final Locale DEFAULT_LOCALE = Locale.getDefault();
    private final List<Object> extraJvmArgs = new ArrayList<Object>();
    private final Map<String, Object> mutableSystemProperties = new TreeMap<String, Object>();
    private final FileCollectionFactory fileCollectionFactory;
    private ConfigurableFileCollection bootstrapClasspath;
    private String minHeapSize;
    private String maxHeapSize;
    private boolean assertionsEnabled;
    private final JavaDebugOptions debugOptions;
    protected final Map<String, Object> immutableSystemProperties = new TreeMap<String, Object>();

    public JvmOptions(FileCollectionFactory fileCollectionFactory, JavaDebugOptions debugOptions) {
        this.debugOptions = debugOptions;
        this.fileCollectionFactory = fileCollectionFactory;
        this.immutableSystemProperties.put(FILE_ENCODING_KEY, Charset.defaultCharset().name());
        this.immutableSystemProperties.put(USER_LANGUAGE_KEY, DEFAULT_LOCALE.getLanguage());
        this.immutableSystemProperties.put(USER_COUNTRY_KEY, DEFAULT_LOCALE.getCountry());
        this.immutableSystemProperties.put(USER_VARIANT_KEY, DEFAULT_LOCALE.getVariant());
    }

    public JvmOptions(FileCollectionFactory fileCollectionFactory) {
        this(fileCollectionFactory, new DefaultJavaDebugOptions());
    }

    public List<String> getAllJvmArgs() {
        LinkedList<String> args = new LinkedList<String>();
        this.formatSystemProperties(this.getMutableSystemProperties(), args);
        args.addAll(this.getAllImmutableJvmArgs());
        return args;
    }

    protected void formatSystemProperties(Map<String, ?> properties, List<String> args) {
        for (Map.Entry<String, ?> entry : properties.entrySet()) {
            if (entry.getValue() != null && entry.getValue().toString().length() > 0) {
                args.add("-D" + entry.getKey() + "=" + entry.getValue().toString());
                continue;
            }
            args.add("-D" + entry.getKey());
        }
    }

    public List<String> getAllImmutableJvmArgs() {
        ArrayList<String> args = new ArrayList<String>(this.getJvmArgs());
        args.addAll(this.getManagedJvmArgs());
        return args;
    }

    public List<String> getManagedJvmArgs() {
        ArrayList<String> args = new ArrayList<String>();
        if (this.minHeapSize != null) {
            args.add(XMS_PREFIX + this.minHeapSize);
        }
        if (this.maxHeapSize != null) {
            args.add(XMX_PREFIX + this.maxHeapSize);
        }
        if (this.bootstrapClasspath != null && !this.bootstrapClasspath.isEmpty()) {
            args.add(BOOTCLASSPATH_PREFIX + this.bootstrapClasspath.getAsPath());
        }
        this.formatSystemProperties(this.immutableSystemProperties, args);
        if (this.assertionsEnabled) {
            args.add("-ea");
        }
        if (((Boolean)this.debugOptions.getEnabled().get()).booleanValue()) {
            boolean server = (Boolean)this.debugOptions.getServer().get();
            boolean suspend = (Boolean)this.debugOptions.getSuspend().get();
            int port = (Integer)this.debugOptions.getPort().get();
            args.add("-agentlib:jdwp=transport=dt_socket,server=" + (server ? (char)'y' : 'n') + ",suspend=" + (suspend ? (char)'y' : 'n') + ",address=" + port);
        }
        return args;
    }

    public void setAllJvmArgs(Iterable<?> arguments) {
        this.mutableSystemProperties.clear();
        this.minHeapSize = null;
        this.maxHeapSize = null;
        this.extraJvmArgs.clear();
        this.assertionsEnabled = false;
        this.debugOptions.getEnabled().set(false);
        this.jvmArgs(arguments);
    }

    public List<String> getJvmArgs() {
        ArrayList<String> args = new ArrayList<String>();
        for (Object extraJvmArg : this.extraJvmArgs) {
            args.add(extraJvmArg.toString());
        }
        return args;
    }

    public void setJvmArgs(Iterable<?> arguments) {
        this.extraJvmArgs.clear();
        this.jvmArgs(arguments);
    }

    public void jvmArgs(Iterable<?> arguments) {
        for (Object argument : arguments) {
            String argStr = argument.toString();
            if (argStr.equals("-ea") || argStr.equals("-enableassertions")) {
                this.assertionsEnabled = true;
                continue;
            }
            if (argStr.equals("-da") || argStr.equals("-disableassertions")) {
                this.assertionsEnabled = false;
                continue;
            }
            if (argStr.startsWith(XMS_PREFIX)) {
                this.minHeapSize = argStr.substring(XMS_PREFIX.length());
                continue;
            }
            if (argStr.startsWith(XMX_PREFIX)) {
                this.maxHeapSize = argStr.substring(XMX_PREFIX.length());
                continue;
            }
            if (argStr.startsWith(BOOTCLASSPATH_PREFIX)) {
                String[] bootClasspath = StringUtils.split((String)argStr.substring(BOOTCLASSPATH_PREFIX.length()), (char)File.pathSeparatorChar);
                this.setBootstrapClasspath(bootClasspath);
                continue;
            }
            if (argStr.startsWith("-D")) {
                String keyValue = argStr.substring(2);
                int equalsIndex = keyValue.indexOf("=");
                if (equalsIndex == -1) {
                    this.systemProperty(keyValue, "");
                    continue;
                }
                this.systemProperty(keyValue.substring(0, equalsIndex), keyValue.substring(equalsIndex + 1));
                continue;
            }
            this.extraJvmArgs.add(argument);
        }
        ArrayList<String> debugArgs = new ArrayList<String>();
        for (Object extraJvmArg : this.extraJvmArgs) {
            String extraJvmArgString = extraJvmArg.toString();
            if (!extraJvmArgString.equals("-Xdebug") && !extraJvmArgString.startsWith("-Xrunjdwp") && !extraJvmArgString.startsWith("-agentlib:jdwp")) continue;
            debugArgs.add(extraJvmArgString);
        }
        if (!debugArgs.isEmpty() && ((Boolean)this.debugOptions.getEnabled().get()).booleanValue()) {
            LOGGER.warn("Debug configuration ignored in favor of the supplied JVM arguments: " + debugArgs);
            this.debugOptions.getEnabled().set(false);
        }
    }

    public void jvmArgs(Object ... arguments) {
        this.jvmArgs(Arrays.asList(arguments));
    }

    public Map<String, Object> getMutableSystemProperties() {
        return this.mutableSystemProperties;
    }

    public Map<String, Object> getImmutableSystemProperties() {
        return this.immutableSystemProperties;
    }

    public void setSystemProperties(Map<String, ?> properties) {
        this.mutableSystemProperties.clear();
        this.systemProperties(properties);
    }

    public void systemProperties(Map<String, ?> properties) {
        for (Map.Entry<String, ?> entry : properties.entrySet()) {
            this.systemProperty(entry.getKey(), entry.getValue());
        }
    }

    public void systemProperty(String name, Object value) {
        if (IMMUTABLE_SYSTEM_PROPERTIES.contains(name)) {
            this.immutableSystemProperties.put(name, value);
        } else {
            this.mutableSystemProperties.put(name, value);
        }
    }

    public FileCollection getBootstrapClasspath() {
        return this.internalGetBootstrapClasspath();
    }

    private ConfigurableFileCollection internalGetBootstrapClasspath() {
        if (this.bootstrapClasspath == null) {
            this.bootstrapClasspath = this.fileCollectionFactory.configurableFiles("bootstrap classpath");
        }
        return this.bootstrapClasspath;
    }

    public void setBootstrapClasspath(FileCollection classpath) {
        this.internalGetBootstrapClasspath().setFrom(classpath);
    }

    public void setBootstrapClasspath(Object ... classpath) {
        this.internalGetBootstrapClasspath().setFrom(classpath);
    }

    public void bootstrapClasspath(Object ... classpath) {
        this.internalGetBootstrapClasspath().from(classpath);
    }

    public String getMinHeapSize() {
        return this.minHeapSize;
    }

    public void setMinHeapSize(String heapSize) {
        this.minHeapSize = heapSize;
    }

    public String getMaxHeapSize() {
        return this.maxHeapSize;
    }

    public void setMaxHeapSize(String heapSize) {
        this.maxHeapSize = heapSize;
    }

    public String getDefaultCharacterEncoding() {
        return this.immutableSystemProperties.get(FILE_ENCODING_KEY).toString();
    }

    public void setDefaultCharacterEncoding(String defaultCharacterEncoding) {
        this.immutableSystemProperties.put(FILE_ENCODING_KEY, GUtil.isTrue(defaultCharacterEncoding) ? defaultCharacterEncoding : Charset.defaultCharset().name());
    }

    public boolean getEnableAssertions() {
        return this.assertionsEnabled;
    }

    public void setEnableAssertions(boolean enabled) {
        this.assertionsEnabled = enabled;
    }

    public boolean getDebug() {
        return (Boolean)this.debugOptions.getEnabled().get();
    }

    public void setDebug(boolean enabled) {
        this.debugOptions.getEnabled().set(enabled);
    }

    public JavaDebugOptions getDebugOptions() {
        return this.debugOptions;
    }

    public void copyTo(JavaForkOptions target) {
        target.setJvmArgs((Iterable<?>)this.extraJvmArgs);
        target.setSystemProperties(this.mutableSystemProperties);
        target.setMinHeapSize(this.minHeapSize);
        target.setMaxHeapSize(this.maxHeapSize);
        target.bootstrapClasspath(this.getBootstrapClasspath().getFiles());
        target.setEnableAssertions(this.assertionsEnabled);
        this.copyDebugOptionsTo(target.getDebugOptions());
        target.systemProperties(this.immutableSystemProperties);
    }

    public JvmOptions createCopy() {
        JvmOptions target = new JvmOptions(this.fileCollectionFactory);
        target.setJvmArgs(this.extraJvmArgs);
        target.setSystemProperties(this.mutableSystemProperties);
        target.setMinHeapSize(this.minHeapSize);
        target.setMaxHeapSize(this.maxHeapSize);
        if (this.bootstrapClasspath != null) {
            target.setBootstrapClasspath(this.getBootstrapClasspath().getFiles());
        }
        target.setEnableAssertions(this.assertionsEnabled);
        this.copyDebugOptionsTo(target.getDebugOptions());
        target.systemProperties(this.immutableSystemProperties);
        return target;
    }

    private void copyDebugOptionsTo(JavaDebugOptions otherOptions) {
        otherOptions.getEnabled().set((Boolean)this.debugOptions.getEnabled().get());
        otherOptions.getPort().set((Integer)this.debugOptions.getPort().get());
        otherOptions.getServer().set((Boolean)this.debugOptions.getServer().get());
        otherOptions.getSuspend().set((Boolean)this.debugOptions.getSuspend().get());
    }

    public static List<String> fromString(String input) {
        return ArgumentsSplitter.split(input);
    }
}

