/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.psi.impl;

import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.lexer.YAMLGrammarCharUtil;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YamlPsiElementVisitor;
import org.jetbrains.yaml.psi.impl.YAMLValueImpl;
import org.jetbrains.yaml.psi.impl.YamlScalarTextEvaluator;

public abstract class YAMLScalarImpl
extends YAMLValueImpl
implements YAMLScalar {
    protected static final int MAX_SCALAR_LENGTH_PREDEFINED = 60;

    public YAMLScalarImpl(@NotNull ASTNode node) {
        if (node == null) {
            YAMLScalarImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @NotNull
    public abstract List<TextRange> getContentRanges();

    @NotNull
    public abstract YamlScalarTextEvaluator getTextEvaluator();

    protected List<Pair<TextRange, String>> getDecodeReplacements(@NotNull CharSequence input) {
        if (input == null) {
            YAMLScalarImpl.$$$reportNull$$$0(1);
        }
        return Collections.emptyList();
    }

    protected List<Pair<TextRange, String>> getEncodeReplacements(@NotNull CharSequence input) throws IllegalArgumentException {
        if (input == null) {
            YAMLScalarImpl.$$$reportNull$$$0(2);
        }
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public final String getTextValue() {
        String string = this.getTextEvaluator().getTextValue(null);
        if (string == null) {
            YAMLScalarImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public final String getTextValue(@Nullable TextRange rangeInHost) {
        String string = this.getTextEvaluator().getTextValue(rangeInHost);
        if (string == null) {
            YAMLScalarImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    public PsiReference getReference() {
        PsiReference[] references = this.getReferences();
        return references.length == 1 ? references[0] : null;
    }

    public PsiReference @NotNull [] getReferences() {
        PsiReference[] psiReferenceArray = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this);
        if (psiReferenceArray == null) {
            YAMLScalarImpl.$$$reportNull$$$0(5);
        }
        return psiReferenceArray;
    }

    public boolean isValidHost() {
        return true;
    }

    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        if (text == null) {
            YAMLScalarImpl.$$$reportNull$$$0(6);
        }
        return (PsiLanguageInjectionHost)ElementManipulators.handleContentChange((PsiElement)this, (String)text);
    }

    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        return new MyLiteralTextEscaper(this);
    }

    @NotNull
    static String processReplacements(@NotNull CharSequence input, @NotNull List<? extends Pair<TextRange, String>> replacements) throws IndexOutOfBoundsException {
        if (input == null) {
            YAMLScalarImpl.$$$reportNull$$$0(7);
        }
        if (replacements == null) {
            YAMLScalarImpl.$$$reportNull$$$0(8);
        }
        StringBuilder result = new StringBuilder();
        int currentOffset = 0;
        for (Pair<TextRange, String> pair : replacements) {
            result.append(input.subSequence(currentOffset, ((TextRange)pair.getFirst()).getStartOffset()));
            result.append((String)pair.getSecond());
            currentOffset = ((TextRange)pair.getFirst()).getEndOffset();
        }
        result.append(input.subSequence(currentOffset, input.length()));
        String string = result.toString();
        if (string == null) {
            YAMLScalarImpl.$$$reportNull$$$0(9);
        }
        return string;
    }

    protected static boolean isSurroundedByNoSpace(CharSequence text, int pos) {
        return !(pos - 1 >= 0 && YAMLGrammarCharUtil.isSpaceLike(text.charAt(pos - 1)) || pos + 1 < text.length() && YAMLGrammarCharUtil.isSpaceLike(text.charAt(pos + 1)));
    }

    @Nullable
    protected final ASTNode getFirstContentNode() {
        ASTNode node;
        for (node = this.getNode().getFirstChildNode(); node != null && (node.getElementType() == YAMLTokenTypes.TAG || YAMLElementTypes.BLANK_ELEMENTS.contains(node.getElementType())); node = node.getTreeNext()) {
        }
        return node;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            YAMLScalarImpl.$$$reportNull$$$0(10);
        }
        if (visitor instanceof YamlPsiElementVisitor) {
            ((YamlPsiElementVisitor)visitor).visitScalar(this);
        } else {
            super.accept(visitor);
        }
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            @NotNull
            public String getPresentableText() {
                String string = StringUtil.shortenTextWithEllipsis((String)YAMLScalarImpl.this.getTextValue(), (int)20, (int)0, (boolean)true);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getLocationString() {
                String string = YAMLScalarImpl.this.getContainingFile().getName();
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            @NotNull
            public Icon getIcon(boolean unused) {
                Icon icon = AllIcons.Nodes.Variable;
                if (icon == null) {
                    1.$$$reportNull$$$0(2);
                }
                return icon;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/yaml/psi/impl/YAMLScalarImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPresentableText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getLocationString";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIcon";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/psi/impl/YAMLScalarImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacements";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/psi/impl/YAMLScalarImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextValue";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "processReplacements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDecodeReplacements";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getEncodeReplacements";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processReplacements";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyLiteralTextEscaper
    extends LiteralTextEscaper<YAMLScalarImpl> {
        MyLiteralTextEscaper(YAMLScalarImpl scalar) {
            super((PsiLanguageInjectionHost)scalar);
        }

        public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
            if (rangeInsideHost == null) {
                MyLiteralTextEscaper.$$$reportNull$$$0(0);
            }
            if (outChars == null) {
                MyLiteralTextEscaper.$$$reportNull$$$0(1);
            }
            String text = ((YAMLScalarImpl)this.myHost).getText();
            List<TextRange> ranges = ((YAMLScalarImpl)this.myHost).getContentRanges();
            boolean decoded = false;
            for (TextRange range : ranges) {
                TextRange intersection = range.intersection(rangeInsideHost);
                if (intersection == null) continue;
                decoded = true;
                String substring = intersection.substring(text);
                outChars.append(YAMLScalarImpl.processReplacements(substring, ((YAMLScalarImpl)this.myHost).getDecodeReplacements(substring)));
            }
            return decoded;
        }

        @NotNull
        public TextRange getRelevantTextRange() {
            List<TextRange> ranges = ((YAMLScalarImpl)this.myHost).getContentRanges();
            if (ranges.isEmpty()) {
                TextRange textRange = TextRange.EMPTY_RANGE;
                if (textRange == null) {
                    MyLiteralTextEscaper.$$$reportNull$$$0(2);
                }
                return textRange;
            }
            TextRange textRange = TextRange.create((int)ranges.get(0).getStartOffset(), (int)ranges.get(ranges.size() - 1).getEndOffset());
            if (textRange == null) {
                MyLiteralTextEscaper.$$$reportNull$$$0(3);
            }
            return textRange;
        }

        public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
            if (rangeInsideHost == null) {
                MyLiteralTextEscaper.$$$reportNull$$$0(4);
            }
            String text = ((YAMLScalarImpl)this.myHost).getText();
            List<TextRange> contentRanges2 = ((YAMLScalarImpl)this.myHost).getContentRanges();
            int currentOffsetInDecoded = 0;
            TextRange last = null;
            for (int i = 0; i < contentRanges2.size(); ++i) {
                TextRange range = rangeInsideHost.intersection(contentRanges2.get(i));
                if (range == null) continue;
                last = range;
                String curString = range.subSequence((CharSequence)text).toString();
                List<Pair<TextRange, String>> replacementsForThisLine = ((YAMLScalarImpl)this.myHost).getDecodeReplacements(curString);
                int encodedOffsetInCurrentLine = 0;
                for (Pair<TextRange, String> replacement : replacementsForThisLine) {
                    int deltaLength = ((TextRange)replacement.getFirst()).getStartOffset() - encodedOffsetInCurrentLine;
                    int currentOffsetBeforeReplacement = currentOffsetInDecoded + deltaLength;
                    if (currentOffsetBeforeReplacement > offsetInDecoded) {
                        return range.getStartOffset() + encodedOffsetInCurrentLine + (offsetInDecoded - currentOffsetInDecoded);
                    }
                    if (currentOffsetBeforeReplacement == offsetInDecoded && !((String)replacement.getSecond()).isEmpty()) {
                        return range.getStartOffset() + encodedOffsetInCurrentLine + (offsetInDecoded - currentOffsetInDecoded);
                    }
                    currentOffsetInDecoded += deltaLength + ((String)replacement.getSecond()).length();
                    encodedOffsetInCurrentLine += deltaLength + ((TextRange)replacement.getFirst()).getLength();
                }
                int deltaLength = curString.length() - encodedOffsetInCurrentLine;
                if (currentOffsetInDecoded + deltaLength > offsetInDecoded) {
                    return range.getStartOffset() + encodedOffsetInCurrentLine + (offsetInDecoded - currentOffsetInDecoded);
                }
                currentOffsetInDecoded += deltaLength;
            }
            return last != null ? last.getEndOffset() : -1;
        }

        public boolean isOneLine() {
            return !((YAMLScalarImpl)this.myHost).isMultiline();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rangeInsideHost";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outChars";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/yaml/psi/impl/YAMLScalarImpl$MyLiteralTextEscaper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/yaml/psi/impl/YAMLScalarImpl$MyLiteralTextEscaper";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRelevantTextRange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "decode";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getOffsetInHost";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

