/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.codeinsight.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.editorconfig.language.codeinsight.quickfixes.EditorConfigSanitizeCharClassQuickFix;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.language.psi.EditorConfigCharClass;
import org.editorconfig.language.psi.EditorConfigCharClassLetter;
import org.editorconfig.language.psi.EditorConfigVisitor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/editorconfig/language/codeinsight/inspections/EditorConfigCharClassLetterRedundancyInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "buildVisitor", "Lorg/editorconfig/language/psi/EditorConfigVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "isUnique", "letter", "Lorg/editorconfig/language/psi/EditorConfigCharClassLetter;", "letters", "", "State", "intellij.editorconfig"})
public final class EditorConfigCharClassLetterRedundancyInspection
extends LocalInspectionTool {
    @NotNull
    public EditorConfigVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new EditorConfigVisitor(this, holder){
            final /* synthetic */ EditorConfigCharClassLetterRedundancyInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            public void visitCharClass(@NotNull EditorConfigCharClass charClass) {
                Intrinsics.checkNotNullParameter((Object)charClass, (String)"charClass");
                List<EditorConfigCharClassLetter> list = charClass.getCharClassLetterList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"charClass.charClassLetterList");
                List<EditorConfigCharClassLetter> letters = list;
                String message2 = EditorConfigBundle.INSTANCE.get("inspection.charclass.duplicate.message");
                State state = State.INITIAL;
                int firstDuplicateStart = Integer.MAX_VALUE;
                Iterable $this$forEach$iv = letters;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    EditorConfigCharClassLetter it = (EditorConfigCharClassLetter)element$iv;
                    boolean bl = false;
                    EditorConfigCharClassLetter editorConfigCharClassLetter = it;
                    Intrinsics.checkNotNullExpressionValue((Object)editorConfigCharClassLetter, (String)"it");
                    boolean unique = EditorConfigCharClassLetterRedundancyInspection.access$isUnique(this.this$0, editorConfigCharClassLetter, letters);
                    if (unique && state == State.COLLECTING_DUPLICATES) {
                        TextRange range;
                        Intrinsics.checkNotNullExpressionValue((Object)TextRange.create((int)firstDuplicateStart, (int)it.getStartOffsetInParent()), (String)"TextRange.create(firstDu\u2026, it.startOffsetInParent)");
                        this.$holder.registerProblem((PsiElement)charClass, range, message2, new LocalQuickFix[]{new EditorConfigSanitizeCharClassQuickFix()});
                        state = State.INITIAL;
                        continue;
                    }
                    if (unique || state != State.INITIAL) continue;
                    firstDuplicateStart = it.getStartOffsetInParent();
                    state = State.COLLECTING_DUPLICATES;
                }
                if (state == State.COLLECTING_DUPLICATES) {
                    EditorConfigCharClassLetter last;
                    EditorConfigCharClassLetter editorConfigCharClassLetter = last = (EditorConfigCharClassLetter)CollectionsKt.last(letters);
                    Intrinsics.checkNotNullExpressionValue((Object)editorConfigCharClassLetter, (String)"last");
                    TextRange textRange = TextRange.create((int)firstDuplicateStart, (int)(editorConfigCharClassLetter.getStartOffsetInParent() + last.getTextLength()));
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"TextRange.create(firstDu\u2026Parent + last.textLength)");
                    TextRange range = textRange;
                    this.$holder.registerProblem((PsiElement)charClass, range, message2, new LocalQuickFix[]{new EditorConfigSanitizeCharClassQuickFix()});
                }
            }
            {
                this.this$0 = this$0;
                this.$holder = $captured_local_variable$1;
            }
        };
    }

    private final boolean isUnique(EditorConfigCharClassLetter letter, List<? extends EditorConfigCharClassLetter> letters) {
        int n;
        Iterable $this$count$iv = letters;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                PsiElement p1 = (PsiElement)element$iv;
                boolean bl = false;
                if (!letter.textMatches(p1)) continue;
                int n2 = ++count$iv;
                boolean bl2 = false;
                if (n2 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n <= 1;
    }

    public static final /* synthetic */ boolean access$isUnique(EditorConfigCharClassLetterRedundancyInspection $this, EditorConfigCharClassLetter letter, List letters) {
        return $this.isUnique(letter, letters);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/editorconfig/language/codeinsight/inspections/EditorConfigCharClassLetterRedundancyInspection$State;", "", "(Ljava/lang/String;I)V", "INITIAL", "COLLECTING_DUPLICATES", "intellij.editorconfig"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State INITIAL;
        public static final /* enum */ State COLLECTING_DUPLICATES;
        private static final /* synthetic */ State[] $VALUES;

        static {
            State[] stateArray = new State[2];
            State[] stateArray2 = stateArray;
            stateArray[0] = INITIAL = new State();
            stateArray[1] = COLLECTING_DUPLICATES = new State();
            $VALUES = stateArray;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }
    }
}

