/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.codeinsight.quickfixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.language.psi.EditorConfigOptionValueIdentifier;
import org.editorconfig.language.psi.EditorConfigOptionValueList;
import org.editorconfig.language.services.EditorConfigElementFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\r\u001a\f0\u000e\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/editorconfig/language/codeinsight/quickfixes/EditorConfigRemoveUnexpectedValuesQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "findClosestListElement", "Lorg/editorconfig/language/psi/EditorConfigOptionValueIdentifier;", "list", "Lorg/editorconfig/language/psi/EditorConfigOptionValueList;", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "intellij.editorconfig"})
public final class EditorConfigRemoveUnexpectedValuesQuickFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        return EditorConfigBundle.INSTANCE.get("quickfix.value.list.remove.others");
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        PsiElement psiElement = descriptor.getPsiElement();
        if (psiElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.editorconfig.language.psi.EditorConfigOptionValueList");
        }
        EditorConfigOptionValueList list = (EditorConfigOptionValueList)psiElement;
        EditorConfigOptionValueIdentifier editorConfigOptionValueIdentifier = this.findClosestListElement(list);
        if (editorConfigOptionValueIdentifier == null) {
            return;
        }
        EditorConfigOptionValueIdentifier identifier = editorConfigOptionValueIdentifier;
        EditorConfigElementFactory factory = EditorConfigElementFactory.Companion.getInstance(project);
        String string = identifier.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"identifier.text");
        EditorConfigOptionValueIdentifier replacement = factory.createValueIdentifier(string);
        CodeStyleManager.getInstance((Project)project).performActionWithFormatterDisabled(new Runnable(list, replacement){
            final /* synthetic */ EditorConfigOptionValueList $list;
            final /* synthetic */ EditorConfigOptionValueIdentifier $replacement;

            public final void run() {
                this.$list.replace(this.$replacement);
            }
            {
                this.$list = editorConfigOptionValueList;
                this.$replacement = editorConfigOptionValueIdentifier;
            }
        });
    }

    private final EditorConfigOptionValueIdentifier findClosestListElement(EditorConfigOptionValueList list) {
        Object v3;
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)list.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorManager, (String)"FileEditorManager.getInstance(list.project)");
        Editor editor = fileEditorManager.getSelectedTextEditor();
        if (editor == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"FileEditorManager.getIns\u2026TextEditor ?: return null");
        Editor editor2 = editor;
        List<EditorConfigOptionValueIdentifier> list2 = list.getOptionValueIdentifierList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"list.optionValueIdentifierList");
        Iterable $this$minByOrNull$iv = list2;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v3 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v3 = minElem$iv;
            } else {
                PsiElement element = (PsiElement)minElem$iv;
                boolean bl = false;
                TextRange textRange = element.getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"element.textRange");
                int n = textRange.getStartOffset();
                CaretModel caretModel = editor2.getCaretModel();
                Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
                int n2 = n - caretModel.getOffset();
                int n3 = 0;
                n2 = Math.abs(n2);
                TextRange textRange2 = element.getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"element.textRange");
                int n4 = textRange2.getEndOffset();
                CaretModel caretModel2 = editor2.getCaretModel();
                Intrinsics.checkNotNullExpressionValue((Object)caretModel2, (String)"editor.caretModel");
                n3 = n4 - caretModel2.getOffset();
                int n5 = 0;
                n3 = Math.abs(n3);
                n5 = 0;
                int minValue$iv = Math.min(n2, n3);
                do {
                    Object e$iv = iterator$iv.next();
                    PsiElement element2 = (PsiElement)e$iv;
                    $i$a$-minByOrNull-EditorConfigRemoveUnexpectedValuesQuickFix$findClosestListElement$1 = false;
                    TextRange textRange3 = element2.getTextRange();
                    Intrinsics.checkNotNullExpressionValue((Object)textRange3, (String)"element.textRange");
                    int n6 = textRange3.getStartOffset();
                    CaretModel caretModel3 = editor2.getCaretModel();
                    Intrinsics.checkNotNullExpressionValue((Object)caretModel3, (String)"editor.caretModel");
                    n5 = n6 - caretModel3.getOffset();
                    int n7 = 0;
                    n5 = Math.abs(n5);
                    TextRange textRange4 = element2.getTextRange();
                    Intrinsics.checkNotNullExpressionValue((Object)textRange4, (String)"element.textRange");
                    int n8 = textRange4.getEndOffset();
                    CaretModel caretModel4 = editor2.getCaretModel();
                    Intrinsics.checkNotNullExpressionValue((Object)caretModel4, (String)"editor.caretModel");
                    n7 = n8 - caretModel4.getOffset();
                    boolean bl2 = false;
                    n7 = Math.abs(n7);
                    bl2 = false;
                    int v$iv = Math.min(n5, n7);
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v3 = minElem$iv;
            }
        }
        return v3;
    }
}

