/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configuration;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.Location;
import com.intellij.execution.configuration.RunConfigurationExtensionBase;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ExecutionUiService;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.ExtendableSettingsEditor;
import com.intellij.openapi.options.ExtensionSettingsEditor;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0016\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\u00042\u00020\u0005B\u0013\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\u0002\u0010\bJ+\u0010\u0019\u001a\u00020\u001a\"\b\b\u0002\u0010\u001b*\u00028\u00002\u0006\u0010\u001c\u001a\u00028\u00002\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001e\u00a2\u0006\u0002\u0010\u001fJ;\u0010\u0019\u001a\u00020\u001a\"\b\b\u0002\u0010\u001b*\u00028\u00002\u0006\u0010\u001c\u001a\u00028\u00002\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001e2\u000e\u0010 \u001a\n\u0012\u0004\u0012\u0002H\u001b\u0018\u00010!\u00a2\u0006\u0002\u0010\"J'\u0010#\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00028\u00002\u0006\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'H\u0016\u00a2\u0006\u0002\u0010(J)\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001b0*0\u0015\"\b\b\u0002\u0010\u001b*\u00028\u00002\u0006\u0010\u001c\u001a\u0002H\u001b\u00a2\u0006\u0002\u0010+J\u001f\u0010,\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00028\u00002\n\u0010-\u001a\u0006\u0012\u0002\b\u00030.\u00a2\u0006\u0002\u0010/J\u0013\u00100\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00028\u0000\u00a2\u0006\u0002\u00101J'\u00102\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00028\u00002\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u001a03\u00a2\u0006\u0002\u00104J\u001b\u00105\u001a\b\u0012\u0004\u0012\u00028\u0001062\u0006\u0010\u001c\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010+J/\u00107\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00028\u00002\b\u0010&\u001a\u0004\u0018\u00010'2\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010;J7\u00107\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00028\u00002\b\u0010&\u001a\u0004\u0018\u00010'2\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u000e2\u0006\u0010<\u001a\u00020=H\u0016\u00a2\u0006\u0002\u0010>J-\u0010?\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00028\u00002\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u001a03H\u0084\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u00104J7\u0010@\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00028\u00002\b\u0010&\u001a\u0004\u0018\u00010'2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u001a03H\u0084\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010AJ\u001b\u0010B\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00028\u00002\u0006\u0010C\u001a\u00020\u0016\u00a2\u0006\u0002\u0010DJ\u001b\u0010E\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00028\u00002\u0006\u0010F\u001a\u00020G\u00a2\u0006\u0002\u0010HJ\u001b\u0010I\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00028\u00002\u0006\u0010C\u001a\u00020\u0016\u00a2\u0006\u0002\u0010DJ\u000e\u0010J\u001a\u0004\u0018\u00010\u000e*\u00020\u0016H\u0002J\u0014\u0010K\u001a\u00020\u001a*\u00020\u00162\u0006\u0010L\u001a\u00020\u000eH\u0002R\"\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u00078\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000eX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R-\u0010\u0013\u001a!\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0016 \u0017*\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00150\u00150\u0014\u00a2\u0006\u0002\b\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006M"}, d2={"Lcom/intellij/execution/configuration/RunConfigurationExtensionsManager;", "U", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "T", "Lcom/intellij/execution/configuration/RunConfigurationExtensionBase;", "", "extensionPoint", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "(Lcom/intellij/openapi/extensions/ExtensionPointName;)V", "getExtensionPoint$annotations", "()V", "getExtensionPoint", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "extensionRootAttr", "", "getExtensionRootAttr", "()Ljava/lang/String;", "idAttrName", "getIdAttrName", "unloadedExtensionsKey", "Lcom/intellij/openapi/util/Key;", "", "Lorg/jdom/Element;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "appendEditors", "", "V", "configuration", "group", "Lcom/intellij/openapi/options/SettingsEditorGroup;", "(Lcom/intellij/execution/configurations/RunConfigurationBase;Lcom/intellij/openapi/options/SettingsEditorGroup;)V", "mainEditor", "Lcom/intellij/openapi/options/ExtendableSettingsEditor;", "(Lcom/intellij/execution/configurations/RunConfigurationBase;Lcom/intellij/openapi/options/SettingsEditorGroup;Lcom/intellij/openapi/options/ExtendableSettingsEditor;)V", "attachExtensionsToProcess", "handler", "Lcom/intellij/execution/process/ProcessHandler;", "runnerSettings", "Lcom/intellij/execution/configurations/RunnerSettings;", "(Lcom/intellij/execution/configurations/RunConfigurationBase;Lcom/intellij/execution/process/ProcessHandler;Lcom/intellij/execution/configurations/RunnerSettings;)V", "createFragments", "Lcom/intellij/openapi/options/SettingsEditor;", "(Lcom/intellij/execution/configurations/RunConfigurationBase;)Ljava/util/List;", "extendCreatedConfiguration", "location", "Lcom/intellij/execution/Location;", "(Lcom/intellij/execution/configurations/RunConfigurationBase;Lcom/intellij/execution/Location;)V", "extendTemplateConfiguration", "(Lcom/intellij/execution/configurations/RunConfigurationBase;)V", "forEachApplicableExtension", "Lkotlin/Function1;", "(Lcom/intellij/execution/configurations/RunConfigurationBase;Lkotlin/jvm/functions/Function1;)V", "getApplicableExtensions", "", "patchCommandLine", "cmdLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "runnerId", "(Lcom/intellij/execution/configurations/RunConfigurationBase;Lcom/intellij/execution/configurations/RunnerSettings;Lcom/intellij/execution/configurations/GeneralCommandLine;Ljava/lang/String;)V", "executor", "Lcom/intellij/execution/Executor;", "(Lcom/intellij/execution/configurations/RunConfigurationBase;Lcom/intellij/execution/configurations/RunnerSettings;Lcom/intellij/execution/configurations/GeneralCommandLine;Ljava/lang/String;Lcom/intellij/execution/Executor;)V", "processApplicableExtensions", "processEnabledExtensions", "(Lcom/intellij/execution/configurations/RunConfigurationBase;Lcom/intellij/execution/configurations/RunnerSettings;Lkotlin/jvm/functions/Function1;)V", "readExternal", "parentNode", "(Lcom/intellij/execution/configurations/RunConfigurationBase;Lorg/jdom/Element;)V", "validateConfiguration", "isExecution", "", "(Lcom/intellij/execution/configurations/RunConfigurationBase;Z)V", "writeExternal", "getExtensionId", "setExtensionId", "id", "intellij.platform.execution"})
public class RunConfigurationExtensionsManager<U extends RunConfigurationBase<?>, T extends RunConfigurationExtensionBase<U>> {
    @NotNull
    private final String idAttrName;
    @NotNull
    private final String extensionRootAttr;
    private final Key<List<Element>> unloadedExtensionsKey;
    @NotNull
    private final ExtensionPointName<T> extensionPoint;

    @NotNull
    protected String getIdAttrName() {
        return this.idAttrName;
    }

    @NotNull
    protected String getExtensionRootAttr() {
        return this.extensionRootAttr;
    }

    public final void readExternal(@NotNull U configuration, @NotNull Element parentNode) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)parentNode, (String)"parentNode");
        List children2 = parentNode.getChildren(this.getExtensionRootAttr());
        if (children2.isEmpty()) {
            return;
        }
        HashMap extensions2 = new HashMap();
        RunConfigurationExtensionsManager this_$iv = this;
        boolean $i$f$processApplicableExtensions = false;
        for (RunConfigurationExtensionBase extension$iv : this_$iv.getExtensionPoint().getIterable()) {
            if (extension$iv == null || !extension$iv.isApplicableFor(configuration)) continue;
            RunConfigurationExtensionBase it = extension$iv;
            boolean bl = false;
            Map map = extensions2;
            String string = it.getSerializationId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.serializationId");
            map.put(string, it);
        }
        boolean hasUnknownExtension = false;
        Iterator<Object> iterator = children2.iterator();
        while (iterator.hasNext()) {
            Element element;
            Element element2 = element = (Element)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"element");
            String id = this.getExtensionId(element2);
            Map map = extensions2;
            boolean bl = false;
            RunConfigurationExtensionBase extension = (RunConfigurationExtensionBase)TypeIntrinsics.asMutableMap((Object)map).remove(id);
            if (extension == null) {
                hasUnknownExtension = true;
                continue;
            }
            extension.readExternal(configuration, element);
        }
        if (hasUnknownExtension) {
            SmartList copy = new SmartList();
            for (Element child : children2) {
                copy.add((Object)JDOMUtil.internElement((Element)child));
            }
            configuration.putCopyableUserData(this.unloadedExtensionsKey, (Object)copy);
        }
    }

    public final void writeExternal(@NotNull U configuration, @NotNull Element parentNode) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)parentNode, (String)"parentNode");
        TreeMap map = new TreeMap();
        List elements = (List)configuration.getCopyableUserData(this.unloadedExtensionsKey);
        if (elements != null) {
            for (Element element : elements) {
                String id = this.getExtensionId(element);
                if (id == null) continue;
                Map map2 = map;
                Element element2 = element.clone();
                Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"element.clone()");
                map2.put(id, element2);
            }
        }
        RunConfigurationExtensionsManager this_$iv = this;
        boolean $i$f$processApplicableExtensions = false;
        for (RunConfigurationExtensionBase extension$iv : this_$iv.getExtensionPoint().getIterable()) {
            String id;
            if (extension$iv == null || !extension$iv.isApplicableFor(configuration)) continue;
            RunConfigurationExtensionBase extension = extension$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)extension.getSerializationId(), (String)"extension.serializationId");
            Element element = new Element(this.getExtensionRootAttr());
            this.setExtensionId(element, id);
            try {
                extension.writeExternal(configuration, element);
            }
            catch (WriteExternalException ignored) {
                continue;
            }
            List list = element.getContent();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"element.content");
            Collection collection = list;
            boolean bl2 = false;
            if (!(!collection.isEmpty()) && element.getAttributes().size() <= 1) continue;
            ((Map)map).put(id, element);
        }
        for (Element values : map.values()) {
            parentNode.addContent(values);
        }
    }

    private final String getExtensionId(Element $this$getExtensionId) {
        String id = $this$getExtensionId.getAttributeValue(this.getIdAttrName());
        if (id == null) {
            String xml = new XMLOutputter().outputString($this$getExtensionId);
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(RunConfigurationExtensionsManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.error("Cannot find extension id in extension element: " + xml);
        }
        return id;
    }

    private final void setExtensionId(Element $this$setExtensionId, String id) {
        $this$setExtensionId.setAttribute(this.getIdAttrName(), id);
    }

    public final <V extends U> void appendEditors(@NotNull U configuration, @NotNull SettingsEditorGroup<V> group) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter(group, (String)"group");
        this.appendEditors(configuration, group, null);
    }

    public final <V extends U> void appendEditors(@NotNull U configuration, @NotNull SettingsEditorGroup<V> group, @Nullable ExtendableSettingsEditor<V> mainEditor) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter(group, (String)"group");
        RunConfigurationExtensionsManager this_$iv = this;
        boolean $i$f$processApplicableExtensions = false;
        for (RunConfigurationExtensionBase extension$iv : this_$iv.getExtensionPoint().getIterable()) {
            SettingsEditor<U> editor;
            if (extension$iv == null || !extension$iv.isApplicableFor(configuration)) continue;
            RunConfigurationExtensionBase it = extension$iv;
            boolean bl = false;
            if (it.createEditor(configuration) == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue(editor, (String)"it.createEditor(configur\u2026ocessApplicableExtensions");
            if (mainEditor != null && editor instanceof ExtensionSettingsEditor) {
                mainEditor.addExtensionEditor(editor);
                continue;
            }
            group.addEditor(it.getEditorTitle(), editor);
        }
    }

    @NotNull
    public final <V extends U> List<SettingsEditor<V>> createFragments(@NotNull V configuration) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        ArrayList<SettingsEditor<V>> list = new ArrayList<SettingsEditor<V>>();
        RunConfigurationExtensionsManager this_$iv = this;
        boolean $i$f$processApplicableExtensions = false;
        for (RunConfigurationExtensionBase extension$iv : this_$iv.getExtensionPoint().getIterable()) {
            SettingsEditor<V> wrapper;
            if (extension$iv == null || !extension$iv.isApplicableFor(configuration)) continue;
            RunConfigurationExtensionBase t = extension$iv;
            boolean bl = false;
            List<SettingsEditor<V>> fragments2 = t.createFragments(configuration);
            if (fragments2 != null) {
                list.addAll((Collection)fragments2);
                continue;
            }
            SettingsEditor<V> editor = t.createEditor(configuration);
            if (editor == null || (wrapper = ExecutionUiService.getInstance().createSettingsEditorFragmentWrapper(t.getSerializationId(), t.getEditorTitle(), null, editor, new Predicate(t, (RunConfigurationBase)configuration, list){
                final /* synthetic */ RunConfigurationExtensionBase $t;
                final /* synthetic */ RunConfigurationBase $configuration$inlined;
                final /* synthetic */ ArrayList $list$inlined;
                {
                    this.$t = runConfigurationExtensionBase;
                    this.$configuration$inlined = runConfigurationBase;
                    this.$list$inlined = arrayList;
                }

                public final boolean test(V it) {
                    return this.$t.isEnabledFor(this.$configuration$inlined, null);
                }
            })) == null) continue;
            list.add(wrapper);
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public final void validateConfiguration(@NotNull U configuration, boolean isExecution) throws Exception {
        void this_$iv;
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        RunConfigurationExtensionsManager runConfigurationExtensionsManager = this;
        RunnerSettings runnerSettings$iv = null;
        boolean $i$f$processEnabledExtensions = false;
        for (RunConfigurationExtensionBase extension$iv : this_$iv.getExtensionPoint().getIterable()) {
            if (extension$iv == null || !extension$iv.isApplicableFor(configuration) || !extension$iv.isEnabledFor(configuration, runnerSettings$iv)) continue;
            RunConfigurationExtensionBase it = extension$iv;
            boolean bl = false;
            it.validateConfiguration(configuration, isExecution);
        }
    }

    public final void extendCreatedConfiguration(@NotNull U configuration, @NotNull Location<?> location) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter(location, (String)"location");
        RunConfigurationExtensionsManager this_$iv = this;
        boolean $i$f$processApplicableExtensions = false;
        for (RunConfigurationExtensionBase extension$iv : this_$iv.getExtensionPoint().getIterable()) {
            if (extension$iv == null || !extension$iv.isApplicableFor(configuration)) continue;
            RunConfigurationExtensionBase it = extension$iv;
            boolean bl = false;
            it.extendCreatedConfiguration(configuration, location);
        }
    }

    public final void extendTemplateConfiguration(@NotNull U configuration) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        RunConfigurationExtensionsManager this_$iv = this;
        boolean $i$f$processApplicableExtensions = false;
        for (RunConfigurationExtensionBase extension$iv : this_$iv.getExtensionPoint().getIterable()) {
            if (extension$iv == null || !extension$iv.isApplicableFor(configuration)) continue;
            RunConfigurationExtensionBase it = extension$iv;
            boolean bl = false;
            it.extendTemplateConfiguration(configuration);
        }
    }

    public void patchCommandLine(@NotNull U configuration, @Nullable RunnerSettings runnerSettings, @NotNull GeneralCommandLine cmdLine, @NotNull String runnerId, @NotNull Executor executor) throws ExecutionException {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)cmdLine, (String)"cmdLine");
        Intrinsics.checkNotNullParameter((Object)runnerId, (String)"runnerId");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        RunConfigurationExtensionsManager this_$iv = this;
        boolean $i$f$processEnabledExtensions = false;
        for (RunConfigurationExtensionBase extension$iv : this_$iv.getExtensionPoint().getIterable()) {
            if (extension$iv == null || !extension$iv.isApplicableFor(configuration) || !extension$iv.isEnabledFor(configuration, runnerSettings)) continue;
            RunConfigurationExtensionBase it = extension$iv;
            boolean bl = false;
            it.patchCommandLine(configuration, runnerSettings, cmdLine, runnerId, executor);
        }
    }

    public void patchCommandLine(@NotNull U configuration, @Nullable RunnerSettings runnerSettings, @NotNull GeneralCommandLine cmdLine, @NotNull String runnerId) throws ExecutionException {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)cmdLine, (String)"cmdLine");
        Intrinsics.checkNotNullParameter((Object)runnerId, (String)"runnerId");
        RunConfigurationExtensionsManager this_$iv = this;
        boolean $i$f$processEnabledExtensions = false;
        for (RunConfigurationExtensionBase extension$iv : this_$iv.getExtensionPoint().getIterable()) {
            if (extension$iv == null || !extension$iv.isApplicableFor(configuration) || !extension$iv.isEnabledFor(configuration, runnerSettings)) continue;
            RunConfigurationExtensionBase it = extension$iv;
            boolean bl = false;
            it.patchCommandLine(configuration, runnerSettings, cmdLine, runnerId);
        }
    }

    public void attachExtensionsToProcess(@NotNull U configuration, @NotNull ProcessHandler handler, @Nullable RunnerSettings runnerSettings) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        RunConfigurationExtensionsManager this_$iv = this;
        boolean $i$f$processEnabledExtensions = false;
        for (RunConfigurationExtensionBase extension$iv : this_$iv.getExtensionPoint().getIterable()) {
            if (extension$iv == null || !extension$iv.isApplicableFor(configuration) || !extension$iv.isEnabledFor(configuration, runnerSettings)) continue;
            RunConfigurationExtensionBase it = extension$iv;
            boolean bl = false;
            it.attachToProcess(configuration, handler, runnerSettings);
        }
    }

    @NotNull
    protected final List<T> getApplicableExtensions(@NotNull U configuration) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        SmartList extensions2 = new SmartList();
        RunConfigurationExtensionsManager this_$iv = this;
        boolean $i$f$processApplicableExtensions = false;
        for (RunConfigurationExtensionBase extension$iv : this_$iv.getExtensionPoint().getIterable()) {
            if (extension$iv == null || !extension$iv.isApplicableFor(configuration)) continue;
            RunConfigurationExtensionBase it = extension$iv;
            boolean bl = false;
            extensions2.add((Object)it);
        }
        return (List)extensions2;
    }

    protected final void processApplicableExtensions(@NotNull U configuration, @NotNull Function1<? super T, Unit> handler) {
        int $i$f$processApplicableExtensions = 0;
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        for (RunConfigurationExtensionBase extension : this.getExtensionPoint().getIterable()) {
            if (extension == null || !extension.isApplicableFor(configuration)) continue;
            handler.invoke((Object)extension);
        }
    }

    public final void forEachApplicableExtension(@NotNull U configuration, @NotNull Function1<? super T, Unit> handler) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        RunConfigurationExtensionsManager this_$iv = this;
        boolean $i$f$processApplicableExtensions = false;
        for (RunConfigurationExtensionBase extension$iv : this_$iv.getExtensionPoint().getIterable()) {
            if (extension$iv == null || !extension$iv.isApplicableFor(configuration)) continue;
            handler.invoke((Object)extension$iv);
        }
    }

    protected final void processEnabledExtensions(@NotNull U configuration, @Nullable RunnerSettings runnerSettings, @NotNull Function1<? super T, Unit> handler) {
        int $i$f$processEnabledExtensions = 0;
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        for (RunConfigurationExtensionBase extension : this.getExtensionPoint().getIterable()) {
            if (extension == null || !extension.isApplicableFor(configuration) || !extension.isEnabledFor(configuration, runnerSettings)) continue;
            handler.invoke((Object)extension);
        }
    }

    @PublishedApi
    public static /* synthetic */ void getExtensionPoint$annotations() {
    }

    @NotNull
    public final ExtensionPointName<T> getExtensionPoint() {
        return this.extensionPoint;
    }

    public RunConfigurationExtensionsManager(@NotNull ExtensionPointName<T> extensionPoint) {
        Intrinsics.checkNotNullParameter(extensionPoint, (String)"extensionPoint");
        this.extensionPoint = extensionPoint;
        this.idAttrName = "ID";
        this.extensionRootAttr = "EXTENSION";
        Key key = Key.create((String)(this.getClass().getCanonicalName() + ".run.extension.elements"));
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create<List<Element>\u2026.run.extension.elements\")");
        this.unloadedExtensionsKey = key;
    }
}

