/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.target;

import com.intellij.execution.target.ContributedConfigurationBase;
import com.intellij.execution.target.ContributedConfigurationsList;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentType;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.text.UniqueNameGenerator;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="RemoteTargetsManager", storages={@Storage(value="remote-targets.xml")})
@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0007\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004\u001a\u001b\u001c\u001dB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005J\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005J\b\u0010\u0016\u001a\u00020\u0002H\u0016J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0002H\u0016J\u000e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005R(\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lcom/intellij/execution/target/TargetEnvironmentsManager;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/execution/target/TargetEnvironmentsManager$TargetsListState;", "()V", "value", "Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "defaultTarget", "getDefaultTarget", "()Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "setDefaultTarget", "(Lcom/intellij/execution/target/TargetEnvironmentConfiguration;)V", "projectDefaultTargetUuid", "", "targets", "Lcom/intellij/execution/target/ContributedConfigurationsList;", "Lcom/intellij/execution/target/TargetEnvironmentType;", "getTargets", "()Lcom/intellij/execution/target/ContributedConfigurationsList;", "addTarget", "", "target", "ensureUniqueName", "getState", "loadState", "state", "removeTarget", "Companion", "OneTargetState", "TargetsList", "TargetsListState", "intellij.platform.execution"})
public final class TargetEnvironmentsManager
implements PersistentStateComponent<TargetsListState> {
    private String projectDefaultTargetUuid;
    @NotNull
    private final ContributedConfigurationsList<TargetEnvironmentConfiguration, TargetEnvironmentType<?>> targets = new TargetsList();
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final TargetEnvironmentConfiguration getDefaultTarget() {
        TargetEnvironmentConfiguration targetEnvironmentConfiguration;
        String string = this.projectDefaultTargetUuid;
        if (string != null) {
            Object v1;
            block3: {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String uuid = string2;
                boolean bl3 = false;
                Iterable $this$firstOrNull$iv = this.targets.resolvedConfigs();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    TargetEnvironmentConfiguration it = (TargetEnvironmentConfiguration)element$iv;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual((Object)it.getUuid(), (Object)uuid)) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            targetEnvironmentConfiguration = v1;
        } else {
            targetEnvironmentConfiguration = null;
        }
        return targetEnvironmentConfiguration;
    }

    public final void setDefaultTarget(@Nullable TargetEnvironmentConfiguration value2) {
        TargetEnvironmentConfiguration targetEnvironmentConfiguration = value2;
        this.projectDefaultTargetUuid = targetEnvironmentConfiguration != null ? targetEnvironmentConfiguration.getUuid() : null;
    }

    @NotNull
    public final ContributedConfigurationsList<TargetEnvironmentConfiguration, TargetEnvironmentType<?>> getTargets() {
        return this.targets;
    }

    @Override
    @NotNull
    public TargetsListState getState() {
        TargetsListState result = new TargetsListState();
        result.setProjectDefaultTargetUuid(this.projectDefaultTargetUuid);
        Iterator<ContributedConfigurationsList.ContributedStateBase> iterator = this.targets.getState().getConfigs().iterator();
        while (iterator.hasNext()) {
            ContributedConfigurationsList.ContributedStateBase next;
            ContributedConfigurationsList.ContributedStateBase contributedStateBase = next = iterator.next();
            if (contributedStateBase == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.execution.target.TargetEnvironmentsManager.OneTargetState");
            }
            result.getTargets().add((OneTargetState)contributedStateBase);
        }
        return result;
    }

    @Override
    public void loadState(@NotNull TargetsListState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.projectDefaultTargetUuid = state.getProjectDefaultTargetUuid();
        this.targets.loadState(state.getTargets());
    }

    public final void addTarget(@NotNull TargetEnvironmentConfiguration target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (!this.targets.resolvedConfigs().contains(target)) {
            this.ensureUniqueName(target);
            this.targets.addConfig((TargetEnvironmentConfiguration)((ContributedConfigurationBase)target));
        }
    }

    public final void removeTarget(@NotNull TargetEnvironmentConfiguration target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.targets.removeConfig((TargetEnvironmentConfiguration)((ContributedConfigurationBase)target));
    }

    /*
     * WARNING - void declaration
     */
    public final void ensureUniqueName(@NotNull TargetEnvironmentConfiguration target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (!this.targets.resolvedConfigs().contains(target)) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.targets.resolvedConfigs();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TargetEnvironmentConfiguration targetEnvironmentConfiguration = (TargetEnvironmentConfiguration)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it.getDisplayName();
                collection.add(string);
            }
            Set existingNames = SetsKt.plus((Set)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)), (Iterable)this.targets.unresolvedNames());
            String string = UniqueNameGenerator.generateUniqueName((String)target.getDisplayName(), (Collection)existingNames);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UniqueNameGenerator.gene\u2026splayName, existingNames)");
            String uniqueName = string;
            target.setDisplayName(uniqueName);
        }
    }

    @JvmStatic
    @NotNull
    public static final TargetEnvironmentsManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/execution/target/TargetEnvironmentsManager$TargetsList;", "Lcom/intellij/execution/target/ContributedConfigurationsList;", "Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "Lcom/intellij/execution/target/TargetEnvironmentType;", "()V", "fromOneState", "state", "Lcom/intellij/execution/target/ContributedConfigurationsList$ContributedStateBase;", "toBaseState", "Lcom/intellij/execution/target/TargetEnvironmentsManager$OneTargetState;", "config", "intellij.platform.execution"})
    public static final class TargetsList
    extends ContributedConfigurationsList<TargetEnvironmentConfiguration, TargetEnvironmentType<?>> {
        @NotNull
        protected OneTargetState toBaseState(@NotNull TargetEnvironmentConfiguration config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            OneTargetState oneTargetState = new OneTargetState();
            boolean bl = false;
            boolean bl2 = false;
            OneTargetState it = oneTargetState;
            boolean bl3 = false;
            it.loadFromConfiguration(config);
            it.setUuid(config.getUuid());
            it.setRuntimes(config.getRuntimes().getState().getConfigs());
            return oneTargetState;
        }

        @Override
        @Nullable
        protected TargetEnvironmentConfiguration fromOneState(@NotNull ContributedConfigurationsList.ContributedStateBase state) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            TargetEnvironmentConfiguration result = (TargetEnvironmentConfiguration)super.fromOneState(state);
            if (result != null && state instanceof OneTargetState) {
                String string = ((OneTargetState)state).getUuid();
                if (string == null) {
                    String string2 = UUID.randomUUID().toString();
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"UUID.randomUUID().toString()");
                }
                result.setUuid$intellij_platform_execution(string);
                result.getRuntimes().loadState(((OneTargetState)state).getRuntimes());
            }
            return result;
        }

        public TargetsList() {
            super(TargetEnvironmentType.EXTENSION_NAME);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R/\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u00048F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\n\u0010\u000b\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR7\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\r0\f8G@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\u000b\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lcom/intellij/execution/target/TargetEnvironmentsManager$TargetsListState;", "Lcom/intellij/openapi/components/BaseState;", "()V", "<set-?>", "", "projectDefaultTargetUuid", "getProjectDefaultTargetUuid", "()Ljava/lang/String;", "setProjectDefaultTargetUuid", "(Ljava/lang/String;)V", "projectDefaultTargetUuid$delegate", "Lkotlin/properties/ReadWriteProperty;", "", "Lcom/intellij/execution/target/TargetEnvironmentsManager$OneTargetState;", "targets", "getTargets", "()Ljava/util/List;", "setTargets", "(Ljava/util/List;)V", "targets$delegate", "intellij.platform.execution"})
    public static final class TargetsListState
    extends BaseState {
        static final /* synthetic */ KProperty[] $$delegatedProperties;
        @Nullable
        private final ReadWriteProperty projectDefaultTargetUuid$delegate = BaseState.string$default(this, null, 1, null).provideDelegate((Object)this, $$delegatedProperties[0]);
        @NotNull
        private final ReadWriteProperty targets$delegate = this.list().provideDelegate((Object)this, $$delegatedProperties[1]);

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(TargetsListState.class, "projectDefaultTargetUuid", "getProjectDefaultTargetUuid()Ljava/lang/String;", 0)), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(TargetsListState.class, "targets", "getTargets()Ljava/util/List;", 0))};
        }

        @Nullable
        public final String getProjectDefaultTargetUuid() {
            return (String)this.projectDefaultTargetUuid$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        public final void setProjectDefaultTargetUuid(@Nullable String string) {
            this.projectDefaultTargetUuid$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)string);
        }

        @XCollection(style=XCollection.Style.v2)
        @NotNull
        public final List<OneTargetState> getTargets() {
            return (List)this.targets$delegate.getValue((Object)this, $$delegatedProperties[1]);
        }

        public final void setTargets(@NotNull List<OneTargetState> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.targets$delegate.setValue((Object)this, $$delegatedProperties[1], list);
        }
    }

    @Tag(value="target")
    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R7\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u00042\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u00048G@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\n\u0010\u000b\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR/\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u0003\u001a\u0004\u0018\u00010\f8G@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u000b\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lcom/intellij/execution/target/TargetEnvironmentsManager$OneTargetState;", "Lcom/intellij/execution/target/ContributedConfigurationsList$ContributedStateBase;", "()V", "<set-?>", "", "runtimes", "getRuntimes", "()Ljava/util/List;", "setRuntimes", "(Ljava/util/List;)V", "runtimes$delegate", "Lkotlin/properties/ReadWriteProperty;", "", "uuid", "getUuid", "()Ljava/lang/String;", "setUuid", "(Ljava/lang/String;)V", "uuid$delegate", "intellij.platform.execution"})
    public static final class OneTargetState
    extends ContributedConfigurationsList.ContributedStateBase {
        static final /* synthetic */ KProperty[] $$delegatedProperties;
        @Nullable
        private final ReadWriteProperty uuid$delegate = BaseState.string$default(this, null, 1, null).provideDelegate((Object)this, $$delegatedProperties[0]);
        @NotNull
        private final ReadWriteProperty runtimes$delegate = this.list().provideDelegate((Object)this, $$delegatedProperties[1]);

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(OneTargetState.class, "uuid", "getUuid()Ljava/lang/String;", 0)), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(OneTargetState.class, "runtimes", "getRuntimes()Ljava/util/List;", 0))};
        }

        @Attribute(value="uuid")
        @Nullable
        public final String getUuid() {
            return (String)this.uuid$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        public final void setUuid(@Nullable String string) {
            this.uuid$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)string);
        }

        @XCollection(style=XCollection.Style.v2)
        @Property(surroundWithTag=false)
        @NotNull
        public final List<ContributedConfigurationsList.ContributedStateBase> getRuntimes() {
            return (List)this.runtimes$delegate.getValue((Object)this, $$delegatedProperties[1]);
        }

        public final void setRuntimes(@NotNull List<ContributedConfigurationsList.ContributedStateBase> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.runtimes$delegate.setValue((Object)this, $$delegatedProperties[1], list);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/execution/target/TargetEnvironmentsManager$Companion;", "", "()V", "getInstance", "Lcom/intellij/execution/target/TargetEnvironmentsManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.execution"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final TargetEnvironmentsManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(TargetEnvironmentsManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.getService(Targe\u2026mentsManager::class.java)");
            return (TargetEnvironmentsManager)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

