/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.target.value;

import com.intellij.execution.target.ExternallySynchronized;
import com.intellij.execution.target.HostPort;
import com.intellij.execution.target.ResolvedPortBinding;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetPlatform;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.execution.target.value.Constant;
import com.intellij.execution.target.value.JoinedStringTargetEnvironmentFunction;
import com.intellij.execution.target.value.TraceableTargetEnvironmentFunction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000n\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a/\u0010\u0000\u001a\u0018\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\u00030\u0001j\b\u0012\u0004\u0012\u0002H\u0003`\u0004\"\u0004\b\u0000\u0010\u00032\u0006\u0010\u0005\u001a\u0002H\u0003\u00a2\u0006\u0002\u0010\u0006\u001a\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0002\u001a \u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u001a\u0010\u0011\u001a\u00020\u0012*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015\u001a>\u0010\u0016\u001a\u0018\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\u0001j\b\u0012\u0004\u0012\u00020\b`\u0004*\u0018\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\u0001j\b\u0012\u0004\u0012\u00020\b`\u00042\u0006\u0010\u0017\u001a\u00020\b\u001a \u0010\u0018\u001a\u0018\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\u0001j\b\u0012\u0004\u0012\u00020\b`\u0004*\u00020\u0019\u001a \u0010\u001a\u001a\u0018\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u001b0\u0001j\b\u0012\u0004\u0012\u00020\u001b`\u0004*\u00020\u001c\u001a(\u0010\u001d\u001a\u0018\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\u0001j\b\u0012\u0004\u0012\u00020\b`\u0004*\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\b\u001a \u0010\u001f\u001a\u0018\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\u0001j\b\u0012\u0004\u0012\u00020\b`\u0004*\u00020 \u001a \u0010!\u001a\u0010\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\b\u0018\u00010\"*\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\b\u001aJ\u0010#\u001a\u0018\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\u0001j\b\u0012\u0004\u0012\u00020\b`\u0004\"\u0004\b\u0000\u0010\u0003*\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\u00030\u0001j\b\u0012\u0004\u0012\u0002H\u0003`\u00040$2\u0006\u0010%\u001a\u00020&\u001a\u0016\u0010'\u001a\u0004\u0018\u00010\b*\u00020(2\u0006\u0010\u0013\u001a\u00020\bH\u0002*(\u0010)\u001a\u0004\b\u0000\u0010*\"\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H*0\u00012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H*0\u0001\u00a8\u0006+"}, d2={"constant", "Ljava/util/function/Function;", "Lcom/intellij/execution/target/TargetEnvironment;", "T", "Lcom/intellij/execution/target/value/TargetEnvironmentFunction;", "value", "(Ljava/lang/Object;)Ljava/util/function/Function;", "getRelativePathIfAncestor", "", "ancestor", "Ljava/nio/file/Path;", "file", "joinPaths", "basePath", "relativePath", "targetPlatform", "Lcom/intellij/execution/target/TargetPlatform;", "downloadFromTarget", "", "localPath", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getRelativeTargetPath", "targetRelativePath", "getTargetDownloadPath", "Lcom/intellij/execution/target/TargetEnvironment$DownloadRoot;", "getTargetEnvironmentValue", "Lcom/intellij/execution/target/HostPort;", "Lcom/intellij/execution/target/TargetEnvironment$LocalPortBinding;", "getTargetEnvironmentValueForLocalPath", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "getTargetUploadPath", "Lcom/intellij/execution/target/TargetEnvironment$UploadRoot;", "getUploadRootForLocalPath", "Lkotlin/Pair;", "joinToStringFunction", "", "separator", "", "tryMapToSynchronizedVolume", "Lcom/intellij/execution/target/ExternallySynchronized;", "TargetEnvironmentFunction", "R", "intellij.platform.execution"})
@JvmName(name="TargetEnvironmentFunctions")
public final class TargetEnvironmentFunctions {
    @NotNull
    public static final <T> Function<TargetEnvironment, T> constant(T value2) {
        return new Constant<T>(value2);
    }

    @NotNull
    public static final <T> Function<TargetEnvironment, String> joinToStringFunction(@NotNull Iterable<? extends Function<TargetEnvironment, T>> $this$joinToStringFunction, @NotNull CharSequence separator) {
        Intrinsics.checkNotNullParameter($this$joinToStringFunction, (String)"$this$joinToStringFunction");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        return new JoinedStringTargetEnvironmentFunction($this$joinToStringFunction, separator);
    }

    @NotNull
    public static final Function<TargetEnvironment, String> getTargetEnvironmentValueForLocalPath(@NotNull TargetEnvironmentRequest $this$getTargetEnvironmentValueForLocalPath, @NotNull String localPath) {
        Intrinsics.checkNotNullParameter((Object)$this$getTargetEnvironmentValueForLocalPath, (String)"$this$getTargetEnvironmentValueForLocalPath");
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        if ($this$getTargetEnvironmentValueForLocalPath instanceof LocalTargetEnvironmentRequest) {
            return TargetEnvironmentFunctions.constant(localPath);
        }
        TraceableTargetEnvironmentFunction.Companion this_$iv = TraceableTargetEnvironmentFunction.Companion;
        boolean $i$f$invoke = false;
        return new TraceableTargetEnvironmentFunction<String>($this$getTargetEnvironmentValueForLocalPath, localPath){
            final /* synthetic */ TargetEnvironmentRequest $this_getTargetEnvironmentValueForLocalPath$inlined;
            final /* synthetic */ String $localPath$inlined;
            {
                this.$this_getTargetEnvironmentValueForLocalPath$inlined = targetEnvironmentRequest;
                this.$localPath$inlined = string;
            }

            /*
             * WARNING - void declaration
             */
            public String applyInner(@NotNull TargetEnvironment t) {
                String string;
                Object pathForSynchronizedVolume;
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                TargetEnvironment targetEnvironment = t;
                boolean bl = false;
                if (targetEnvironment instanceof ExternallySynchronized && (pathForSynchronizedVolume = TargetEnvironmentFunctions.access$tryMapToSynchronizedVolume((ExternallySynchronized)((Object)targetEnvironment), this.$localPath$inlined)) != null) {
                    string = pathForSynchronizedVolume;
                } else {
                    void uploadRoot;
                    Pair<TargetEnvironment.UploadRoot, String> pair = TargetEnvironmentFunctions.getUploadRootForLocalPath(this.$this_getTargetEnvironmentValueForLocalPath$inlined, this.$localPath$inlined);
                    if (pair == null) {
                        throw (Throwable)new IllegalArgumentException("Local path \"" + this.$localPath$inlined + "\" is not registered within uploads in the request");
                    }
                    Pair<TargetEnvironment.UploadRoot, String> pair2 = pair;
                    pathForSynchronizedVolume = (TargetEnvironment.UploadRoot)pair2.component1();
                    String relativePath = (String)pair2.component2();
                    TargetEnvironment.UploadableVolume uploadableVolume = targetEnvironment.getUploadVolumes().get(uploadRoot);
                    if (uploadableVolume == null) {
                        throw (Throwable)new IllegalStateException("Upload root \"" + uploadRoot + "\" is expected to be created in the target environment");
                    }
                    TargetEnvironment.UploadableVolume volume = uploadableVolume;
                    string = TargetEnvironmentFunctions.access$joinPaths(volume.getTargetRoot(), relativePath, targetEnvironment.getTargetPlatform());
                }
                return string;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private static final String tryMapToSynchronizedVolume(ExternallySynchronized $this$tryMapToSynchronizedVolume, String localPath) {
        void volume;
        Pair pair;
        block5: {
            ExternallySynchronized externallySynchronized = $this$tryMapToSynchronizedVolume;
            if (externallySynchronized == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.execution.target.TargetEnvironment");
            }
            TargetEnvironment cfr_ignored_0 = (TargetEnvironment)((Object)externallySynchronized);
            char targetFileSeparator = ((TargetEnvironment)((Object)$this$tryMapToSynchronizedVolume)).getTargetPlatform().getPlatform().fileSeparator;
            Iterable iterable = $this$tryMapToSynchronizedVolume.getSynchronizedVolumes();
            boolean bl = false;
            for (Object t : iterable) {
                Pair pair2;
                Pair pair3;
                ExternallySynchronized.SynchronizedVolume volume2 = (ExternallySynchronized.SynchronizedVolume)t;
                boolean bl2 = false;
                if (TargetEnvironmentFunctions.getRelativePathIfAncestor(volume2.getLocalPath(), localPath) != null) {
                    String string;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    String relativePath = string;
                    boolean bl5 = false;
                    pair3 = TuplesKt.to((Object)volume2, (Object)(File.separatorChar != targetFileSeparator ? StringsKt.replace$default((String)relativePath, (char)File.separatorChar, (char)targetFileSeparator, (boolean)false, (int)4, null) : relativePath));
                } else {
                    pair3 = null;
                }
                if ((pair2 = pair3) == null) continue;
                pair = pair2;
                break block5;
            }
            pair = null;
        }
        if (pair == null) {
            return null;
        }
        Pair pair4 = pair;
        ExternallySynchronized.SynchronizedVolume synchronizedVolume = (ExternallySynchronized.SynchronizedVolume)pair4.component1();
        String relativePath = (String)pair4.component2();
        return TargetEnvironmentFunctions.joinPaths(volume.getTargetPath(), relativePath, ((TargetEnvironment)((Object)$this$tryMapToSynchronizedVolume)).getTargetPlatform());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Pair<TargetEnvironment.UploadRoot, String> getUploadRootForLocalPath(@NotNull TargetEnvironmentRequest $this$getUploadRootForLocalPath, @NotNull String localPath) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getUploadRootForLocalPath, (String)"$this$getUploadRootForLocalPath");
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        char targetFileSeparator = $this$getUploadRootForLocalPath.getTargetPlatform().getPlatform().fileSeparator;
        Iterable $this$mapNotNull$iv = $this$getUploadRootForLocalPath.getUploadVolumes();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            TargetEnvironment.UploadRoot uploadRoot = (TargetEnvironment.UploadRoot)element$iv$iv;
            boolean bl2 = false;
            if (TargetEnvironmentFunctions.getRelativePathIfAncestor(uploadRoot.getLocalRootPath(), localPath) != null) {
                String string;
                boolean bl3 = false;
                boolean bl4 = false;
                String relativePath = string;
                boolean bl5 = false;
                pair = TuplesKt.to((Object)uploadRoot, (Object)(File.separatorChar != targetFileSeparator ? StringsKt.replace$default((String)relativePath, (char)File.separatorChar, (char)targetFileSeparator, (boolean)false, (int)4, null) : relativePath));
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair pair2 = pair;
            boolean bl6 = false;
            boolean bl7 = false;
            Pair it$iv$iv = pair2;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (Pair)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }

    private static final String getRelativePathIfAncestor(Path ancestor, String file) {
        Object object;
        try {
            object = ancestor.relativize(Paths.get(file, new String[0]));
            boolean bl = false;
            boolean bl2 = false;
            Path it = object;
            boolean bl3 = false;
            Object object2 = !it.startsWith("..") ? object : null;
            object = object2 != null ? object2.toString() : null;
        }
        catch (InvalidPathException ignored) {
            object = null;
        }
        catch (IllegalArgumentException ignored) {
            object = null;
        }
        return object;
    }

    private static final String joinPaths(String basePath, String relativePath, TargetPlatform targetPlatform) {
        String fileSeparator = String.valueOf(targetPlatform.getPlatform().fileSeparator);
        String string = FileUtil.toSystemIndependentName((String)(StringsKt.removeSuffix((String)basePath, (CharSequence)fileSeparator) + fileSeparator + relativePath));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtil.toSystemIndepen\u2026eSeparator$relativePath\")");
        return string;
    }

    @NotNull
    public static final Function<TargetEnvironment, String> getTargetUploadPath(@NotNull TargetEnvironment.UploadRoot $this$getTargetUploadPath) {
        Intrinsics.checkNotNullParameter((Object)$this$getTargetUploadPath, (String)"$this$getTargetUploadPath");
        TraceableTargetEnvironmentFunction.Companion this_$iv = TraceableTargetEnvironmentFunction.Companion;
        boolean $i$f$invoke = false;
        return new TraceableTargetEnvironmentFunction<String>($this$getTargetUploadPath){
            final /* synthetic */ TargetEnvironment.UploadRoot $this_getTargetUploadPath$inlined;
            {
                this.$this_getTargetUploadPath$inlined = uploadRoot;
            }

            public String applyInner(@NotNull TargetEnvironment t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                TargetEnvironment targetEnvironment = t;
                boolean bl = false;
                TargetEnvironment.UploadRoot uploadRoot = this.$this_getTargetUploadPath$inlined;
                TargetEnvironment.UploadableVolume uploadableVolume = targetEnvironment.getUploadVolumes().get(uploadRoot);
                if (uploadableVolume == null) {
                    throw (Throwable)new IllegalStateException("Upload root \"" + uploadRoot + "\" cannot be found");
                }
                TargetEnvironment.UploadableVolume uploadableVolume2 = uploadableVolume;
                return uploadableVolume2.getTargetRoot();
            }
        };
    }

    @NotNull
    public static final Function<TargetEnvironment, String> getRelativeTargetPath(@NotNull Function<TargetEnvironment, String> $this$getRelativeTargetPath, @NotNull String targetRelativePath) {
        Intrinsics.checkNotNullParameter($this$getRelativeTargetPath, (String)"$this$getRelativeTargetPath");
        Intrinsics.checkNotNullParameter((Object)targetRelativePath, (String)"targetRelativePath");
        TraceableTargetEnvironmentFunction.Companion this_$iv = TraceableTargetEnvironmentFunction.Companion;
        boolean $i$f$invoke = false;
        return new TraceableTargetEnvironmentFunction<String>($this$getRelativeTargetPath, targetRelativePath){
            final /* synthetic */ Function $this_getRelativeTargetPath$inlined;
            final /* synthetic */ String $targetRelativePath$inlined;
            {
                this.$this_getRelativeTargetPath$inlined = function;
                this.$targetRelativePath$inlined = string;
            }

            public String applyInner(@NotNull TargetEnvironment t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                TargetEnvironment targetEnvironment = t;
                boolean bl = false;
                R r = this.$this_getRelativeTargetPath$inlined.apply(targetEnvironment);
                Intrinsics.checkNotNullExpressionValue(r, (String)"this@getRelativeTargetPa\u2026.apply(targetEnvironment)");
                String targetBasePath = (String)r;
                return TargetEnvironmentFunctions.access$joinPaths(targetBasePath, this.$targetRelativePath$inlined, targetEnvironment.getTargetPlatform());
            }
        };
    }

    @NotNull
    public static final Function<TargetEnvironment, String> getTargetDownloadPath(@NotNull TargetEnvironment.DownloadRoot $this$getTargetDownloadPath) {
        Intrinsics.checkNotNullParameter((Object)$this$getTargetDownloadPath, (String)"$this$getTargetDownloadPath");
        TraceableTargetEnvironmentFunction.Companion this_$iv = TraceableTargetEnvironmentFunction.Companion;
        boolean $i$f$invoke = false;
        return new TraceableTargetEnvironmentFunction<String>($this$getTargetDownloadPath){
            final /* synthetic */ TargetEnvironment.DownloadRoot $this_getTargetDownloadPath$inlined;
            {
                this.$this_getTargetDownloadPath$inlined = downloadRoot;
            }

            public String applyInner(@NotNull TargetEnvironment t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                TargetEnvironment targetEnvironment = t;
                boolean bl = false;
                TargetEnvironment.DownloadRoot downloadRoot = this.$this_getTargetDownloadPath$inlined;
                TargetEnvironment.DownloadableVolume downloadableVolume = targetEnvironment.getDownloadVolumes().get(downloadRoot);
                if (downloadableVolume == null) {
                    throw (Throwable)new IllegalStateException("Download root \"" + downloadRoot + "\" cannot be found");
                }
                TargetEnvironment.DownloadableVolume downloadableVolume2 = downloadableVolume;
                return downloadableVolume2.getTargetRoot();
            }
        };
    }

    @NotNull
    public static final Function<TargetEnvironment, HostPort> getTargetEnvironmentValue(@NotNull TargetEnvironment.LocalPortBinding $this$getTargetEnvironmentValue) {
        Intrinsics.checkNotNullParameter((Object)$this$getTargetEnvironmentValue, (String)"$this$getTargetEnvironmentValue");
        TraceableTargetEnvironmentFunction.Companion this_$iv = TraceableTargetEnvironmentFunction.Companion;
        boolean $i$f$invoke = false;
        return new TraceableTargetEnvironmentFunction<HostPort>($this$getTargetEnvironmentValue){
            final /* synthetic */ TargetEnvironment.LocalPortBinding $this_getTargetEnvironmentValue$inlined;
            {
                this.$this_getTargetEnvironmentValue$inlined = localPortBinding;
            }

            public HostPort applyInner(@NotNull TargetEnvironment t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                TargetEnvironment targetEnvironment = t;
                boolean bl = false;
                TargetEnvironment.LocalPortBinding localPortBinding = this.$this_getTargetEnvironmentValue$inlined;
                ResolvedPortBinding resolvedPortBinding = targetEnvironment.getLocalPortBindings().get(localPortBinding);
                if (resolvedPortBinding == null) {
                    throw (Throwable)new IllegalStateException("Local port binding \"" + localPortBinding + "\" cannot be found");
                }
                ResolvedPortBinding resolvedPortBinding2 = resolvedPortBinding;
                return resolvedPortBinding2.getTargetEndpoint();
            }
        };
    }

    public static final void downloadFromTarget(@NotNull TargetEnvironment $this$downloadFromTarget, @NotNull Path localPath, @NotNull ProgressIndicator progressIndicator) throws IOException {
        Object v0;
        boolean bl;
        Object object;
        Path localFileDir;
        block2: {
            Intrinsics.checkNotNullParameter((Object)$this$downloadFromTarget, (String)"$this$downloadFromTarget");
            Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
            Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
            localFileDir = localPath.getParent();
            Collection<TargetEnvironment.DownloadableVolume> downloadVolumes = $this$downloadFromTarget.getDownloadVolumes().values();
            object = downloadVolumes;
            bl = false;
            Iterable iterable = object;
            boolean bl2 = false;
            for (Object t : iterable) {
                TargetEnvironment.DownloadableVolume it = (TargetEnvironment.DownloadableVolume)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getLocalRoot(), (Object)localFileDir)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        TargetEnvironment.DownloadableVolume downloadableVolume = v0;
        if (downloadableVolume == null) {
            object = "Volume with local root " + localFileDir + " not found";
            bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        TargetEnvironment.DownloadableVolume downloadVolume = downloadableVolume;
        downloadVolume.download(PathsKt.getName((Path)localPath), progressIndicator);
    }

    public static final /* synthetic */ String access$tryMapToSynchronizedVolume(ExternallySynchronized $this$access_u24tryMapToSynchronizedVolume, String localPath) {
        return TargetEnvironmentFunctions.tryMapToSynchronizedVolume($this$access_u24tryMapToSynchronizedVolume, localPath);
    }

    public static final /* synthetic */ String access$joinPaths(String basePath, String relativePath, TargetPlatform targetPlatform) {
        return TargetEnvironmentFunctions.joinPaths(basePath, relativePath, targetPlatform);
    }
}

