/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actionSystem;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.DocumentRunnable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.textarea.TextComponentEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EditorWriteActionHandler
extends EditorActionHandler {
    private boolean inExecution;

    protected EditorWriteActionHandler() {
    }

    protected EditorWriteActionHandler(boolean runForEachCaret) {
        super(runForEachCaret);
    }

    @Override
    public void doExecute(final @NotNull Editor editor, final @Nullable Caret caret, final DataContext dataContext) {
        if (editor == null) {
            EditorWriteActionHandler.$$$reportNull$$$0(0);
        }
        if (!EditorModificationUtil.checkModificationAllowed(editor)) {
            return;
        }
        if (!ApplicationManager.getApplication().isWriteAccessAllowed() && !EditorModificationUtil.requestWriting(editor)) {
            return;
        }
        DocumentRunnable runnable = new DocumentRunnable(editor.getDocument(), editor.getProject()){

            @Override
            public void run() {
                Document doc = editor.getDocument();
                doc.startGuardedBlockChecking();
                try {
                    EditorWriteActionHandler.this.executeWriteAction(editor, caret, dataContext);
                }
                catch (ReadOnlyFragmentModificationException e) {
                    EditorActionManager.getInstance().getReadonlyFragmentModificationHandler(doc).handle(e);
                }
                finally {
                    doc.stopGuardedBlockChecking();
                }
            }
        };
        if (editor instanceof TextComponentEditor) {
            runnable.run();
        } else {
            ApplicationManager.getApplication().runWriteAction(runnable);
        }
    }

    @Deprecated
    public void executeWriteAction(Editor editor, DataContext dataContext) {
        this.executeWriteAction(editor, editor.getCaretModel().getCurrentCaret(), dataContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeWriteAction(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
        if (editor == null) {
            EditorWriteActionHandler.$$$reportNull$$$0(1);
        }
        if (this.inExecution) {
            return;
        }
        try {
            this.inExecution = true;
            this.executeWriteAction(editor, dataContext);
        }
        finally {
            this.inExecution = false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "editor";
        objectArray2[1] = "com/intellij/openapi/editor/actionSystem/EditorWriteActionHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doExecute";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "executeWriteAction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static abstract class ForEachCaret
    extends EditorWriteActionHandler {
        protected ForEachCaret() {
            super(true);
        }

        @Override
        public abstract void executeWriteAction(@NotNull Editor var1, @NotNull Caret var2, DataContext var3);
    }
}

