/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ArchiveFileSystem
extends NewVirtualFileSystem {
    private static final Key<VirtualFile> LOCAL_FILE = Key.create((String)"vfs.archive.local.file");
    private final Function<VirtualFile, FileAttributes> myAttrGetter = ManagingFS.getInstance().accessDiskWithCheckCanceled(file -> this.getHandler((VirtualFile)file).getAttributes(this.getRelativePath((VirtualFile)file)));
    private final Function<VirtualFile, String[]> myChildrenGetter = ManagingFS.getInstance().accessDiskWithCheckCanceled(file -> this.getHandler((VirtualFile)file).list(this.getRelativePath((VirtualFile)file)));
    private final Function<VirtualFile, Pair<byte[], IOException>> myContentGetter = ManagingFS.getInstance().accessDiskWithCheckCanceled(file -> {
        try {
            return Pair.pair((Object)this.getHandler((VirtualFile)file).contentsToByteArray(this.getRelativePath((VirtualFile)file)), null);
        }
        catch (IOException e) {
            return Pair.pair(null, (Object)e);
        }
    });

    @Nullable
    public VirtualFile getRootByLocal(@NotNull VirtualFile file) {
        if (file == null) {
            ArchiveFileSystem.$$$reportNull$$$0(0);
        }
        return this.isCorrectFileType(file) ? this.findFileByPath(this.getRootPathByLocal(file)) : null;
    }

    @NotNull
    public String getRootPathByLocal(@NotNull VirtualFile file) {
        if (file == null) {
            ArchiveFileSystem.$$$reportNull$$$0(1);
        }
        String string = this.composeRootPath(file.getPath());
        if (string == null) {
            ArchiveFileSystem.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public VirtualFile getRootByEntry(@NotNull VirtualFile entry) {
        if (entry == null) {
            ArchiveFileSystem.$$$reportNull$$$0(3);
        }
        return entry.getFileSystem() == this ? VfsUtilCore.getRootFile(entry) : null;
    }

    @Nullable
    public VirtualFile getLocalByEntry(@NotNull VirtualFile entry) {
        if (entry == null) {
            ArchiveFileSystem.$$$reportNull$$$0(4);
        }
        if (entry.getFileSystem() != this) {
            return null;
        }
        VirtualFile root = this.getRootByEntry(entry);
        assert (root != null) : entry;
        VirtualFile local = (VirtualFile)LOCAL_FILE.get((UserDataHolder)root);
        if (local == null) {
            String localPath = this.extractLocalPath(root.getPath());
            local = StandardFileSystems.local().findFileByPath(localPath);
            if (local != null) {
                LOCAL_FILE.set((UserDataHolder)root, (Object)local);
            }
        }
        return local;
    }

    @NotNull
    protected abstract String extractLocalPath(@NotNull String var1);

    @NotNull
    protected abstract String composeRootPath(@NotNull String var1);

    @NotNull
    protected abstract ArchiveHandler getHandler(@NotNull VirtualFile var1);

    @Override
    public int getRank() {
        return LocalFileSystem.getInstance().getRank() + 1;
    }

    @Override
    @NotNull
    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        if (file == null) {
            ArchiveFileSystem.$$$reportNull$$$0(5);
        }
        if (newParent == null) {
            ArchiveFileSystem.$$$reportNull$$$0(6);
        }
        if (copyName == null) {
            ArchiveFileSystem.$$$reportNull$$$0(7);
        }
        throw new IOException(AnalysisBundle.message("jar.modification.not.supported.error", file.getUrl()));
    }

    @Override
    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile parent, @NotNull String dir) throws IOException {
        if (parent == null) {
            ArchiveFileSystem.$$$reportNull$$$0(8);
        }
        if (dir == null) {
            ArchiveFileSystem.$$$reportNull$$$0(9);
        }
        throw new IOException(AnalysisBundle.message("jar.modification.not.supported.error", parent.getUrl()));
    }

    @Override
    @NotNull
    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile parent, @NotNull String file) throws IOException {
        if (parent == null) {
            ArchiveFileSystem.$$$reportNull$$$0(10);
        }
        if (file == null) {
            ArchiveFileSystem.$$$reportNull$$$0(11);
        }
        throw new IOException(AnalysisBundle.message("jar.modification.not.supported.error", parent.getUrl()));
    }

    @Override
    public void deleteFile(Object requestor, @NotNull VirtualFile file) throws IOException {
        if (file == null) {
            ArchiveFileSystem.$$$reportNull$$$0(12);
        }
        throw new IOException(AnalysisBundle.message("jar.modification.not.supported.error", file.getUrl()));
    }

    @Override
    public void moveFile(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile newParent) throws IOException {
        if (file == null) {
            ArchiveFileSystem.$$$reportNull$$$0(13);
        }
        if (newParent == null) {
            ArchiveFileSystem.$$$reportNull$$$0(14);
        }
        throw new IOException(AnalysisBundle.message("jar.modification.not.supported.error", file.getUrl()));
    }

    @Override
    public void renameFile(Object requestor, @NotNull VirtualFile file, @NotNull String newName) throws IOException {
        if (file == null) {
            ArchiveFileSystem.$$$reportNull$$$0(15);
        }
        if (newName == null) {
            ArchiveFileSystem.$$$reportNull$$$0(16);
        }
        throw new IOException(AnalysisBundle.message("jar.modification.not.supported.error", file.getUrl()));
    }

    @NotNull
    protected String getRelativePath(@NotNull VirtualFile file) {
        if (file == null) {
            ArchiveFileSystem.$$$reportNull$$$0(17);
        }
        String relativePath = file.getPath().substring(VfsUtilCore.getRootFile(file).getPath().length());
        String string = StringUtil.trimLeading((String)relativePath, (char)'/');
        if (string == null) {
            ArchiveFileSystem.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Override
    @Nullable
    public FileAttributes getAttributes(@NotNull VirtualFile file) {
        if (file == null) {
            ArchiveFileSystem.$$$reportNull$$$0(19);
        }
        return this.myAttrGetter.apply(file);
    }

    @Override
    public String @NotNull [] list(@NotNull VirtualFile file) {
        if (file == null) {
            ArchiveFileSystem.$$$reportNull$$$0(20);
        }
        String[] stringArray = this.myChildrenGetter.apply(file);
        if (stringArray == null) {
            ArchiveFileSystem.$$$reportNull$$$0(21);
        }
        return stringArray;
    }

    @Override
    public boolean exists(@NotNull VirtualFile file) {
        if (file == null) {
            ArchiveFileSystem.$$$reportNull$$$0(22);
        }
        if (file.getParent() == null) {
            return this.getLocalByEntry(file) != null;
        }
        return this.getAttributes(file) != null;
    }

    @Override
    public boolean isDirectory(@NotNull VirtualFile file) {
        if (file == null) {
            ArchiveFileSystem.$$$reportNull$$$0(23);
        }
        if (file.getParent() == null) {
            return true;
        }
        FileAttributes attributes = this.getAttributes(file);
        return attributes == null || attributes.isDirectory();
    }

    @Override
    public boolean isWritable(@NotNull VirtualFile file) {
        if (file == null) {
            ArchiveFileSystem.$$$reportNull$$$0(24);
        }
        return false;
    }

    @Override
    public long getTimeStamp(@NotNull VirtualFile file) {
        if (file == null) {
            ArchiveFileSystem.$$$reportNull$$$0(25);
        }
        if (file.getParent() == null) {
            VirtualFile host = this.getLocalByEntry(file);
            if (host != null) {
                return host.getTimeStamp();
            }
        } else {
            FileAttributes attributes = this.getAttributes(file);
            if (attributes != null) {
                return attributes.lastModified;
            }
        }
        return -1L;
    }

    @Override
    public long getLength(@NotNull VirtualFile file) {
        if (file == null) {
            ArchiveFileSystem.$$$reportNull$$$0(26);
        }
        if (file.getParent() == null) {
            VirtualFile host = this.getLocalByEntry(file);
            if (host != null) {
                return host.getLength();
            }
        } else {
            FileAttributes attributes = this.getAttributes(file);
            if (attributes != null) {
                return attributes.length;
            }
        }
        return 0L;
    }

    @Override
    public byte @NotNull [] contentsToByteArray(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            ArchiveFileSystem.$$$reportNull$$$0(27);
        }
        Pair<byte[], IOException> pair = this.myContentGetter.apply(file);
        IOException exception = (IOException)pair.second;
        if (exception != null) {
            exception.addSuppressed(new Throwable("Caller thread's stacktrace"));
            throw exception;
        }
        byte[] byArray = (byte[])pair.first;
        if (byArray == null) {
            ArchiveFileSystem.$$$reportNull$$$0(28);
        }
        return byArray;
    }

    @Override
    @NotNull
    public InputStream getInputStream(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            ArchiveFileSystem.$$$reportNull$$$0(29);
        }
        InputStream inputStream = this.getHandler(file).getInputStream(this.getRelativePath(file));
        if (inputStream == null) {
            ArchiveFileSystem.$$$reportNull$$$0(30);
        }
        return inputStream;
    }

    @Override
    public void setTimeStamp(@NotNull VirtualFile file, long timeStamp) throws IOException {
        if (file == null) {
            ArchiveFileSystem.$$$reportNull$$$0(31);
        }
        throw new IOException(AnalysisBundle.message("jar.modification.not.supported.error", file.getUrl()));
    }

    @Override
    public void setWritable(@NotNull VirtualFile file, boolean writableFlag) throws IOException {
        if (file == null) {
            ArchiveFileSystem.$$$reportNull$$$0(32);
        }
        throw new IOException(AnalysisBundle.message("jar.modification.not.supported.error", file.getUrl()));
    }

    @Override
    @NotNull
    public OutputStream getOutputStream(@NotNull VirtualFile file, Object requestor, long modStamp, long l) throws IOException {
        if (file == null) {
            ArchiveFileSystem.$$$reportNull$$$0(33);
        }
        throw new IOException(AnalysisBundle.message("jar.modification.not.supported.error", file.getUrl()));
    }

    @Nullable
    public VirtualFile findLocalByRootPath(@NotNull String rootPath) {
        if (rootPath == null) {
            ArchiveFileSystem.$$$reportNull$$$0(34);
        }
        String localPath = this.extractLocalPath(rootPath);
        VirtualFile local = StandardFileSystems.local().findFileByPath(localPath);
        return local != null && this.isCorrectFileType(local) ? local : null;
    }

    protected boolean isCorrectFileType(@NotNull VirtualFile local) {
        if (local == null) {
            ArchiveFileSystem.$$$reportNull$$$0(35);
        }
        return FileTypeRegistry.getInstance().getFileTypeByFileName(local.getNameSequence()) == ArchiveFileType.INSTANCE;
    }

    @ApiStatus.Internal
    public final void clearArchiveCache(@NotNull VirtualFile sampleEntry) {
        if (sampleEntry == null) {
            ArchiveFileSystem.$$$reportNull$$$0(36);
        }
        this.getHandler(sampleEntry).clearCaches();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 18: 
            case 21: 
            case 28: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 18: 
            case 21: 
            case 28: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 18: 
            case 21: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/ArchiveFileSystem";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyName";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "local";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sampleEntry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/ArchiveFileSystem";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootPathByLocal";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativePath";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRootByLocal";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRootPathByLocal";
                break;
            }
            case 2: 
            case 18: 
            case 21: 
            case 28: 
            case 30: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRootByEntry";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLocalByEntry";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "copyFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createChildDirectory";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createChildFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "deleteFile";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "moveFile";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "renameFile";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "exists";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isDirectory";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isWritable";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getTimeStamp";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getLength";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "contentsToByteArray";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getInputStream";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "setTimeStamp";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setWritable";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getOutputStream";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findLocalByRootPath";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isCorrectFileType";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "clearArchiveCache";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 18: 
            case 21: 
            case 28: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

