/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiNonJavaFileReferenceProcessor;
import com.intellij.psi.search.ScopeOptimizer;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.util.Processor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PsiSearchHelper {
    @ApiStatus.Internal
    public static final ExtensionPointName<ScopeOptimizer> CODE_USAGE_SCOPE_OPTIMIZER_EP_NAME = ExtensionPointName.create((String)"com.intellij.codeUsageScopeOptimizer");

    @NotNull
    public static PsiSearchHelper getInstance(@NotNull Project project) {
        if (project == null) {
            PsiSearchHelper.$$$reportNull$$$0(0);
        }
        PsiSearchHelper psiSearchHelper = (PsiSearchHelper)project.getService(PsiSearchHelper.class);
        if (psiSearchHelper == null) {
            PsiSearchHelper.$$$reportNull$$$0(1);
        }
        return psiSearchHelper;
    }

    public PsiElement @NotNull [] findCommentsContainingIdentifier(@NotNull String var1, @NotNull SearchScope var2);

    public boolean processCommentsContainingIdentifier(@NotNull String var1, @NotNull SearchScope var2, @NotNull Processor<? super PsiElement> var3);

    public boolean processCandidateFilesForText(@NotNull GlobalSearchScope var1, short var2, boolean var3, @NotNull String var4, @NotNull Processor<? super VirtualFile> var5);

    public PsiFile @NotNull [] findFilesWithPlainTextWords(@NotNull String var1);

    public boolean processUsagesInNonJavaFiles(@NotNull String var1, @NotNull PsiNonJavaFileReferenceProcessor var2, @NotNull GlobalSearchScope var3);

    public boolean processUsagesInNonJavaFiles(@Nullable PsiElement var1, @NotNull String var2, @NotNull PsiNonJavaFileReferenceProcessor var3, @NotNull GlobalSearchScope var4);

    @NotNull
    public SearchScope getUseScope(@NotNull PsiElement var1);

    @NotNull
    default public SearchScope getCodeUsageScope(@NotNull PsiElement element) {
        if (element == null) {
            PsiSearchHelper.$$$reportNull$$$0(2);
        }
        SearchScope searchScope = this.getUseScope(element);
        if (searchScope == null) {
            PsiSearchHelper.$$$reportNull$$$0(3);
        }
        return searchScope;
    }

    public boolean processAllFilesWithWord(@NotNull String var1, @NotNull GlobalSearchScope var2, @NotNull Processor<? super PsiFile> var3, boolean var4);

    public boolean processAllFilesWithWordInText(@NotNull String var1, @NotNull GlobalSearchScope var2, @NotNull Processor<? super PsiFile> var3, boolean var4);

    public boolean processAllFilesWithWordInComments(@NotNull String var1, @NotNull GlobalSearchScope var2, @NotNull Processor<? super PsiFile> var3);

    public boolean processAllFilesWithWordInLiterals(@NotNull String var1, @NotNull GlobalSearchScope var2, @NotNull Processor<? super PsiFile> var3);

    public boolean processRequests(@NotNull SearchRequestCollector var1, @NotNull Processor<? super PsiReference> var2);

    @NotNull
    public AsyncFuture<Boolean> processRequestsAsync(@NotNull SearchRequestCollector var1, @NotNull Processor<? super PsiReference> var2);

    public boolean processElementsWithWord(@NotNull TextOccurenceProcessor var1, @NotNull SearchScope var2, @NotNull String var3, short var4, boolean var5);

    public boolean processElementsWithWord(@NotNull TextOccurenceProcessor var1, @NotNull SearchScope var2, @NotNull String var3, short var4, boolean var5, boolean var6);

    default public boolean hasIdentifierInFile(@NotNull PsiFile file, @NotNull String name) {
        if (file == null) {
            PsiSearchHelper.$$$reportNull$$$0(4);
        }
        if (name == null) {
            PsiSearchHelper.$$$reportNull$$$0(5);
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public AsyncFuture<Boolean> processElementsWithWordAsync(@NotNull TextOccurenceProcessor var1, @NotNull SearchScope var2, @NotNull String var3, short var4, boolean var5);

    @NotNull
    public SearchCostResult isCheapEnoughToSearch(@NotNull String var1, @NotNull GlobalSearchScope var2, @Nullable PsiFile var3, @Nullable ProgressIndicator var4);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/PsiSearchHelper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/PsiSearchHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeUsageScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCodeUsageScope";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasIdentifierInFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum SearchCostResult {
        ZERO_OCCURRENCES,
        FEW_OCCURRENCES,
        TOO_MANY_OCCURRENCES;

    }

    public static final class SERVICE {
        private SERVICE() {
        }

        @Deprecated
        public static PsiSearchHelper getInstance(@NotNull Project project) {
            if (project == null) {
                SERVICE.$$$reportNull$$$0(0);
            }
            return PsiSearchHelper.getInstance(project);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/PsiSearchHelper$SERVICE", "getInstance"));
        }
    }
}

