/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.impl;

import com.intellij.openapi.vfs.CompactVirtualFileSet;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSet;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.search.impl.VirtualFileEnumeration;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class IntersectionFileEnumeration
implements VirtualFileEnumeration {
    @NotNull
    private final Collection<VirtualFileEnumeration> myHints;

    public IntersectionFileEnumeration(@NotNull Collection<VirtualFileEnumeration> hints) {
        if (hints == null) {
            IntersectionFileEnumeration.$$$reportNull$$$0(0);
        }
        this.myHints = hints;
    }

    @Override
    public boolean contains(int fileId) {
        if (this.myHints.isEmpty()) {
            return false;
        }
        for (VirtualFileEnumeration scope : this.myHints) {
            if (scope.contains(fileId)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int[] asInts() {
        Iterable<VirtualFile> files = this.asIterable();
        if (files instanceof Collection && ((Collection)files).isEmpty()) {
            return ArrayUtil.EMPTY_INT_ARRAY;
        }
        if (files instanceof CompactVirtualFileSet) {
            return ((CompactVirtualFileSet)files).onlyInternalFileIds();
        }
        IntArrayList result = new IntArrayList();
        for (VirtualFile file : files) {
            if (!(file instanceof VirtualFileWithId)) continue;
            int fileId = ((VirtualFileWithId)((Object)file)).getId();
            result.add(fileId);
        }
        return result.toArray();
    }

    @Override
    @NotNull
    public Iterable<VirtualFile> asIterable() {
        if (this.myHints.isEmpty()) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                IntersectionFileEnumeration.$$$reportNull$$$0(1);
            }
            return set;
        }
        if (this.myHints.size() == 1) {
            Iterable<VirtualFile> iterable = this.myHints.iterator().next().asIterable();
            if (iterable == null) {
                IntersectionFileEnumeration.$$$reportNull$$$0(2);
            }
            return iterable;
        }
        VirtualFileSet files = null;
        for (VirtualFileEnumeration scope : this.myHints) {
            Collection scopeFiles = ContainerUtil.toCollection(scope.asIterable());
            if (files == null) {
                files = VfsUtilCore.createCompactVirtualFileSet(scopeFiles);
                continue;
            }
            files.retainAll(scopeFiles);
        }
        VirtualFileSet virtualFileSet = files;
        if (virtualFileSet == null) {
            IntersectionFileEnumeration.$$$reportNull$$$0(3);
        }
        return virtualFileSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hints";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/impl/IntersectionFileEnumeration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/impl/IntersectionFileEnumeration";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "asIterable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

