/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ContributedReferenceHost;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PartiallyKnownString;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u0001:\u0002\u0013\u0014B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0011\u001a\u00020\u0012*\u0004\u0018\u00010\u0004H\u0002R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001f\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006\u0082\u0001\u0002\u0015\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/psi/util/StringEntry;", "", "()V", "host", "Lcom/intellij/psi/PsiElement;", "getHost", "()Lcom/intellij/psi/PsiElement;", "range", "Lcom/intellij/openapi/util/TextRange;", "getRange", "()Lcom/intellij/openapi/util/TextRange;", "rangeAlignedToHost", "Lkotlin/Pair;", "getRangeAlignedToHost", "()Lkotlin/Pair;", "sourcePsi", "getSourcePsi", "isSuitableHostClass", "", "Known", "Unknown", "Lcom/intellij/psi/util/StringEntry$Known;", "Lcom/intellij/psi/util/StringEntry$Unknown;", "intellij.platform.lang"})
@ApiStatus.Experimental
public abstract class StringEntry {
    @Nullable
    public abstract PsiElement getSourcePsi();

    @NotNull
    public abstract TextRange getRange();

    @Nullable
    public final PsiElement getHost() {
        PsiElement psiElement = this.getSourcePsi();
        boolean bl = false;
        boolean bl2 = false;
        PsiElement it = psiElement;
        boolean bl3 = false;
        PsiElement psiElement2 = this.isSuitableHostClass(it) ? psiElement : null;
        if (psiElement2 == null) {
            PsiElement psiElement3 = this.getSourcePsi();
            psiElement = psiElement3 != null ? psiElement3.getParent() : null;
            bl = false;
            bl2 = false;
            it = psiElement;
            boolean bl4 = false;
            psiElement2 = this.isSuitableHostClass(it) ? psiElement : null;
        }
        return psiElement2;
    }

    @Nullable
    public final Pair<PsiElement, TextRange> getRangeAlignedToHost() {
        StringEntry entry = this;
        PsiElement psiElement = entry.getSourcePsi();
        if (psiElement == null) {
            return null;
        }
        PsiElement sourcePsi = psiElement;
        if (this.isSuitableHostClass(sourcePsi)) {
            return TuplesKt.to((Object)sourcePsi, (Object)entry.getRange());
        }
        PsiElement parent = sourcePsi.getParent();
        if (parent instanceof PsiLanguageInjectionHost) {
            TextRange textRange = entry.getRange().shiftRight(sourcePsi.getStartOffsetInParent());
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"entry.range.shiftRight(s\u2026ePsi.startOffsetInParent)");
            return TuplesKt.to((Object)parent, (Object)textRange);
        }
        return null;
    }

    private final boolean isSuitableHostClass(PsiElement $this$isSuitableHostClass) {
        PsiElement psiElement = $this$isSuitableHostClass;
        return psiElement instanceof ContributedReferenceHost || psiElement instanceof PsiLanguageInjectionHost;
    }

    private StringEntry() {
    }

    public /* synthetic */ StringEntry(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0003H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lcom/intellij/psi/util/StringEntry$Known;", "Lcom/intellij/psi/util/StringEntry;", "value", "", "sourcePsi", "Lcom/intellij/psi/PsiElement;", "range", "Lcom/intellij/openapi/util/TextRange;", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/TextRange;)V", "getRange", "()Lcom/intellij/openapi/util/TextRange;", "getSourcePsi", "()Lcom/intellij/psi/PsiElement;", "getValue", "()Ljava/lang/String;", "toString", "intellij.platform.lang"})
    public static final class Known
    extends StringEntry {
        @NotNull
        private final String value;
        @Nullable
        private final PsiElement sourcePsi;
        @NotNull
        private final TextRange range;

        @NotNull
        public String toString() {
            return "StringEntry.Known('" + this.value + "' at " + this.getRange() + " in " + this.getSourcePsi() + ')';
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @Override
        @Nullable
        public PsiElement getSourcePsi() {
            return this.sourcePsi;
        }

        @Override
        @NotNull
        public TextRange getRange() {
            return this.range;
        }

        public Known(@NotNull String value2, @Nullable PsiElement sourcePsi, @NotNull TextRange range2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Intrinsics.checkNotNullParameter((Object)range2, (String)"range");
            super(null);
            this.value = value2;
            this.sourcePsi = sourcePsi;
            this.range = range2;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B+\b\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u001e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lcom/intellij/psi/util/StringEntry$Unknown;", "Lcom/intellij/psi/util/StringEntry;", "sourcePsi", "Lcom/intellij/psi/PsiElement;", "range", "Lcom/intellij/openapi/util/TextRange;", "possibleValues", "", "Lcom/intellij/psi/util/PartiallyKnownString;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/TextRange;Ljava/lang/Iterable;)V", "getPossibleValues", "()Ljava/lang/Iterable;", "getRange", "()Lcom/intellij/openapi/util/TextRange;", "getSourcePsi", "()Lcom/intellij/psi/PsiElement;", "toString", "", "intellij.platform.lang"})
    public static final class Unknown
    extends StringEntry {
        @Nullable
        private final PsiElement sourcePsi;
        @NotNull
        private final TextRange range;
        @ApiStatus.Internal
        @Nullable
        private final Iterable<PartiallyKnownString> possibleValues;

        @NotNull
        public String toString() {
            return "StringEntry.Unknown(at " + this.getRange() + " in " + this.getSourcePsi() + ')';
        }

        @Override
        @Nullable
        public PsiElement getSourcePsi() {
            return this.sourcePsi;
        }

        @Override
        @NotNull
        public TextRange getRange() {
            return this.range;
        }

        @Nullable
        public final Iterable<PartiallyKnownString> getPossibleValues() {
            return this.possibleValues;
        }

        @JvmOverloads
        public Unknown(@Nullable PsiElement sourcePsi, @NotNull TextRange range2, @Nullable Iterable<PartiallyKnownString> possibleValues) {
            Intrinsics.checkNotNullParameter((Object)range2, (String)"range");
            super(null);
            this.sourcePsi = sourcePsi;
            this.range = range2;
            this.possibleValues = possibleValues;
        }

        public /* synthetic */ Unknown(PsiElement psiElement, TextRange textRange, Iterable iterable, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                iterable = null;
            }
            this(psiElement, textRange, iterable);
        }

        @JvmOverloads
        public Unknown(@Nullable PsiElement sourcePsi, @NotNull TextRange range2) {
            this(sourcePsi, range2, null, 4, null);
        }
    }
}

