/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.net.HttpConfigurable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JBCefProxySettings {
    public final boolean USE_HTTP_PROXY;
    public final boolean USE_PROXY_PAC;
    public final boolean USE_PAC_URL;
    @Nullable
    public final String PAC_URL;
    @Nullable
    public final String PROXY_HOST;
    public final int PROXY_PORT;
    public final boolean PROXY_AUTHENTICATION;
    @NotNull
    private final Credentials myCredentials;
    @Nullable
    private static JBCefProxySettings ourTestInstance;

    private JBCefProxySettings(boolean useHttpProxy, boolean useProxyPac, boolean usePacUrl, @Nullable String pacUrl, @Nullable String proxyHost, int proxyPort, boolean proxyAuthentication, @NotNull Credentials credentials) {
        if (credentials == null) {
            JBCefProxySettings.$$$reportNull$$$0(0);
        }
        this.USE_HTTP_PROXY = useHttpProxy;
        this.USE_PROXY_PAC = useProxyPac;
        this.USE_PAC_URL = usePacUrl;
        this.PAC_URL = pacUrl;
        this.PROXY_HOST = proxyHost;
        this.PROXY_PORT = proxyPort;
        this.PROXY_AUTHENTICATION = proxyAuthentication;
        this.myCredentials = credentials;
    }

    @NotNull
    public static JBCefProxySettings getInstance() {
        if (ApplicationManager.getApplication().isUnitTestMode() && ourTestInstance != null) {
            JBCefProxySettings jBCefProxySettings = ourTestInstance;
            if (jBCefProxySettings == null) {
                JBCefProxySettings.$$$reportNull$$$0(1);
            }
            return jBCefProxySettings;
        }
        final HttpConfigurable httpSettings = HttpConfigurable.getInstance();
        return new JBCefProxySettings(httpSettings.USE_HTTP_PROXY, httpSettings.USE_PROXY_PAC, httpSettings.USE_PAC_URL, httpSettings.PAC_URL, httpSettings.PROXY_HOST, httpSettings.PROXY_PORT, httpSettings.PROXY_AUTHENTICATION, new Credentials(){

            @Override
            @Nullable
            public String getLogin() {
                return httpSettings.getProxyLogin();
            }

            @Override
            @Nullable
            public String getPassword() {
                return httpSettings.getPlainProxyPassword();
            }
        });
    }

    public static void setTestInstance(boolean useHttpProxy, boolean useProxyPac, boolean usePacUrl, @Nullable String pacUrl, @Nullable String proxyHost, int proxyPort, boolean proxyAuthentication, final @Nullable String login, final @Nullable String password) {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            throw new IllegalStateException("not in unit test mode!");
        }
        ourTestInstance = new JBCefProxySettings(useHttpProxy, useProxyPac, usePacUrl, pacUrl, proxyHost, proxyPort, proxyAuthentication, new Credentials(){

            @Override
            @Nullable
            public String getLogin() {
                return login;
            }

            @Override
            @Nullable
            public String getPassword() {
                return password;
            }
        });
    }

    @Nullable
    public String getProxyLogin() {
        return this.myCredentials.getLogin();
    }

    @Nullable
    public String getPlainProxyPassword() {
        return this.myCredentials.getPassword();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/jcef/JBCefProxySettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/jcef/JBCefProxySettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface Credentials {
        @Nullable
        public String getLogin();

        @Nullable
        public String getPassword();
    }
}

