/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.ide.tags.TagManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.reference.SoftReference;
import com.intellij.ui.ColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usages.TextChunk;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageNodePresentation;
import com.intellij.usages.impl.Node;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.impl.UsageTargetNode;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.rules.MergeableUsage;
import com.intellij.util.Consumer;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.Color;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GroupNode
extends Node
implements Navigatable,
Comparable<GroupNode> {
    private static final NodeComparator COMPARATOR = new NodeComparator();
    private final int myRuleIndex;
    private int myRecursiveUsageCount;
    private final List<Node> myChildren;
    private volatile Reference<UsageNodePresentation> myCachedPresentation;

    private GroupNode(@NotNull Node parent, @NotNull UsageGroup group, int ruleIndex) {
        if (parent == null) {
            GroupNode.$$$reportNull$$$0(0);
        }
        if (group == null) {
            GroupNode.$$$reportNull$$$0(1);
        }
        this.myChildren = new SmartList();
        this.setUserObject(group);
        this.setParent(parent);
        this.myRuleIndex = ruleIndex;
    }

    private GroupNode() {
        this.myChildren = new SmartList();
        this.myRuleIndex = 0;
    }

    @Override
    protected void updateNotify() {
        if (this.getGroup() != null) {
            this.getGroup().update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        String result = this.getGroup() == null ? "" : this.getGroup().getPresentableGroupText();
        GroupNode groupNode = this;
        synchronized (groupNode) {
            return result + ContainerUtil.getFirstItems(this.myChildren, (int)10);
        }
    }

    @NotNull
    List<Node> getChildren() {
        List<Node> list = this.myChildren;
        if (list == null) {
            GroupNode.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    List<Node> getSwingChildren() {
        Vector children2 = this.children;
        List list = (List)ObjectUtils.notNull((Object)children2, Collections.emptyList());
        if (list == null) {
            GroupNode.$$$reportNull$$$0(3);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    GroupNode addOrGetGroup(@NotNull UsageGroup group, int ruleIndex, @NotNull Consumer<? super UsageViewImpl.NodeChange> edtModelToSwingNodeChangesQueue) {
        if (group == null) {
            GroupNode.$$$reportNull$$$0(4);
        }
        if (edtModelToSwingNodeChangesQueue == null) {
            GroupNode.$$$reportNull$$$0(5);
        }
        GroupNode groupNode2 = this;
        // MONITORENTER : groupNode2
        GroupNode groupNode = this.insertGroupNode(group, ruleIndex, edtModelToSwingNodeChangesQueue);
        // MONITOREXIT : groupNode2
        if (groupNode != null) return groupNode;
        GroupNode.$$$reportNull$$$0(6);
        return groupNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private GroupNode insertGroupNode(@NotNull UsageGroup group, int ruleIndex, @NotNull Consumer<? super UsageViewImpl.NodeChange> edtModelToSwingNodeChangesQueue) {
        if (group == null) {
            GroupNode.$$$reportNull$$$0(7);
        }
        if (edtModelToSwingNodeChangesQueue == null) {
            GroupNode.$$$reportNull$$$0(8);
        }
        GroupNode groupNode = this;
        // MONITORENTER : groupNode
        GroupNode newNode = new GroupNode(this, group, ruleIndex);
        int i2 = GroupNode.getNodeIndex(newNode, this.myChildren);
        if (i2 >= 0) {
            GroupNode groupNode2 = (GroupNode)this.myChildren.get(i2);
            // MONITOREXIT : groupNode
            if (groupNode2 != null) return groupNode2;
            GroupNode.$$$reportNull$$$0(9);
            return groupNode2;
        }
        int insertionIndex = -i2 - 1;
        this.myChildren.add(insertionIndex, newNode);
        edtModelToSwingNodeChangesQueue.consume((Object)new UsageViewImpl.NodeChange(UsageViewImpl.NodeChangeType.ADDED, this, newNode));
        GroupNode groupNode3 = newNode;
        // MONITOREXIT : groupNode
        if (groupNode3 != null) return groupNode3;
        GroupNode.$$$reportNull$$$0(10);
        return groupNode3;
    }

    private static int getNodeIndex(@NotNull Node newNode, @NotNull List<? extends Node> children2) {
        if (newNode == null) {
            GroupNode.$$$reportNull$$$0(11);
        }
        if (children2 == null) {
            GroupNode.$$$reportNull$$$0(12);
        }
        return Collections.binarySearch(children2, newNode, COMPARATOR);
    }

    private static int getNodeInsertionIndex(@NotNull Node node, @NotNull List<? extends Node> children2) {
        int i2;
        if (node == null) {
            GroupNode.$$$reportNull$$$0(13);
        }
        if (children2 == null) {
            GroupNode.$$$reportNull$$$0(14);
        }
        return (i2 = GroupNode.getNodeIndex(node, children2)) >= 0 ? i2 : -i2 - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTargetsNode(@NotNull Node node, @NotNull DefaultTreeModel treeModel) {
        int index;
        if (node == null) {
            GroupNode.$$$reportNull$$$0(15);
        }
        if (treeModel == null) {
            GroupNode.$$$reportNull$$$0(16);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        GroupNode groupNode = this;
        synchronized (groupNode) {
            index = GroupNode.getNodeInsertionIndex(node, this.getSwingChildren());
            this.myChildren.add(index, node);
        }
        treeModel.insertNodeInto(node, this, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllChildren() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        super.removeAllChildren();
        GroupNode groupNode = this;
        synchronized (groupNode) {
            this.myChildren.clear();
        }
        this.myRecursiveUsageCount = 0;
    }

    @Nullable
    private UsageNode tryMerge(@NotNull Usage usage) {
        if (usage == null) {
            GroupNode.$$$reportNull$$$0(17);
        }
        if (!(usage instanceof MergeableUsage)) {
            return null;
        }
        MergeableUsage mergeableUsage = (MergeableUsage)((Object)usage);
        for (UsageNode node : this.getUsageNodes()) {
            Usage original = node.getUsage();
            if (original == mergeableUsage) {
                return node;
            }
            if (!(original instanceof MergeableUsage) || !((MergeableUsage)((Object)original)).merge(mergeableUsage)) continue;
            return node;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int removeUsagesBulk(@NotNull Set<? extends UsageNode> usages, @NotNull DefaultTreeModel treeModel) {
        if (usages == null) {
            GroupNode.$$$reportNull$$$0(18);
        }
        if (treeModel == null) {
            GroupNode.$$$reportNull$$$0(19);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        int removed = 0;
        GroupNode groupNode = this;
        synchronized (groupNode) {
            SmartList removedNodes = new SmartList();
            for (UsageNode usageNode : usages) {
                if (!this.myChildren.remove(usageNode)) continue;
                removedNodes.add(usageNode);
                ++removed;
            }
            if (removed == 0) {
                for (GroupNode groupNode2 : this.getSubGroups()) {
                    int delta = groupNode2.removeUsagesBulk(usages, treeModel);
                    if (delta <= 0) continue;
                    if (groupNode2.getRecursiveUsageCount() == 0) {
                        this.myChildren.remove(groupNode2);
                        removedNodes.add(groupNode2);
                    }
                    if ((removed += delta) != usages.size()) continue;
                    break;
                }
            }
            if (!this.myChildren.isEmpty()) {
                GroupNode.removeNodesFromParent(treeModel, this, (List<? extends MutableTreeNode>)removedNodes);
            }
        }
        if (removed > 0) {
            this.myRecursiveUsageCount -= removed;
            if (this.myRecursiveUsageCount != 0) {
                treeModel.nodeChanged(this);
            }
        }
        return removed;
    }

    /*
     * WARNING - void declaration
     */
    private static void removeNodesFromParent(@NotNull DefaultTreeModel treeModel, @NotNull GroupNode parent, @NotNull List<? extends MutableTreeNode> nodes) {
        void var6_8;
        int count;
        if (treeModel == null) {
            GroupNode.$$$reportNull$$$0(20);
        }
        if (parent == null) {
            GroupNode.$$$reportNull$$$0(21);
        }
        if (nodes == null) {
            GroupNode.$$$reportNull$$$0(22);
        }
        if ((count = nodes.size()) == 0) {
            return;
        }
        Object2IntOpenHashMap ordering = new Object2IntOpenHashMap(count);
        ordering.defaultReturnValue(-1);
        for (MutableTreeNode mutableTreeNode : nodes) {
            ordering.put((Object)mutableTreeNode, parent.getIndex(mutableTreeNode));
        }
        nodes.sort(Comparator.comparingInt(arg_0 -> ((Object2IntMap)ordering).getInt(arg_0)));
        int[] indices = ordering.values().toIntArray();
        Arrays.sort(indices);
        int n = count - 1;
        while (var6_8 >= 0) {
            parent.remove(indices[var6_8]);
            --var6_8;
        }
        treeModel.nodesWereRemoved(parent, indices, nodes.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    UsageNode addOrGetUsage(@NotNull Usage usage, boolean filterDuplicateLines, @NotNull Consumer<? super UsageViewImpl.NodeChange> edtModelToSwingNodeChangesQueue) {
        UsageNode newNode;
        if (usage == null) {
            GroupNode.$$$reportNull$$$0(23);
        }
        if (edtModelToSwingNodeChangesQueue == null) {
            GroupNode.$$$reportNull$$$0(24);
        }
        GroupNode groupNode = this;
        synchronized (groupNode) {
            UsageNode mergedWith;
            if (filterDuplicateLines && (mergedWith = this.tryMerge(usage)) != null) {
                UsageNode usageNode = mergedWith;
                // MONITOREXIT @DISABLED, blocks:[2, 7] lbl9 : MonitorExitStatement: MONITOREXIT : var5_4
                if (usageNode == null) {
                    GroupNode.$$$reportNull$$$0(25);
                }
                return usageNode;
            }
            newNode = new UsageNode(this, usage);
            int i2 = GroupNode.getNodeIndex(newNode, this.myChildren);
            if (i2 >= 0) {
                newNode = (UsageNode)this.myChildren.get(i2);
            } else {
                int insertionIndex = -i2 - 1;
                this.myChildren.add(insertionIndex, newNode);
            }
        }
        edtModelToSwingNodeChangesQueue.consume((Object)new UsageViewImpl.NodeChange(UsageViewImpl.NodeChangeType.ADDED, this, newNode));
        UsageNode usageNode = newNode;
        if (usageNode == null) {
            GroupNode.$$$reportNull$$$0(26);
        }
        return usageNode;
    }

    void incrementUsageCount(int i2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        GroupNode groupNode = this;
        while (true) {
            groupNode.myRecursiveUsageCount += i2;
            TreeNode parent = groupNode.getParent();
            if (!(parent instanceof GroupNode)) {
                return;
            }
            groupNode = (GroupNode)parent;
        }
    }

    @Override
    protected boolean isDataValid() {
        UsageGroup group = this.getGroup();
        return group == null || group.isValid();
    }

    @Override
    protected boolean isDataReadOnly() {
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            TreeNode element = enumeration.nextElement();
            if (!(element instanceof Node) || !((Node)element).isReadOnly()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(@NotNull GroupNode groupNode) {
        if (groupNode == null) {
            GroupNode.$$$reportNull$$$0(27);
        }
        if (this.myRuleIndex == groupNode.myRuleIndex) {
            return this.getGroup().compareTo(groupNode.getGroup());
        }
        return Integer.compare(this.myRuleIndex, groupNode.myRuleIndex);
    }

    public synchronized UsageGroup getGroup() {
        return (UsageGroup)this.getUserObject();
    }

    int getRecursiveUsageCount() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myRecursiveUsageCount;
    }

    @Override
    public void navigate(boolean requestFocus) {
        if (this.getGroup() != null) {
            this.getGroup().navigate(requestFocus);
        }
    }

    @Override
    public boolean canNavigate() {
        return this.getGroup() != null && this.getGroup().canNavigate();
    }

    @Override
    public boolean canNavigateToSource() {
        return this.getGroup() != null && this.getGroup().canNavigateToSource();
    }

    @Override
    protected boolean isDataExcluded() {
        for (Node node : this.myChildren) {
            if (node.isExcluded()) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    protected String getNodeText() {
        String string = this.getGroup().getPresentableGroupText();
        if (string == null) {
            GroupNode.$$$reportNull$$$0(28);
        }
        return string;
    }

    @NotNull
    public synchronized Collection<GroupNode> getSubGroups() {
        ArrayList<GroupNode> list = new ArrayList<GroupNode>();
        for (Node n : this.myChildren) {
            if (!(n instanceof GroupNode)) continue;
            list.add((GroupNode)n);
        }
        ArrayList<GroupNode> arrayList = list;
        if (arrayList == null) {
            GroupNode.$$$reportNull$$$0(29);
        }
        return arrayList;
    }

    @NotNull
    public synchronized Collection<UsageNode> getUsageNodes() {
        ArrayList<UsageNode> list = new ArrayList<UsageNode>();
        for (Node n : this.myChildren) {
            if (!(n instanceof UsageNode)) continue;
            list.add((UsageNode)n);
        }
        ArrayList<UsageNode> arrayList = list;
        if (arrayList == null) {
            GroupNode.$$$reportNull$$$0(30);
        }
        return arrayList;
    }

    @Override
    @Nullable
    public UsageNodePresentation getCachedPresentation() {
        return (UsageNodePresentation)SoftReference.dereference(this.myCachedPresentation);
    }

    @Override
    protected void updateCachedPresentation() {
        UsageGroup group = this.getGroup();
        if (group == null || !group.isValid()) {
            return;
        }
        PsiElement element = group instanceof DataProvider ? (PsiElement)CommonDataKeys.PSI_ELEMENT.getData((DataProvider)group) : null;
        FileStatus fileStatus = group.getFileStatus();
        Color foregroundColor = fileStatus != null ? fileStatus.getColor() : null;
        Pair<Icon, ColoredText> tagIconAndText = TagManager.getTagIconAndText(element);
        Icon icon2 = IconUtil.rowIcon((Icon)((Icon)tagIconAndText.first), (Icon)group.getIcon());
        ArrayList<TextChunk> chunks = new ArrayList<TextChunk>();
        for (ColoredText.Fragment fragment : ((ColoredText)tagIconAndText.second).fragments()) {
            chunks.add(new TextChunk(fragment.fragmentAttributes().toTextAttributes(), fragment.fragmentText()));
        }
        TextAttributes attributes = SimpleTextAttributes.REGULAR_ATTRIBUTES.toTextAttributes();
        attributes.setForegroundColor(foregroundColor);
        chunks.add(new TextChunk(attributes, group.getPresentableGroupText()));
        UsageNodePresentation presentation = new UsageNodePresentation(icon2, chunks.toArray(TextChunk.EMPTY_ARRAY));
        this.myCachedPresentation = new SoftReference((Object)presentation);
    }

    @NotNull
    static Root createRoot() {
        return new Root();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/usages/impl/GroupNode";
                break;
            }
            case 5: 
            case 8: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edtModelToSwingNodeChangesQueue";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newNode";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 16: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeModel";
                break;
            }
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/usages/impl/GroupNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSwingChildren";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "addOrGetGroup";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "insertGroupNode";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "addOrGetUsage";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeText";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubGroups";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsageNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addOrGetGroup";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "insertGroupNode";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getNodeIndex";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getNodeInsertionIndex";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addTargetsNode";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "tryMerge";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeUsagesBulk";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "removeNodesFromParent";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addOrGetUsage";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class Root
    extends GroupNode {
        Root() {
        }

        @Override
        @NonNls
        public String toString() {
            return "Root " + super.toString();
        }

        @Override
        @NotNull
        protected String getNodeText() {
            return "";
        }
    }

    static class NodeComparator
    implements Comparator<DefaultMutableTreeNode> {
        NodeComparator() {
        }

        private static ClassIndex getClassIndex(@NotNull DefaultMutableTreeNode node) {
            if (node == null) {
                NodeComparator.$$$reportNull$$$0(0);
            }
            if (node instanceof UsageNode) {
                return ClassIndex.USAGE;
            }
            if (node instanceof GroupNode) {
                return ClassIndex.GROUP;
            }
            if (node instanceof UsageTargetNode) {
                return ClassIndex.USAGE_TARGET;
            }
            return ClassIndex.UNKNOWN;
        }

        @Override
        public int compare(DefaultMutableTreeNode n1, DefaultMutableTreeNode n2) {
            Object u2;
            int c;
            ClassIndex classIdx2;
            ClassIndex classIdx1 = NodeComparator.getClassIndex(n1);
            if (classIdx1 != (classIdx2 = NodeComparator.getClassIndex(n2))) {
                return classIdx1.compareTo(classIdx2);
            }
            if (classIdx1 == ClassIndex.GROUP ? (c = ((GroupNode)n1).compareTo((GroupNode)n2)) != 0 : classIdx1 == ClassIndex.USAGE && (c = ((UsageNode)n1).compareTo((UsageNode)n2)) != 0) {
                return c;
            }
            Object u1 = n1.getUserObject();
            if (Comparing.equal((Object)u1, (Object)(u2 = n2.getUserObject()))) {
                return 0;
            }
            return System.identityHashCode(u1) - System.identityHashCode(u2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/usages/impl/GroupNode$NodeComparator", "getClassIndex"));
        }

        static enum ClassIndex {
            UNKNOWN,
            USAGE_TARGET,
            GROUP,
            USAGE;

        }
    }
}

