/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.GroupNode;
import com.intellij.usages.impl.Node;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.impl.UsageTargetNode;
import com.intellij.util.ui.UIUtil;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UsageViewTreeModelBuilder
extends DefaultTreeModel {
    private final GroupNode.Root myRootNode;
    @Nullable
    private final TargetsRootNode myTargetsNode;
    private final UsageTarget[] myTargets;
    private UsageTargetNode[] myTargetNodes;

    public UsageViewTreeModelBuilder(@NotNull UsageViewPresentation presentation, UsageTarget @NotNull [] targets) {
        if (presentation == null) {
            UsageViewTreeModelBuilder.$$$reportNull$$$0(0);
        }
        if (targets == null) {
            UsageViewTreeModelBuilder.$$$reportNull$$$0(1);
        }
        super(GroupNode.createRoot());
        this.myRootNode = (GroupNode.Root)this.root;
        String targetsNodeText = presentation.getTargetsNodeText();
        this.myTargetsNode = targetsNodeText == null ? null : new TargetsRootNode(targetsNodeText);
        this.myTargets = targets;
        UIUtil.invokeLaterIfNeeded(() -> {
            this.addTargetNodes();
            this.setRoot(this.myRootNode);
        });
    }

    private void addTargetNodes() {
        if (this.myTargetsNode == null || this.myTargets.length == 0) {
            return;
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myTargetNodes = new UsageTargetNode[this.myTargets.length];
        this.myTargetsNode.removeAllChildren();
        for (int i2 = 0; i2 < this.myTargets.length; ++i2) {
            UsageTarget target = this.myTargets[i2];
            UsageTargetNode targetNode = new UsageTargetNode(target);
            this.myTargetsNode.add(targetNode);
            this.myTargetNodes[i2] = targetNode;
        }
        this.myRootNode.addTargetsNode(this.myTargetsNode, this);
        this.reload(this.myTargetsNode);
    }

    UsageNode getFirstUsageNode() {
        return (UsageNode)UsageViewTreeModelBuilder.getFirstChildOfType(this.myRootNode, UsageNode.class);
    }

    private static TreeNode getFirstChildOfType(@NotNull TreeNode parent, @NotNull Class<?> type) {
        if (parent == null) {
            UsageViewTreeModelBuilder.$$$reportNull$$$0(2);
        }
        if (type == null) {
            UsageViewTreeModelBuilder.$$$reportNull$$$0(3);
        }
        int childCount = parent.getChildCount();
        for (int idx = 0; idx < childCount; ++idx) {
            TreeNode child = parent.getChildAt(idx);
            if (type.isAssignableFrom(child.getClass())) {
                return child;
            }
            TreeNode firstChildOfType = UsageViewTreeModelBuilder.getFirstChildOfType(child, type);
            if (firstChildOfType == null) continue;
            return firstChildOfType;
        }
        return null;
    }

    boolean areTargetsValid() {
        if (this.myTargetNodes == null) {
            return true;
        }
        for (UsageTargetNode targetNode : this.myTargetNodes) {
            if (targetNode.isValid()) continue;
            return false;
        }
        return true;
    }

    void reset() {
        this.myRootNode.removeAllChildren();
        this.addTargetNodes();
        this.reload(this.myRootNode);
    }

    @Override
    @NotNull
    public Object getRoot() {
        GroupNode.Root root = this.myRootNode;
        if (root == null) {
            UsageViewTreeModelBuilder.$$$reportNull$$$0(4);
        }
        return root;
    }

    @Override
    public void nodeChanged(TreeNode node) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        super.nodeChanged(node);
    }

    @Override
    public void nodesWereInserted(TreeNode node, int[] childIndices) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        super.nodesWereInserted(node, childIndices);
    }

    @Override
    public void nodesWereRemoved(TreeNode node, int[] childIndices, Object[] removedChildren) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        super.nodesWereRemoved(node, childIndices, removedChildren);
    }

    @Override
    public void nodesChanged(TreeNode node, int[] childIndices) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        super.nodesChanged(node, childIndices);
    }

    @Override
    public void nodeStructureChanged(TreeNode node) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        super.nodeStructureChanged(node);
    }

    @Override
    protected void fireTreeNodesChanged(Object source, Object[] path2, int[] childIndices, Object[] children2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        super.fireTreeNodesChanged(source, path2, childIndices, children2);
    }

    @Override
    protected void fireTreeNodesInserted(Object source, Object[] path2, int[] childIndices, Object[] children2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        super.fireTreeNodesInserted(source, path2, childIndices, children2);
    }

    @Override
    protected void fireTreeNodesRemoved(Object source, Object[] path2, int[] childIndices, Object[] children2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        super.fireTreeNodesRemoved(source, path2, childIndices, children2);
    }

    @Override
    protected void fireTreeStructureChanged(Object source, Object[] path2, int[] childIndices, Object[] children2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        super.fireTreeStructureChanged(source, path2, childIndices, children2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/usages/impl/UsageViewTreeModelBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/usages/impl/UsageViewTreeModelBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFirstChildOfType";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class TargetsRootNode
    extends Node {
        private TargetsRootNode(@NotNull String name) {
            if (name == null) {
                TargetsRootNode.$$$reportNull$$$0(0);
            }
            this.setUserObject(name);
        }

        @Override
        protected boolean isDataValid() {
            return true;
        }

        @Override
        protected boolean isDataReadOnly() {
            return true;
        }

        @Override
        protected boolean isDataExcluded() {
            return false;
        }

        @Override
        @NotNull
        protected String getNodeText() {
            String string = this.getUserObject().toString();
            if (string == null) {
                TargetsRootNode.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/usages/impl/UsageViewTreeModelBuilder$TargetsRootNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/usages/impl/UsageViewTreeModelBuilder$TargetsRootNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodeText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

