/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.animation.components;

import com.intellij.ui.JBColor;
import com.intellij.util.animation.Easing;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J(\u0010\u0019\u001a\u00020\u001a2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001eH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0006\u0010$\u001a\u00020%J\u0010\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020(H\u0014J\u0010\u0010)\u001a\u00020#2\u0006\u0010\"\u001a\u00020\u000bH\u0002J\r\u0010*\u001a\u00020\u0003*\u00020\u000bH\u0082\u0002J\r\u0010+\u001a\u00020\u0003*\u00020\u000bH\u0082\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R+\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0012\u001a\u0004\b\u0016\u0010\u000e\"\u0004\b\u0017\u0010\u0010\u00a8\u0006,"}, d2={"Lcom/intellij/util/animation/components/BezierPainter;", "Ljavax/swing/JComponent;", "x1", "", "y1", "x2", "y2", "(DDDD)V", "controlSize", "", "<set-?>", "Ljava/awt/geom/Point2D;", "firstControlPoint", "getFirstControlPoint", "()Ljava/awt/geom/Point2D;", "setFirstControlPoint", "(Ljava/awt/geom/Point2D;)V", "firstControlPoint$delegate", "Lkotlin/properties/ReadWriteProperty;", "gridColor", "Lcom/intellij/ui/JBColor;", "secondControlPoint", "getSecondControlPoint", "setSecondControlPoint", "secondControlPoint$delegate", "fireEvents", "", "prop", "Lkotlin/reflect/KProperty;", "oldValue", "", "newValue", "fromScreenXY", "Ljava/awt/geom/Point2D$Double;", "point", "Ljava/awt/Point;", "getEasing", "Lcom/intellij/util/animation/Easing;", "paintComponent", "g", "Ljava/awt/Graphics;", "toScreenXY", "component1", "component2", "intellij.platform.ide"})
public final class BezierPainter
extends JComponent {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final int controlSize;
    private final JBColor gridColor = new JBColor(new Color(0xF0F0F0), new Color(0x313335));
    @NotNull
    private final ReadWriteProperty firstControlPoint$delegate;
    @NotNull
    private final ReadWriteProperty secondControlPoint$delegate;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(BezierPainter.class, "firstControlPoint", "getFirstControlPoint()Ljava/awt/geom/Point2D;", 0)), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(BezierPainter.class, "secondControlPoint", "getSecondControlPoint()Ljava/awt/geom/Point2D;", 0))};
    }

    @NotNull
    public final Point2D getFirstControlPoint() {
        return (Point2D)this.firstControlPoint$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    public final void setFirstControlPoint(@NotNull Point2D point2D) {
        Intrinsics.checkNotNullParameter((Object)point2D, (String)"<set-?>");
        this.firstControlPoint$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)point2D);
    }

    @NotNull
    public final Point2D getSecondControlPoint() {
        return (Point2D)this.secondControlPoint$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    public final void setSecondControlPoint(@NotNull Point2D point2D) {
        Intrinsics.checkNotNullParameter((Object)point2D, (String)"<set-?>");
        this.secondControlPoint$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)point2D);
    }

    private final void fireEvents(KProperty<?> prop, Object oldValue, Object newValue) {
        if (Intrinsics.areEqual((Object)oldValue, (Object)newValue) ^ true) {
            this.firePropertyChange(prop.getName(), oldValue, newValue);
            this.repaint();
        }
    }

    @NotNull
    public final Easing getEasing() {
        Easing easing = Easing.bezier(this.getFirstControlPoint().getX(), this.getFirstControlPoint().getY(), this.getSecondControlPoint().getX(), this.getSecondControlPoint().getY());
        Intrinsics.checkNotNullExpressionValue((Object)easing, (String)"Easing.bezier(firstContr\u2026.x, secondControlPoint.y)");
        return easing;
    }

    private final Point toScreenXY(Point2D point) {
        Rectangle rectangle = this.getVisibleRect();
        boolean bl = false;
        boolean bl2 = false;
        Rectangle b = rectangle;
        boolean bl3 = false;
        Insets insets = this.getInsets();
        int width = b.width - (insets.left + insets.right);
        int height = b.height - (insets.top + insets.bottom);
        return new Point((int)(point.getX() * (double)width + (double)insets.left + (double)b.x), height - (int)(point.getY() * (double)height) + insets.top + b.y);
    }

    private final Point2D.Double fromScreenXY(Point point) {
        Rectangle rectangle = this.getVisibleRect();
        boolean bl = false;
        boolean bl2 = false;
        Rectangle b = rectangle;
        boolean bl3 = false;
        Insets insets = this.getInsets();
        int left = insets.left + b.x;
        int top = insets.top + b.y;
        int width = b.width - (insets.left + insets.right);
        int height = b.height - (insets.top + insets.bottom);
        int n = -left;
        int n2 = point.x - left;
        int n3 = 0;
        n = Math.max(n, n2);
        n2 = b.width - left;
        n3 = 0;
        double x = (double)Math.min(n, n2) / (double)width;
        n3 = -top;
        int n4 = point.y - top;
        boolean bl4 = false;
        n3 = Math.max(n3, n4);
        n4 = b.height - top;
        bl4 = false;
        double y = (double)Math.min(n3, n4) / (double)height;
        return new Point2D.Double(x, 1.0 - y);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void paintComponent(@NotNull Graphics g) {
        void x3;
        void x2;
        void x1;
        void x0;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Rectangle bounds = this.getVisibleRect();
        Insets insets = this.getInsets();
        int x = bounds.x + insets.left;
        int y = bounds.y + insets.top;
        int width = bounds.width - (insets.left + insets.right);
        int height = bounds.height - (insets.top + insets.bottom);
        Graphics graphics = g.create();
        if (graphics == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.awt.Graphics2D");
        }
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2d.setColor(JBColor.background());
        g2d.fillRect(0, 0, bounds.width, bounds.height);
        g2d.setColor((Color)this.gridColor);
        int n = 0;
        int n2 = 4;
        while (n <= n2) {
            void i2;
            g2d.drawLine(x + width * i2 / 4, y, x + width * i2 / 4, y + height);
            g2d.drawLine(x, y + height * i2 / 4, x + width, y + height * i2 / 4);
            ++i2;
        }
        Point point = this.toScreenXY(new Point2D.Double(0.0, 0.0));
        double i2 = this.component1(point);
        double y0 = this.component2(point);
        Point point2 = this.toScreenXY(this.getFirstControlPoint());
        double d = this.component1(point2);
        double y1 = this.component2(point2);
        Point point3 = this.toScreenXY(this.getSecondControlPoint());
        double d2 = this.component1(point3);
        double y2 = this.component2(point3);
        Point point4 = this.toScreenXY(new Point2D.Double(1.0, 1.0));
        double d3 = this.component1(point4);
        double y3 = this.component2(point4);
        CubicCurve2D.Double bez = new CubicCurve2D.Double((double)x0, y0, (double)x1, y1, (double)x2, y2, (double)x3, y3);
        g2d.setColor(JBColor.foreground());
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.draw(bez);
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.setColor(this.isEnabled() ? new Color(151, 118, 169) : (JBColor.isBright() ? (Color)JBColor.LIGHT_GRAY : (Color)JBColor.GRAY));
        g2d.fillOval((int)x1 - this.controlSize / 2, (int)y1 - this.controlSize / 2, this.controlSize, this.controlSize);
        g2d.drawLine((int)x0, (int)y0, (int)x1, (int)y1);
        g2d.setColor(this.isEnabled() ? new Color(208, 167, 8) : (JBColor.isBright() ? (Color)JBColor.LIGHT_GRAY : (Color)JBColor.GRAY));
        g2d.fillOval((int)x2 - this.controlSize / 2, (int)y2 - this.controlSize / 2, this.controlSize, this.controlSize);
        g2d.drawLine((int)x2, (int)y2, (int)x3, (int)y3);
        g2d.dispose();
    }

    private final double component1(Point2D $this$component1) {
        Intrinsics.checkNotNullParameter((Object)$this$component1, (String)"$this$component1");
        return $this$component1.getX();
    }

    private final double component2(Point2D $this$component2) {
        Intrinsics.checkNotNullParameter((Object)$this$component2, (String)"$this$component2");
        return $this$component2.getY();
    }

    public BezierPainter(double x1, double y1, double x2, double y2) {
        Point2D.Double initialValue$iv;
        this.controlSize = 10;
        Delegates delegates = Delegates.INSTANCE;
        Point2D.Double double_ = new Point2D.Double(x1, y1);
        BezierPainter bezierPainter = this;
        boolean $i$f$observable = false;
        this.firstControlPoint$delegate = (ReadWriteProperty)new ObservableProperty<Point2D>((Object)initialValue$iv, (Object)initialValue$iv, bezierPainter){
            final /* synthetic */ Object $initialValue;
            final /* synthetic */ BezierPainter receiver$0$inlined;
            {
                this.$initialValue = $captured_local_variable$1;
                this.receiver$0$inlined = bezierPainter;
                super($super_call_param$2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                void p3;
                void p2;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                Object object = newValue;
                Object object2 = oldValue;
                KProperty p1 = property;
                boolean bl = false;
                BezierPainter.access$fireEvents(this.receiver$0$inlined, p1, p2, p3);
            }
        };
        Delegates this_$iv = Delegates.INSTANCE;
        initialValue$iv = new Point2D.Double(x2, y2);
        bezierPainter = this;
        $i$f$observable = false;
        this.secondControlPoint$delegate = (ReadWriteProperty)new ObservableProperty<Point2D>((Object)initialValue$iv, (Object)initialValue$iv, bezierPainter){
            final /* synthetic */ Object $initialValue;
            final /* synthetic */ BezierPainter receiver$0$inlined;
            {
                this.$initialValue = $captured_local_variable$1;
                this.receiver$0$inlined = bezierPainter;
                super($super_call_param$2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                void p3;
                void p2;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                Object object = newValue;
                Object object2 = oldValue;
                KProperty p1 = property;
                boolean bl = false;
                BezierPainter.access$fireEvents(this.receiver$0$inlined, p1, p2, p3);
            }
        };
        MouseAdapter value2 = new MouseAdapter(this){
            private int i;
            final /* synthetic */ BezierPainter this$0;

            public final int getI() {
                return this.i;
            }

            public final void setI(int n) {
                this.i = n;
            }

            public void mouseDragged(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Point point = e.getPoint();
                switch (this.i) {
                    case 1: {
                        Point point2 = point;
                        Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"point");
                        this.this$0.setFirstControlPoint(BezierPainter.access$fromScreenXY(this.this$0, point2));
                        break;
                    }
                    case 2: {
                        Point point3 = point;
                        Intrinsics.checkNotNullExpressionValue((Object)point3, (String)"point");
                        this.this$0.setSecondControlPoint(BezierPainter.access$fromScreenXY(this.this$0, point3));
                        break;
                    }
                }
                this.this$0.repaint();
            }

            public void mouseMoved(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Point point = e.getPoint();
                boolean bl = false;
                boolean bl2 = false;
                Point $this$with = point;
                boolean bl3 = false;
                Point point2 = $this$with;
                Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"this");
                int n = this.intersects(point2, this.this$0.getFirstControlPoint()) ? 1 : (this.i = this.intersects($this$with, this.this$0.getSecondControlPoint()) ? 2 : 0);
                if (this.i != 0) {
                    this.this$0.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    this.this$0.setCursor(Cursor.getDefaultCursor());
                }
            }

            private final boolean intersects(Point $this$intersects, Point2D point) {
                Point xy = BezierPainter.access$toScreenXY(this.this$0, point);
                return xy.x - BezierPainter.access$getControlSize$p(this.this$0) / 2 <= $this$intersects.x && $this$intersects.x <= xy.x + BezierPainter.access$getControlSize$p(this.this$0) / 2 && xy.y - BezierPainter.access$getControlSize$p(this.this$0) / 2 <= $this$intersects.y && $this$intersects.y <= xy.y + BezierPainter.access$getControlSize$p(this.this$0) / 2;
            }
            {
                this.this$0 = this$0;
            }
        };
        this.addMouseMotionListener(value2);
        this.addMouseListener(value2);
        this.setMinimumSize(new Dimension(300, 300));
    }

    public static final /* synthetic */ void access$fireEvents(BezierPainter $this, KProperty prop, Object oldValue, Object newValue) {
        $this.fireEvents(prop, oldValue, newValue);
    }

    public static final /* synthetic */ Point2D.Double access$fromScreenXY(BezierPainter $this, Point point) {
        return $this.fromScreenXY(point);
    }

    public static final /* synthetic */ Point access$toScreenXY(BezierPainter $this, Point2D point) {
        return $this.toScreenXY(point);
    }

    public static final /* synthetic */ int access$getControlSize$p(BezierPainter $this) {
        return $this.controlSize;
    }
}

