/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.BitSet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class IdFilter {
    private static final Logger LOG = Logger.getInstance(IdFilter.class);
    private static final Key<CachedValue<IdFilter>> INSIDE_PROJECT = Key.create((String)"INSIDE_PROJECT");
    private static final Key<CachedValue<IdFilter>> OUTSIDE_PROJECT = Key.create((String)"OUTSIDE_PROJECT");

    @NotNull
    public static IdFilter getProjectIdFilter(@NotNull Project project, boolean includeNonProjectItems) {
        if (project == null) {
            IdFilter.$$$reportNull$$$0(0);
        }
        Key<CachedValue<IdFilter>> key = includeNonProjectItems ? OUTSIDE_PROJECT : INSIDE_PROJECT;
        CachedValueProvider provider = () -> CachedValueProvider.Result.create(IdFilter.buildProjectIdFilter(project, includeNonProjectItems), ProjectRootManager.getInstance(project), VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS);
        IdFilter idFilter = CachedValuesManager.getManager(project).getCachedValue((UserDataHolder)project, key, provider, false);
        if (idFilter == null) {
            IdFilter.$$$reportNull$$$0(1);
        }
        return idFilter;
    }

    @NotNull
    private static IdFilter buildProjectIdFilter(@NotNull Project project, final boolean includeNonProjectItems) {
        if (project == null) {
            IdFilter.$$$reportNull$$$0(2);
        }
        long started = System.currentTimeMillis();
        final BitSet idSet = new BitSet();
        ContentIterator iterator = fileOrDir -> {
            idSet.set(((VirtualFileWithId)((Object)fileOrDir)).getId());
            ProgressManager.checkCanceled();
            return true;
        };
        if (includeNonProjectItems) {
            FileBasedIndex.getInstance().iterateIndexableFiles(iterator, project, ProgressIndicatorProvider.getGlobalProgressIndicator());
        } else {
            ProjectRootManager.getInstance(project).getFileIndex().iterateContent(iterator);
        }
        if (LOG.isDebugEnabled()) {
            long elapsed = System.currentTimeMillis() - started;
            LOG.debug("Done filter (includeNonProjectItems=" + includeNonProjectItems + ") in " + elapsed + "ms. Total files in set: " + idSet.cardinality());
        }
        return new IdFilter(){

            @Override
            public boolean containsFileId(int id) {
                return id >= 0 && idSet.get(id);
            }

            @Override
            @NotNull
            public FilterScopeType getFilteringScopeType() {
                FilterScopeType filterScopeType = includeNonProjectItems ? FilterScopeType.PROJECT_AND_LIBRARIES : FilterScopeType.PROJECT;
                if (filterScopeType == null) {
                    1.$$$reportNull$$$0(0);
                }
                return filterScopeType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/IdFilter$1", "getFilteringScopeType"));
            }
        };
    }

    public abstract boolean containsFileId(int var1);

    @ApiStatus.Internal
    @NotNull
    public FilterScopeType getFilteringScopeType() {
        FilterScopeType filterScopeType = FilterScopeType.OTHER;
        if (filterScopeType == null) {
            IdFilter.$$$reportNull$$$0(3);
        }
        return filterScopeType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/IdFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/IdFilter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectIdFilter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteringScopeType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProjectIdFilter";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildProjectIdFilter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum FilterScopeType {
        OTHER{

            @Override
            @NonNls
            @NotNull
            public String getId() {
                throw new UnsupportedOperationException();
            }
        }
        ,
        PROJECT{

            @Override
            @NonNls
            @NotNull
            public String getId() {
                return "false";
            }
        }
        ,
        PROJECT_AND_LIBRARIES{

            @Override
            @NonNls
            @NotNull
            public String getId() {
                return "true";
            }
        };


        @NonNls
        @NotNull
        public abstract String getId();
    }
}

