/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public final class MessageListenerList<T> {
    private final MessageBus myMessageBus;
    private final Topic<T> myTopic;
    private final Map<T, SimpleMessageBusConnection> myListenerToConnectionMap;

    public MessageListenerList(@NotNull MessageBus messageBus, @NotNull Topic<T> topic) {
        if (messageBus == null) {
            MessageListenerList.$$$reportNull$$$0(0);
        }
        if (topic == null) {
            MessageListenerList.$$$reportNull$$$0(1);
        }
        this.myListenerToConnectionMap = new ConcurrentHashMap<T, SimpleMessageBusConnection>();
        this.myTopic = topic;
        this.myMessageBus = messageBus;
    }

    public void add(@NotNull T listener) {
        if (listener == null) {
            MessageListenerList.$$$reportNull$$$0(2);
        }
        SimpleMessageBusConnection connection = this.myMessageBus.simpleConnect();
        connection.subscribe(this.myTopic, listener);
        this.myListenerToConnectionMap.put(listener, connection);
    }

    public void add(final @NotNull T listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            MessageListenerList.$$$reportNull$$$0(3);
        }
        if (parentDisposable == null) {
            MessageListenerList.$$$reportNull$$$0(4);
        }
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                MessageListenerList.this.myListenerToConnectionMap.remove(listener);
            }
        });
        MessageBusConnection connection = this.myMessageBus.connect(parentDisposable);
        connection.subscribe(this.myTopic, listener);
        this.myListenerToConnectionMap.put(listener, (SimpleMessageBusConnection)connection);
    }

    public void remove(@NotNull T listener) {
        SimpleMessageBusConnection connection;
        if (listener == null) {
            MessageListenerList.$$$reportNull$$$0(5);
        }
        if ((connection = this.myListenerToConnectionMap.remove(listener)) != null) {
            connection.disconnect();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topic";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/messages/impl/MessageListenerList";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "add";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "remove";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

