/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.toolwindow;

import com.google.gson.Gson;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.toolwindow.StatisticsEventLogToolWindow;
import com.intellij.util.text.DateFormatUtil;
import com.jetbrains.fus.reporting.model.lion3.LogEvent;
import com.jetbrains.fus.reporting.model.lion3.LogEventAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\r\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0001\u0018\u00010\tJ2\u0010\n\u001a\u00020\u00042\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\t2\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0001\u0018\u00010\tH\u0002J\u001a\u0010\f\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J&\u0010\u000f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0010\u001a\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u00012\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0002J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J\"\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00012\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/internal/statistic/toolwindow/StatisticsEventLogMessageBuilder;", "", "()V", "buildLogMessage", "", "logEvent", "Lcom/jetbrains/fus/reporting/model/lion3/LogEvent;", "rawEventId", "rawData", "", "eventDataToString", "eventData", "formatValue", "rawValue", "validatedValue", "prepareValue", "key", "value", "shortenProjectId", "projectId", "valueToString", "Companion", "intellij.platform.statistics.devkit"})
public final class StatisticsEventLogMessageBuilder {
    private static final Gson gson;
    private static final Set<String> systemFields;
    private static final int projectIdPrefixSize = 8;
    private static final int projectIdSuffixSize = 2;
    private static final int maxProjectIdSize = 10;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final String buildLogMessage(@NotNull LogEvent logEvent, @Nullable String rawEventId, @Nullable Map<String, ? extends Object> rawData) {
        Intrinsics.checkNotNullParameter((Object)logEvent, (String)"logEvent");
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl5 = false;
        $this$buildString.append(DateFormatUtil.formatTimeWithSeconds((long)logEvent.getTime()));
        LogEventAction event = logEvent.getEvent();
        String groupId = logEvent.getGroup().getId();
        String eventId = this.formatValue(rawEventId, logEvent.getEvent().getId());
        $this$buildString.append(" - [\"" + groupId + "\", v" + logEvent.getGroup().getVersion() + "]: \"" + eventId + "\" ");
        int count = event.getCount();
        if (!event.getState() && count > 1) {
            $this$buildString.append("(count=" + count + ") ");
        }
        $this$buildString.append("{");
        $this$buildString.append(this.eventDataToString(event.getData(), rawData));
        $this$buildString.append("}");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String formatValue(String rawValue, String validatedValue) {
        String string;
        if (rawValue != null) {
            boolean bl;
            block5: {
                Iterable $this$any$iv = StatisticsEventLogToolWindow.Companion.getRejectedValidationTypes();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ValidationResultType it = (ValidationResultType)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getDescription(), (Object)validatedValue)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) {
                string = validatedValue + '[' + rawValue + ']';
                return string;
            }
        }
        string = validatedValue;
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String eventDataToString(Map<String, ? extends Object> eventData, Map<String, ? extends Object> rawData) {
        void $this$mapTo$iv$iv;
        String key;
        boolean bl;
        Map.Entry entry;
        Map.Entry $dstr$key$_u24__u24;
        Map $this$filterTo$iv$iv;
        Map<String, ? extends Object> $this$filter$iv = eventData;
        boolean $i$f$filter = false;
        Map<String, ? extends Object> map2 = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        void var8_8 = $this$filterTo$iv$iv;
        boolean bl2 = false;
        Iterator iterator = var8_8.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            $dstr$key$_u24__u24 = element$iv$iv = iterator.next();
            boolean bl3 = false;
            entry = $dstr$key$_u24__u24;
            bl = false;
            key = (String)entry.getKey();
            if (!(!systemFields.contains(key))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        var8_8 = $this$mapTo$iv$iv;
        bl2 = false;
        for (Map.Entry item$iv$iv : var8_8.entrySet()) {
            void $dstr$key$value;
            $dstr$key$_u24__u24 = item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl4 = false;
            entry = $dstr$key$value;
            bl = false;
            key = (String)entry.getKey();
            entry = $dstr$key$value;
            bl = false;
            Object value = entry.getValue();
            Map<String, ? extends Object> map3 = rawData;
            String string = '\"' + key + "\":" + this.valueToString(key, value, map3 != null ? map3.get(key) : null);
            object.add(string);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
    }

    private final String valueToString(String key, Object value, Object rawValue) {
        String string = gson.toJson(this.prepareValue(key, value, rawValue));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gson.toJson(prepareValue(key, value, rawValue))");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final Object prepareValue(String key, Object value, Object rawValue) {
        Object object;
        Object object2 = value;
        if (object2 instanceof Map) {
            void $this$associateTo$iv$iv;
            Iterable $this$associate$iv = ((Map)value).entrySet();
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Object v5;
                Map map2 = destination$iv$iv;
                Map.Entry it = (Map.Entry)element$iv$iv;
                boolean bl3 = false;
                Object object3 = rawValue;
                if (!(object3 instanceof Map)) {
                    object3 = null;
                }
                Map rawValuesMap = (Map)object3;
                Object k = it.getKey();
                Object k2 = it.getKey();
                if (k2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                String string = (String)k2;
                Object v = it.getValue();
                if (rawValuesMap != null) {
                    Map map3;
                    Object k3 = it.getKey();
                    boolean bl2 = false;
                    v5 = map3.get(k3);
                } else {
                    v5 = null;
                }
                Pair pair = TuplesKt.to(k, (Object)this.prepareValue(string, v, v5));
                bl3 = false;
                map2.put(pair.getFirst(), pair.getSecond());
            }
            object = destination$iv$iv;
        } else if (object2 instanceof List) {
            void $this$mapIndexedTo$iv$iv;
            Iterable $this$mapIndexed$iv = (Iterable)value;
            boolean $i$f$mapIndexed = false;
            Iterable capacity$iv = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void index;
                void element;
                List rawValuesList;
                int n = index$iv$iv++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object bl3 = item$iv$iv;
                int rawValuesMap = n;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                Object object4 = rawValue;
                if (!(object4 instanceof List)) {
                    object4 = null;
                }
                List list = rawValuesList = (List)object4;
                Object object5 = this.prepareValue(key, element, list != null ? list.get((int)index) : null);
                collection.add(object5);
            }
            object = (List)destination$iv$iv;
        } else if (object2 instanceof String) {
            Object object6 = rawValue;
            object = this.formatValue(object6 != null ? object6.toString() : null, Intrinsics.areEqual((Object)key, (Object)"project") ? this.shortenProjectId(value.toString()) : (String)value);
        } else {
            object = value;
        }
        return object;
    }

    private final String shortenProjectId(String projectId) {
        boolean isRejected;
        int length;
        block7: {
            boolean bl;
            length = projectId.length();
            Iterable $this$any$iv = StatisticsEventLogToolWindow.Companion.getRejectedValidationTypes();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ValidationResultType it = (ValidationResultType)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getDescription(), (Object)projectId)) continue;
                    bl = true;
                    break block7;
                }
                bl = isRejected = false;
            }
        }
        if (!isRejected) {
            CharSequence charSequence = projectId;
            int n = 0;
            if (!StringsKt.isBlank((CharSequence)charSequence) && length > 10) {
                StringBuilder stringBuilder = new StringBuilder();
                charSequence = projectId;
                n = 0;
                int n2 = 8;
                boolean bl = false;
                CharSequence charSequence2 = charSequence;
                if (charSequence2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string = ((String)charSequence2).substring(n, n2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                StringBuilder stringBuilder2 = stringBuilder.append(string).append("...");
                charSequence = projectId;
                n = length - 2;
                n2 = 0;
                CharSequence charSequence3 = charSequence;
                if (charSequence3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string2 = ((String)charSequence3).substring(n, length);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                return stringBuilder2.append(string2).toString();
            }
        }
        return projectId;
    }

    static {
        Companion = new Companion(null);
        gson = new Gson();
        systemFields = SetsKt.setOf((Object[])new String[]{"last", "created", "system_event_id", "system_headless"});
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/internal/statistic/toolwindow/StatisticsEventLogMessageBuilder$Companion;", "", "()V", "gson", "Lcom/google/gson/Gson;", "maxProjectIdSize", "", "projectIdPrefixSize", "projectIdSuffixSize", "systemFields", "", "", "intellij.platform.statistics.devkit"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

