/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.project;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.project.TestProjectManager;
import com.intellij.testFramework.LeakHunter;
import com.intellij.testFramework.TestApplicationManagerKt;
import com.intellij.util.PairProcessor;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"CHECK_START", "", "LEAK_CHECK_INTERVAL", "LOG_PROJECT_LEAKAGE", "", "MAX_LEAKY_PROJECTS", "", "totalCreatedProjectsCount", "getTotalCreatedProjectsCount", "()I", "setTotalCreatedProjectsCount", "(I)V", "reportLeakedProjects", "", "leakedProjects", "", "Lcom/intellij/openapi/project/Project;", "intellij.platform.testFramework"})
public final class TestProjectManagerKt {
    private static final int MAX_LEAKY_PROJECTS = 5;
    private static final long LEAK_CHECK_INTERVAL = TimeUnit.MINUTES.toMillis(30L);
    private static long CHECK_START = System.currentTimeMillis();
    private static final boolean LOG_PROJECT_LEAKAGE;
    private static int totalCreatedProjectsCount;

    public static final int getTotalCreatedProjectsCount() {
        return totalCreatedProjectsCount;
    }

    public static final void setTotalCreatedProjectsCount(int n) {
        totalCreatedProjectsCount = n;
    }

    private static final void reportLeakedProjects(Iterable<? extends Project> leakedProjects) {
        HashSet<Integer> hashCodes = new HashSet<Integer>();
        for (Project project2 : leakedProjects) {
            hashCodes.add(System.identityHashCode(project2));
        }
        String string = TestApplicationManagerKt.publishHeapDump("leakedProjects");
        StringBuilder leakers = new StringBuilder();
        leakers.append("Too many projects leaked (hashCodes=" + hashCodes + "): \n");
        LeakHunter.processLeaks(LeakHunter.allRoots(), ProjectImpl.class, new Predicate(hashCodes){
            final /* synthetic */ HashSet $hashCodes;

            public final boolean test(ProjectImpl it) {
                return this.$hashCodes.contains(System.identityHashCode(it));
            }
            {
                this.$hashCodes = hashSet;
            }
        }, (PairProcessor)new PairProcessor(leakers, hashCodes){
            final /* synthetic */ StringBuilder $leakers;
            final /* synthetic */ HashSet $hashCodes;

            public final boolean process(@Nullable ProjectImpl leaked, @Nullable Object backLink) {
                int hashCode = System.identityHashCode(leaked);
                StringBuilder stringBuilder = this.$leakers.append("Leaked project found:").append(leaked).append(", hash=").append(hashCode).append(", place=");
                ProjectImpl projectImpl = leaked;
                Intrinsics.checkNotNull((Object)projectImpl);
                stringBuilder.append(TestProjectManager.Companion.getCreationPlace((Project)projectImpl)).append('\n').append(backLink).append('\n').append("-----\n");
                this.$hashCodes.remove(hashCode);
                return !this.$hashCodes.isEmpty();
            }
            {
                this.$leakers = stringBuilder;
                this.$hashCodes = hashSet;
            }
        });
        leakers.append("\nPlease see `").append(string).append("` for a memory dump");
        throw (Throwable)((Object)new AssertionError((Object)leakers.toString()));
    }

    static {
        String string = System.getProperty("idea.log.leaked.projects.in.tests", "true");
        Intrinsics.checkNotNull((Object)string);
        String string2 = string;
        boolean bl = false;
        LOG_PROJECT_LEAKAGE = Boolean.parseBoolean(string2);
    }

    public static final /* synthetic */ boolean access$getLOG_PROJECT_LEAKAGE$p() {
        return LOG_PROJECT_LEAKAGE;
    }

    public static final /* synthetic */ long access$getLEAK_CHECK_INTERVAL$p() {
        return LEAK_CHECK_INTERVAL;
    }

    public static final /* synthetic */ long access$getCHECK_START$p() {
        return CHECK_START;
    }

    public static final /* synthetic */ void access$setCHECK_START$p(long l) {
        CHECK_START = l;
    }

    public static final /* synthetic */ void access$reportLeakedProjects(Iterable leakedProjects) {
        TestProjectManagerKt.reportLeakedProjects(leakedProjects);
    }
}

