/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.psi.impl;

import com.intellij.debugger.streams.psi.ChainDetector;
import com.intellij.debugger.streams.psi.ChainTransformer;
import com.intellij.debugger.streams.psi.PsiUtil;
import com.intellij.debugger.streams.wrapper.StreamChain;
import com.intellij.debugger.streams.wrapper.StreamChainBuilder;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifiableCodeBlock;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaStreamChainBuilder
implements StreamChainBuilder {
    private final ChainTransformer.Java myChainTransformer;
    private final ChainDetector myDetector;

    public JavaStreamChainBuilder(@NotNull ChainTransformer.Java transformer, @NotNull ChainDetector detector) {
        if (transformer == null) {
            JavaStreamChainBuilder.$$$reportNull$$$0(0);
        }
        if (detector == null) {
            JavaStreamChainBuilder.$$$reportNull$$$0(1);
        }
        this.myChainTransformer = transformer;
        this.myDetector = detector;
    }

    @Override
    public boolean isChainExists(@NotNull PsiElement startElement) {
        if (startElement == null) {
            JavaStreamChainBuilder.$$$reportNull$$$0(2);
        }
        PsiElement current = JavaStreamChainBuilder.getLatestElementInCurrentScope(PsiUtil.ignoreWhiteSpaces(startElement));
        MyStreamChainExistenceChecker existenceChecker = new MyStreamChainExistenceChecker();
        while (current != null) {
            current.accept((PsiElementVisitor)existenceChecker);
            if (existenceChecker.found()) {
                return true;
            }
            current = JavaStreamChainBuilder.toUpperLevel(current);
        }
        return false;
    }

    @Override
    @NotNull
    public List<StreamChain> build(@NotNull PsiElement startElement) {
        if (startElement == null) {
            JavaStreamChainBuilder.$$$reportNull$$$0(3);
        }
        MyChainCollectorVisitor visitor2 = new MyChainCollectorVisitor();
        PsiElement current = JavaStreamChainBuilder.getLatestElementInCurrentScope(PsiUtil.ignoreWhiteSpaces(startElement));
        while (current != null) {
            current.accept((PsiElementVisitor)visitor2);
            current = JavaStreamChainBuilder.toUpperLevel(current);
        }
        List<List<PsiMethodCallExpression>> chains = visitor2.getPsiChains();
        return this.buildChains(chains, startElement);
    }

    @Nullable
    private static PsiElement toUpperLevel(@NotNull PsiElement element) {
        if (element == null) {
            JavaStreamChainBuilder.$$$reportNull$$$0(4);
        }
        for (element = element.getParent(); element != null && !(element instanceof PsiLambdaExpression) && !(element instanceof PsiAnonymousClass); element = element.getParent()) {
        }
        return JavaStreamChainBuilder.getLatestElementInCurrentScope(element);
    }

    @Nullable
    @Contract(value="null -> null")
    private static PsiElement getLatestElementInCurrentScope(@Nullable PsiElement element) {
        PsiElement parent;
        PsiElement current = element;
        while (!(current == null || (parent = current.getParent()) instanceof PsiModifiableCodeBlock || parent instanceof PsiLambdaExpression || parent instanceof PsiStatement)) {
            current = parent;
        }
        return current;
    }

    @NotNull
    private List<StreamChain> buildChains(@NotNull List<List<PsiMethodCallExpression>> chains, @NotNull PsiElement context) {
        if (chains == null) {
            JavaStreamChainBuilder.$$$reportNull$$$0(5);
        }
        if (context == null) {
            JavaStreamChainBuilder.$$$reportNull$$$0(6);
        }
        List list2 = ContainerUtil.map(chains, x -> this.myChainTransformer.transform(x, context));
        if (list2 == null) {
            JavaStreamChainBuilder.$$$reportNull$$$0(7);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detector";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chains";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/streams/psi/impl/JavaStreamChainBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/streams/psi/impl/JavaStreamChainBuilder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildChains";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isChainExists";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toUpperLevel";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildChains";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyVisitorBase
    extends JavaRecursiveElementVisitor {
        private MyVisitorBase() {
        }

        public void visitCodeBlock(PsiCodeBlock block) {
        }

        public void visitLambdaExpression(PsiLambdaExpression expression) {
        }
    }

    private class MyChainCollectorVisitor
    extends MyVisitorBase {
        private final Set<PsiMethodCallExpression> myTerminationCalls = new HashSet<PsiMethodCallExpression>();
        private final Map<PsiMethodCallExpression, PsiMethodCallExpression> myPreviousCalls = new HashMap<PsiMethodCallExpression, PsiMethodCallExpression>();

        private MyChainCollectorVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            if (!this.myPreviousCalls.containsKey(expression) && JavaStreamChainBuilder.this.myDetector.isStreamCall(expression)) {
                this.updateCallTree(expression);
            }
        }

        private void updateCallTree(@NotNull PsiMethodCallExpression expression) {
            PsiElement parent;
            if (expression == null) {
                MyChainCollectorVisitor.$$$reportNull$$$0(0);
            }
            if (JavaStreamChainBuilder.this.myDetector.isTerminationCall(expression)) {
                this.myTerminationCalls.add(expression);
            }
            if (!((parent = expression.getParent()) instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement parentCall = parent.getParent();
            if (parentCall instanceof PsiMethodCallExpression && JavaStreamChainBuilder.this.myDetector.isStreamCall((PsiMethodCallExpression)parentCall)) {
                PsiMethodCallExpression parentCallExpression = (PsiMethodCallExpression)parentCall;
                this.myPreviousCalls.put(parentCallExpression, expression);
                this.updateCallTree(parentCallExpression);
            }
        }

        @NotNull
        List<List<PsiMethodCallExpression>> getPsiChains() {
            ArrayList<List<PsiMethodCallExpression>> chains = new ArrayList<List<PsiMethodCallExpression>>();
            for (PsiMethodCallExpression terminationCall : this.myTerminationCalls) {
                ArrayList<PsiMethodCallExpression> chain = new ArrayList<PsiMethodCallExpression>();
                PsiMethodCallExpression current = terminationCall;
                while (current != null && (JavaStreamChainBuilder.this.myDetector.isIntermediateCall(current) || JavaStreamChainBuilder.this.myDetector.isTerminationCall(current))) {
                    chain.add(current);
                    current = this.myPreviousCalls.get(current);
                }
                Collections.reverse(chain);
                chains.add(chain);
            }
            ArrayList<List<PsiMethodCallExpression>> arrayList = chains;
            if (arrayList == null) {
                MyChainCollectorVisitor.$$$reportNull$$$0(1);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/streams/psi/impl/JavaStreamChainBuilder$MyChainCollectorVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/streams/psi/impl/JavaStreamChainBuilder$MyChainCollectorVisitor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPsiChains";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "updateCallTree";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyStreamChainExistenceChecker
    extends MyVisitorBase {
        private boolean myFound = false;

        private MyStreamChainExistenceChecker() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            if (this.myFound) {
                return;
            }
            super.visitMethodCallExpression(expression);
            if (!this.myFound && JavaStreamChainBuilder.this.myDetector.isTerminationCall(expression)) {
                this.myFound = true;
            }
        }

        boolean found() {
            return this.myFound;
        }
    }
}

