/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.problemsView.toolWindow;

import com.intellij.analysis.problemsView.toolWindow.Node;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewBundle;
import com.intellij.analysis.problemsView.toolWindow.Root;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.impl.CompoundIconProvider;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.tree.LeafState;
import java.util.Collection;
import java.util.Objects;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0002J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\f0\u0015\u00a2\u0006\u0002\b\u0016\u00a2\u0006\u0002\b\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0004H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006!"}, d2={"Lcom/intellij/analysis/problemsView/toolWindow/FileNode;", "Lcom/intellij/analysis/problemsView/toolWindow/Node;", "parent", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/analysis/problemsView/toolWindow/Node;Lcom/intellij/openapi/vfs/VirtualFile;)V", "descriptor", "Lcom/intellij/openapi/fileEditor/OpenFileDescriptor;", "getDescriptor", "()Lcom/intellij/openapi/fileEditor/OpenFileDescriptor;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "equals", "", "other", "", "getChildren", "", "getLeafState", "Lcom/intellij/ui/tree/LeafState;", "getName", "", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsSafe;", "getVirtualFile", "hashCode", "", "update", "", "project", "Lcom/intellij/openapi/project/Project;", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "intellij.platform.lang.impl"})
public final class FileNode
extends Node {
    @NotNull
    private final VirtualFile file;

    @Override
    @Nullable
    public OpenFileDescriptor getDescriptor() {
        OpenFileDescriptor openFileDescriptor;
        Project project = this.getProject();
        if (project != null) {
            Project project2 = project;
            boolean bl = false;
            boolean bl2 = false;
            Project it = project2;
            boolean bl3 = false;
            openFileDescriptor = new OpenFileDescriptor(it, this.file);
        } else {
            openFileDescriptor = null;
        }
        return openFileDescriptor;
    }

    @NotNull
    public LeafState getLeafState() {
        return this.getParentDescriptor() instanceof Root ? LeafState.NEVER : LeafState.DEFAULT;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.file.getPresentableName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.presentableName");
        return string;
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        return this.file;
    }

    @Override
    protected void update(@NotNull Project project, @NotNull PresentationData presentation2) {
        int count;
        Root root2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
        presentation2.addText(this.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        Icon icon2 = CompoundIconProvider.findIcon((PsiElement)PsiUtilCore.findFileSystemItem((Project)project, (VirtualFile)this.file), 0);
        if (icon2 == null) {
            boolean bl = this.file.isDirectory();
            icon2 = bl ? AllIcons.Nodes.Folder : AllIcons.FileTypes.Any_type;
        }
        presentation2.setIcon(icon2);
        if (!(this.getParentDescriptor() instanceof FileNode)) {
            Object object = this.file.getParent();
            if (object == null || (object = object.getPresentableUrl()) == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"file.parent?.presentableUrl ?: return");
            Object url = object;
            presentation2.addText("  " + FileUtil.getLocationRelativeToUserHome((String)url), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
        Root root3 = root2 = this.findAncestor(Root.class);
        int n = count = root3 != null ? root3.getFileProblemCount(this.file) : 0;
        if (count > 0) {
            String string = ProblemsViewBundle.message("problems.view.file.problems", count);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ProblemsViewBundle.messa\u2026ew.file.problems\", count)");
            String text2 = string;
            presentation2.addText("  " + text2, SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
    }

    @Override
    @NotNull
    public Collection<Node> getChildren() {
        Root root2 = this.findAncestor(Root.class);
        Object object = root2;
        if (object == null || (object = ((Root)object).getChildren(this.file)) == null) {
            object = super.getChildren();
        }
        return object;
    }

    public int hashCode() {
        return Objects.hash(this.getProject(), this.file);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(((Object)((Object)this)).getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (!(object2 instanceof FileNode)) {
            object2 = null;
        }
        FileNode fileNode = (FileNode)((Object)object2);
        if (fileNode == null) {
            return false;
        }
        FileNode that = fileNode;
        return Intrinsics.areEqual((Object)that.getProject(), (Object)this.getProject()) && Intrinsics.areEqual((Object)that.file, (Object)this.file);
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    public FileNode(@NotNull Node parent, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)((Object)parent), (String)"parent");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        super(parent);
        this.file = file2;
    }
}

