/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ExperimentalFeature;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.BooleanTableCellEditor;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExperimentsDialog
extends DialogWrapper {
    ExperimentsDialog(@Nullable Project project) {
        super(project);
        this.init();
        this.setTitle(IdeBundle.message((String)"dialog.title.experimental.features", (Object[])new Object[0]));
    }

    @NotNull
    protected JComponent createCenterPanel() {
        ExperimentalFeature[] features = (ExperimentalFeature[])Experiments.EP_NAME.getExtensions();
        JBTable table = new JBTable(ExperimentsDialog.createModel(features));
        table.setShowGrid(false);
        table.getEmptyText().setText(IdeBundle.message((String)"empty.text.no.features.available", (Object[])new Object[0]));
        table.getColumnModel().getColumn(0).setCellRenderer(ExperimentsDialog.getIdRenderer());
        table.getColumnModel().getColumn(1).setCellRenderer(ExperimentsDialog.getValueRenderer());
        table.getColumnModel().getColumn(1).setCellEditor((TableCellEditor)new BooleanTableCellEditor());
        table.getSelectionModel().setSelectionMode(0);
        JTextArea myDescription = new JTextArea(4, 50);
        myDescription.setMargin((Insets)JBUI.insets((int)2));
        myDescription.setWrapStyleWord(true);
        myDescription.setLineWrap(true);
        myDescription.setEditable(false);
        table.getSelectionModel().addListSelectionListener(e -> myDescription.setText(features[table.getSelectedRow()].description));
        JScrollPane label2 = ScrollPaneFactory.createScrollPane((Component)myDescription);
        BorderLayoutPanel descriptionPanel = (BorderLayoutPanel)JBUI.Panels.simplePanel((Component)label2).withBorder((Border)IdeBorderFactory.createTitledBorder((String)IdeBundle.message((String)"border.title.description", (Object[])new Object[0]), (boolean)false));
        BorderLayoutPanel borderLayoutPanel = JBUI.Panels.simplePanel((Component)ScrollPaneFactory.createScrollPane((Component)table)).addToBottom((Component)descriptionPanel);
        if (borderLayoutPanel == null) {
            ExperimentsDialog.$$$reportNull$$$0(0);
        }
        return borderLayoutPanel;
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return "ExperimentsDialog";
    }

    private static TableCellRenderer getValueRenderer() {
        return new BooleanTableCellRenderer(0);
    }

    private static TableCellRenderer getIdRenderer() {
        return new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(@NotNull JTable table, @Nullable Object value2, boolean selected2, boolean hasFocus, int row2, int column2) {
                if (table == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.append(String.valueOf(value2));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/application/ExperimentsDialog$1", "customizeCellRenderer"));
            }
        };
    }

    private static TableModel createModel(final ExperimentalFeature[] experimentalFeatures) {
        return new AbstractTableModel(){
            final ExperimentalFeature[] features;
            {
                this.features = experimentalFeatures;
            }

            @Override
            public int getRowCount() {
                return this.features.length;
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                String id2 = this.features[rowIndex].id;
                switch (columnIndex) {
                    case 0: {
                        return id2;
                    }
                    case 1: {
                        return Experiments.getInstance().isFeatureEnabled(id2);
                    }
                }
                throw new IllegalArgumentException("Wrong column number");
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 1;
            }

            @Override
            public String getColumnName(int column2) {
                switch (column2) {
                    case 0: {
                        return ApplicationBundle.message((String)"column.name", (Object[])new Object[0]);
                    }
                    case 1: {
                        return IdeBundle.message((String)"column.enabled", (Object[])new Object[0]);
                    }
                }
                throw new IllegalArgumentException("Wrong column number");
            }

            @Override
            public void setValueAt(Object value2, int rowIndex, int columnIndex) {
                if (value2 instanceof Boolean) {
                    Experiments.getInstance().setFeatureEnabled(this.features[rowIndex].id, ((Boolean)value2).booleanValue());
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/ExperimentsDialog", "createCenterPanel"));
    }
}

