/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors.fileStatus;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.fileStatus.FileStatusColorDescriptor;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorsManagerImpl;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FileStatus;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileStatusColorsTableModel
extends AbstractTableModel {
    private final EditorColorsScheme myScheme;
    private final List<FileStatusColorDescriptor> myDescriptors;
    private static final ColumnInfo[] COLUMNS_INFO = new ColumnInfo[]{new ColumnInfo(Boolean.class, descriptor2 -> descriptor2.isDefault()), new ColumnInfo(String.class, descriptor2 -> descriptor2.getStatus().getText())};

    public FileStatusColorsTableModel(FileStatus @NotNull [] fileStatuses, @NotNull EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            FileStatusColorsTableModel.$$$reportNull$$$0(0);
        }
        if (fileStatuses == null) {
            FileStatusColorsTableModel.$$$reportNull$$$0(1);
        }
        this.myScheme = scheme2;
        this.myDescriptors = FileStatusColorsTableModel.createDescriptors(fileStatuses, this.myScheme);
    }

    private static List<FileStatusColorDescriptor> createDescriptors(FileStatus @NotNull [] fileStatuses, @NotNull EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            FileStatusColorsTableModel.$$$reportNull$$$0(2);
        }
        if (fileStatuses == null) {
            FileStatusColorsTableModel.$$$reportNull$$$0(3);
        }
        EditorColorsScheme baseScheme = scheme2 instanceof AbstractColorsScheme ? ((AbstractColorsScheme)scheme2).getParentScheme() : null;
        ArrayList<FileStatusColorDescriptor> descriptors = new ArrayList<FileStatusColorDescriptor>();
        for (FileStatus fileStatus : fileStatuses) {
            Color color = scheme2.getColor(fileStatus.getColorKey());
            Color originalColor = baseScheme != null ? baseScheme.getColor(fileStatus.getColorKey()) : null;
            descriptors.add(new FileStatusColorDescriptor(fileStatus, color, originalColor));
        }
        descriptors.sort(Comparator.comparing(d -> d.getStatus().getText()));
        return descriptors;
    }

    @Override
    public int getRowCount() {
        return this.myDescriptors.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMNS_INFO.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return columnIndex == 0 ? "" : ApplicationBundle.message((String)"file.status.colors.header.status", (Object[])new Object[0]);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return FileStatusColorsTableModel.COLUMNS_INFO[columnIndex].columnClass;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        FileStatusColorDescriptor descriptor2 = this.myDescriptors.get(rowIndex);
        return FileStatusColorsTableModel.COLUMNS_INFO[columnIndex].dataFunction.apply(descriptor2);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.myDescriptors.get(rowIndex).setColor((Color)aValue);
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    public void resetToDefault(int rowIndex) {
        this.myDescriptors.get(rowIndex).resetToDefault();
        this.fireTableCellUpdated(rowIndex, 1);
    }

    @Nullable
    FileStatusColorDescriptor getDescriptorByName(String statusName) {
        for (FileStatusColorDescriptor descriptor2 : this.myDescriptors) {
            if (!statusName.equals(descriptor2.getStatus().getText())) continue;
            return descriptor2;
        }
        return null;
    }

    public boolean isModified() {
        for (FileStatusColorDescriptor descriptor2 : this.myDescriptors) {
            Color current2;
            ColorKey key = descriptor2.getStatus().getColorKey();
            Color original = this.myScheme.getColor(key);
            if (Comparing.equal((Object)original, (Object)(current2 = descriptor2.getColor()))) continue;
            return true;
        }
        return false;
    }

    public void reset() {
        for (FileStatusColorDescriptor descriptor2 : this.myDescriptors) {
            descriptor2.setColor(this.myScheme.getColor(descriptor2.getStatus().getColorKey()));
        }
        this.fireTableDataChanged();
    }

    public void apply() {
        for (FileStatusColorDescriptor descriptor2 : this.myDescriptors) {
            this.myScheme.setColor(descriptor2.getStatus().getColorKey(), descriptor2.getColor());
        }
        if (this.myScheme instanceof AbstractColorsScheme) {
            ((AbstractColorsScheme)this.myScheme).setSaveNeeded(true);
        }
        if (EditorColorsManagerImpl.isTempScheme(this.myScheme)) {
            ColorAndFontOptions.writeTempScheme(this.myScheme);
        }
    }

    @Nullable
    public FileStatusColorDescriptor getDescriptorAt(int index2) {
        if (index2 >= 0 && index2 < this.myDescriptors.size()) {
            return this.myDescriptors.get(index2);
        }
        return null;
    }

    public boolean containsCustomSettings() {
        for (FileStatusColorDescriptor descriptor2 : this.myDescriptors) {
            if (descriptor2.isDefault()) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileStatuses";
                break;
            }
        }
        objectArray2[1] = "com/intellij/application/options/colors/fileStatus/FileStatusColorsTableModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createDescriptors";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ColumnInfo {
        Class<?> columnClass;
        Function<? super FileStatusColorDescriptor, Object> dataFunction;

        ColumnInfo(Class<?> columnClass, Function<? super FileStatusColorDescriptor, Object> dataFunction) {
            this.columnClass = columnClass;
            this.dataFunction = dataFunction;
        }
    }
}

