/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.editor.fonts;

import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.impl.FontFamilyService;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class FontWeightCombo
extends ComboBox<MyWeightItem> {
    private final MyModel myModel;
    private final boolean myMarkRecommended;

    FontWeightCombo(boolean markRecommended) {
        this.myMarkRecommended = markRecommended;
        this.myModel = new MyModel();
        this.setModel(this.myModel);
        this.setRenderer((ListCellRenderer)((Object)new MyListCellRenderer()));
    }

    void update(@NotNull FontPreferences fontPreferences) {
        if (fontPreferences == null) {
            FontWeightCombo.$$$reportNull$$$0(0);
        }
        this.myModel.update(fontPreferences);
    }

    @Nullable
    String getSelectedSubFamily() {
        Object selected2 = this.myModel.getSelectedItem();
        return selected2 instanceof MyWeightItem ? ((MyWeightItem)selected2).subFamily : null;
    }

    @Nullable
    abstract String getSubFamily(@NotNull FontPreferences var1);

    @NotNull
    abstract String getRecommendedSubFamily(@NotNull String var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontPreferences", "com/intellij/application/options/editor/fonts/FontWeightCombo", "update"));
    }

    static class MyWeightItem {
        @NlsSafe
        private final String subFamily;
        private final boolean isRecommended;

        MyWeightItem(String subFamily, boolean isRecommended) {
            this.subFamily = subFamily;
            this.isRecommended = isRecommended;
        }
    }

    private class MyListCellRenderer
    extends ColoredListCellRenderer<MyWeightItem> {
        private MyListCellRenderer() {
        }

        protected void customizeCellRenderer(@NotNull JList<? extends MyWeightItem> list2, MyWeightItem value2, int index2, boolean selected2, boolean hasFocus) {
            if (list2 == null) {
                MyListCellRenderer.$$$reportNull$$$0(0);
            }
            if (value2 != null) {
                this.append(value2.subFamily);
                if (value2.isRecommended && FontWeightCombo.this.myMarkRecommended && list2.getModel().getSize() > 2) {
                    this.append("  ");
                    this.append(ApplicationBundle.message((String)"settings.editor.font.recommended", (Object[])new Object[0]), SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/application/options/editor/fonts/FontWeightCombo$MyListCellRenderer", "customizeCellRenderer"));
        }
    }

    private class MyModel
    extends AbstractListModel<MyWeightItem>
    implements ComboBoxModel<MyWeightItem> {
        @NotNull
        private final List<MyWeightItem> myItems = new ArrayList<MyWeightItem>();
        @Nullable
        private MyWeightItem mySelectedItem;

        private MyModel() {
        }

        @Override
        public void setSelectedItem(Object anItem) {
            if (anItem instanceof MyWeightItem) {
                this.mySelectedItem = (MyWeightItem)anItem;
            } else if (anItem instanceof String) {
                this.mySelectedItem = (MyWeightItem)ContainerUtil.find(this.myItems, item -> item.subFamily.equals(anItem));
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.mySelectedItem;
        }

        @Override
        public int getSize() {
            return this.myItems.size();
        }

        @Override
        public MyWeightItem getElementAt(int index2) {
            return this.myItems.get(index2);
        }

        private void update(@NotNull FontPreferences currPreferences) {
            if (currPreferences == null) {
                MyModel.$$$reportNull$$$0(0);
            }
            this.myItems.clear();
            String currFamily = currPreferences.getFontFamily();
            String recommended = FontWeightCombo.this.getRecommendedSubFamily(currFamily);
            FontFamilyService.getSubFamilies(currFamily).forEach(subFamily -> this.myItems.add(new MyWeightItem((String)subFamily, subFamily.equals(recommended))));
            String subFamily2 = FontWeightCombo.this.getSubFamily(currPreferences);
            this.setSelectedItem(subFamily2 != null ? subFamily2 : recommended);
            this.fireContentsChanged(this, -1, -1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currPreferences", "com/intellij/application/options/editor/fonts/FontWeightCombo$MyModel", "update"));
        }
    }
}

