/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class CompositeView<T extends ComponentContainer>
extends JPanel
implements ComponentContainer,
DataProvider {
    private final Map<String, T> myViewMap = new ConcurrentHashMap<String, T>();
    @NonNls
    private final String mySelectionStateKey;
    private final AtomicReference<String> myVisibleViewRef = new AtomicReference();
    @NotNull
    private final SwitchViewAction mySwitchViewAction;

    public CompositeView(@NonNls String selectionStateKey) {
        super(new CardLayout());
        this.mySelectionStateKey = selectionStateKey;
        this.mySwitchViewAction = new SwitchViewAction();
    }

    public void addView(@NotNull T view, @NotNull String viewName) {
        T oldView;
        if (view == null) {
            CompositeView.$$$reportNull$$$0(0);
        }
        if (viewName == null) {
            CompositeView.$$$reportNull$$$0(1);
        }
        if ((oldView = this.getView(viewName)) != null) {
            this.remove(oldView.getComponent());
            Disposer.dispose(oldView);
        }
        this.myViewMap.put(viewName, view);
        this.add((Component)view.getComponent(), viewName);
        Disposer.register((Disposable)this, view);
    }

    public void addViewAndShowIfNeeded(@NotNull T view, @NotNull String viewName, boolean showByDefault) {
        if (view == null) {
            CompositeView.$$$reportNull$$$0(2);
        }
        if (viewName == null) {
            CompositeView.$$$reportNull$$$0(3);
        }
        this.addView(view, viewName);
        String storedState = this.getStoredState();
        if (storedState != null && storedState.equals(viewName) || storedState == null && showByDefault) {
            this.showView(viewName);
        }
    }

    public void showView(@NotNull String viewName) {
        if (viewName == null) {
            CompositeView.$$$reportNull$$$0(4);
        }
        this.showView(viewName, true);
        this.setStoredState(viewName);
    }

    public void showView(@NotNull String viewName, boolean requestFocus) {
        if (viewName == null) {
            CompositeView.$$$reportNull$$$0(5);
        }
        if (!StringUtil.equals((CharSequence)viewName, (CharSequence)this.myVisibleViewRef.get())) {
            this.myVisibleViewRef.set(viewName);
            CardLayout cl = (CardLayout)this.getLayout();
            cl.show(this, viewName);
        }
        if (requestFocus) {
            T view = this.getView(viewName);
            new UiNotifyConnector.Once((Component)view.getComponent(), new Activatable((ComponentContainer)view){
                final /* synthetic */ ComponentContainer val$view;
                {
                    this.val$view = componentContainer;
                }

                public void showNotify() {
                    IdeFocusManager.getGlobalInstance().requestFocus((Component)this.val$view.getPreferredFocusableComponent(), true);
                }
            });
        }
    }

    public boolean isViewVisible(String viewName) {
        return StringUtil.equals((CharSequence)this.myVisibleViewRef.get(), (CharSequence)viewName);
    }

    public T getView(@NotNull String viewName) {
        if (viewName == null) {
            CompositeView.$$$reportNull$$$0(6);
        }
        return (T)((ComponentContainer)this.myViewMap.get(viewName));
    }

    @Nullable
    public <U> U getView(@NotNull String viewName, @NotNull Class<U> viewClass) {
        T view;
        if (viewName == null) {
            CompositeView.$$$reportNull$$$0(7);
        }
        if (viewClass == null) {
            CompositeView.$$$reportNull$$$0(8);
        }
        return viewClass.isInstance(view = this.getView(viewName)) ? (U)viewClass.cast(view) : null;
    }

    public AnAction @NotNull [] createConsoleActions() {
        if (AnAction.EMPTY_ARRAY == null) {
            CompositeView.$$$reportNull$$$0(9);
        }
        return AnAction.EMPTY_ARRAY;
    }

    public AnAction @NotNull [] getSwitchActions() {
        DefaultActionGroup actionGroup2 = new DefaultActionGroup();
        actionGroup2.addSeparator();
        actionGroup2.add((AnAction)this.mySwitchViewAction);
        AnAction[] anActionArray = new AnAction[]{actionGroup2};
        if (anActionArray == null) {
            CompositeView.$$$reportNull$$$0(10);
        }
        return anActionArray;
    }

    @NotNull
    public JComponent getComponent() {
        CompositeView compositeView = this;
        if (compositeView == null) {
            CompositeView.$$$reportNull$$$0(11);
        }
        return compositeView;
    }

    public JComponent getPreferredFocusableComponent() {
        return this;
    }

    public void dispose() {
    }

    @Override
    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        Object data2;
        T visibleView;
        String visibleViewName;
        if (dataId == null) {
            CompositeView.$$$reportNull$$$0(12);
        }
        if ((visibleViewName = this.myVisibleViewRef.get()) != null && (visibleView = this.getView(visibleViewName)) instanceof DataProvider && (data2 = ((DataProvider)visibleView).getData(dataId)) != null) {
            return data2;
        }
        return null;
    }

    private void setStoredState(String viewName) {
        if (this.mySelectionStateKey != null) {
            PropertiesComponent.getInstance().setValue(this.mySelectionStateKey, viewName);
        }
    }

    @Nullable
    private String getStoredState() {
        return this.mySelectionStateKey == null ? null : PropertiesComponent.getInstance().getValue(this.mySelectionStateKey);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewClass";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/build/CompositeView";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/build/CompositeView";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleActions";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSwitchActions";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addView";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addViewAndShowIfNeeded";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showView";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getView";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class SwitchViewAction
    extends ToggleAction
    implements DumbAware {
        SwitchViewAction() {
            super(IdeBundle.messagePointer((String)"action.ToggleAction.text.toggle.view", (Object[])new Object[0]), Presentation.NULL_STRING, AllIcons.Actions.ChangeView);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SwitchViewAction.$$$reportNull$$$0(0);
            }
            Presentation presentation2 = e.getPresentation();
            if (CompositeView.this.myViewMap.size() <= 1) {
                presentation2.setEnabledAndVisible(false);
            } else {
                presentation2.setEnabledAndVisible(true);
                Toggleable.setSelected((Presentation)presentation2, (boolean)this.isSelected(e));
            }
        }

        public boolean isSelected(@NotNull AnActionEvent event) {
            String visibleViewName;
            if (event == null) {
                SwitchViewAction.$$$reportNull$$$0(1);
            }
            if ((visibleViewName = CompositeView.this.myVisibleViewRef.get()) == null) {
                return true;
            }
            Set<String> viewNames = CompositeView.this.myViewMap.keySet();
            return viewNames.isEmpty() || visibleViewName.equals(viewNames.iterator().next());
        }

        public void setSelected(@NotNull AnActionEvent event, boolean flag) {
            if (event == null) {
                SwitchViewAction.$$$reportNull$$$0(2);
            }
            if (CompositeView.this.myViewMap.size() > 1) {
                ArrayList<String> names2 = new ArrayList<String>(CompositeView.this.myViewMap.keySet());
                String viewName = flag ? (String)names2.get(0) : (String)names2.get(1);
                CompositeView.this.showView(viewName);
                ApplicationManager.getApplication().invokeLater(() -> this.update(event));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/build/CompositeView$SwitchViewAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

