/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.FileRecursiveIterator;
import com.intellij.codeInsight.actions.LayoutCodeInfoCollector;
import com.intellij.codeInsight.actions.VcsFacade;
import com.intellij.core.CoreBundle;
import com.intellij.lang.LanguageFormatting;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.SequentialTask;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractLayoutCodeProcessor {
    private static final Logger LOG = Logger.getInstance(AbstractLayoutCodeProcessor.class);
    @NotNull
    protected final Project myProject;
    private final Module myModule;
    private PsiDirectory myDirectory;
    private PsiFile myFile;
    private List<PsiFile> myFiles;
    private boolean myIncludeSubdirs;
    private final @NlsContexts.ProgressText String myProgressText;
    private final @NlsContexts.Command String myCommandName;
    private Runnable myPostRunnable;
    private boolean myProcessChangedTextOnly;
    private boolean myProcessAllFilesAsSingleUndoStep;
    protected AbstractLayoutCodeProcessor myPreviousCodeProcessor;
    private List<VirtualFileFilter> myFilters;
    private LayoutCodeInfoCollector myInfoCollector;

    protected AbstractLayoutCodeProcessor(@NotNull Project project, @NlsContexts.Command String commandName2, @NlsContexts.ProgressText String progressText, boolean processChangedTextOnly) {
        if (project == null) {
            AbstractLayoutCodeProcessor.$$$reportNull$$$0(0);
        }
        this(project, (Module)null, commandName2, progressText, processChangedTextOnly);
    }

    protected AbstractLayoutCodeProcessor(@NotNull AbstractLayoutCodeProcessor previous, @NotNull @NlsContexts.Command String commandName2, @NotNull @NlsContexts.ProgressText String progressText) {
        if (previous == null) {
            AbstractLayoutCodeProcessor.$$$reportNull$$$0(1);
        }
        if (commandName2 == null) {
            AbstractLayoutCodeProcessor.$$$reportNull$$$0(2);
        }
        if (progressText == null) {
            AbstractLayoutCodeProcessor.$$$reportNull$$$0(3);
        }
        this.myProcessAllFilesAsSingleUndoStep = true;
        this.myFilters = new ArrayList<VirtualFileFilter>();
        this.myProject = previous.myProject;
        this.myModule = previous.myModule;
        this.myDirectory = previous.myDirectory;
        this.myFile = previous.myFile;
        this.myFiles = previous.myFiles;
        this.myIncludeSubdirs = previous.myIncludeSubdirs;
        this.myProcessChangedTextOnly = previous.myProcessChangedTextOnly;
        this.myPostRunnable = null;
        this.myProgressText = progressText;
        this.myCommandName = commandName2;
        this.myPreviousCodeProcessor = previous;
        this.myFilters = previous.myFilters;
        this.myInfoCollector = previous.myInfoCollector;
    }

    protected AbstractLayoutCodeProcessor(@NotNull Project project, @Nullable Module module, @NlsContexts.Command String commandName2, @NlsContexts.ProgressText String progressText, boolean processChangedTextOnly) {
        if (project == null) {
            AbstractLayoutCodeProcessor.$$$reportNull$$$0(4);
        }
        this.myProcessAllFilesAsSingleUndoStep = true;
        this.myFilters = new ArrayList<VirtualFileFilter>();
        this.myProject = project;
        this.myModule = module;
        this.myDirectory = null;
        this.myIncludeSubdirs = true;
        this.myCommandName = commandName2;
        this.myProgressText = progressText;
        this.myPostRunnable = null;
        this.myProcessChangedTextOnly = processChangedTextOnly;
    }

    protected AbstractLayoutCodeProcessor(@NotNull Project project, @NotNull PsiDirectory directory, boolean includeSubdirs, @NlsContexts.ProgressText String progressText, @NlsContexts.Command String commandName2, boolean processChangedTextOnly) {
        if (project == null) {
            AbstractLayoutCodeProcessor.$$$reportNull$$$0(5);
        }
        if (directory == null) {
            AbstractLayoutCodeProcessor.$$$reportNull$$$0(6);
        }
        this.myProcessAllFilesAsSingleUndoStep = true;
        this.myFilters = new ArrayList<VirtualFileFilter>();
        this.myProject = project;
        this.myModule = null;
        this.myDirectory = directory;
        this.myIncludeSubdirs = includeSubdirs;
        this.myProgressText = progressText;
        this.myCommandName = commandName2;
        this.myPostRunnable = null;
        this.myProcessChangedTextOnly = processChangedTextOnly;
    }

    protected AbstractLayoutCodeProcessor(@NotNull Project project, @NotNull PsiFile file2, @NlsContexts.ProgressText String progressText, @NlsContexts.Command String commandName2, boolean processChangedTextOnly) {
        if (project == null) {
            AbstractLayoutCodeProcessor.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            AbstractLayoutCodeProcessor.$$$reportNull$$$0(8);
        }
        this.myProcessAllFilesAsSingleUndoStep = true;
        this.myFilters = new ArrayList<VirtualFileFilter>();
        this.myProject = project;
        this.myModule = null;
        this.myFile = file2;
        this.myProgressText = progressText;
        this.myCommandName = commandName2;
        this.myPostRunnable = null;
        this.myProcessChangedTextOnly = processChangedTextOnly;
    }

    protected AbstractLayoutCodeProcessor(@NotNull Project project, PsiFile @NotNull [] files2, @NlsContexts.ProgressText String progressText, @NlsContexts.Command String commandName2, @Nullable Runnable postRunnable, boolean processChangedTextOnly) {
        if (project == null) {
            AbstractLayoutCodeProcessor.$$$reportNull$$$0(9);
        }
        if (files2 == null) {
            AbstractLayoutCodeProcessor.$$$reportNull$$$0(10);
        }
        this.myProcessAllFilesAsSingleUndoStep = true;
        this.myFilters = new ArrayList<VirtualFileFilter>();
        this.myProject = project;
        this.myModule = null;
        this.myFiles = ContainerUtil.filter((Object[])files2, AbstractLayoutCodeProcessor::canBeFormatted);
        this.myProgressText = progressText;
        this.myCommandName = commandName2;
        this.myPostRunnable = postRunnable;
        this.myProcessChangedTextOnly = processChangedTextOnly;
    }

    public void setPostRunnable(Runnable postRunnable) {
        this.myPostRunnable = postRunnable;
    }

    public void setCollectInfo(boolean isCollectInfo) {
        this.myInfoCollector = isCollectInfo ? new LayoutCodeInfoCollector() : null;
        AbstractLayoutCodeProcessor current2 = this;
        while (current2.myPreviousCodeProcessor != null) {
            current2 = current2.myPreviousCodeProcessor;
            current2.myInfoCollector = this.myInfoCollector;
        }
    }

    public void addFileFilter(@NotNull VirtualFileFilter filter) {
        if (filter == null) {
            AbstractLayoutCodeProcessor.$$$reportNull$$$0(11);
        }
        this.myFilters.add(filter);
    }

    void setProcessChangedTextOnly(boolean value2) {
        this.myProcessChangedTextOnly = value2;
    }

    public void setProcessAllFilesAsSingleUndoStep(boolean singleUndoStep) {
        this.myProcessAllFilesAsSingleUndoStep = singleUndoStep;
    }

    @NotNull
    protected abstract FutureTask<Boolean> prepareTask(@NotNull PsiFile var1, boolean var2) throws IncorrectOperationException;

    @NotNull
    protected static FutureTask<Boolean> emptyTask() {
        return new FutureTask<Boolean>(EmptyRunnable.INSTANCE, true);
    }

    protected boolean needsReadActionToPrepareTask() {
        return true;
    }

    public void run() {
        if (this.myFile != null) {
            this.runProcessFile(this.myFile);
            return;
        }
        this.runProcessFiles();
    }

    @NotNull
    private FileRecursiveIterator build() {
        if (this.myFiles != null) {
            return new FileRecursiveIterator(this.myProject, this.myFiles);
        }
        if (this.myProcessChangedTextOnly) {
            return this.buildChangedFilesIterator();
        }
        if (this.myDirectory != null) {
            return new FileRecursiveIterator(this.myDirectory);
        }
        if (this.myModule != null) {
            return new FileRecursiveIterator(this.myModule);
        }
        return new FileRecursiveIterator(this.myProject);
    }

    @NotNull
    private FileRecursiveIterator buildChangedFilesIterator() {
        List<PsiFile> files2 = this.getChangedFilesFromContext();
        return new FileRecursiveIterator(this.myProject, files2);
    }

    @NotNull
    private List<PsiFile> getChangedFilesFromContext() {
        List<PsiDirectory> dirs = this.getAllSearchableDirsFromContext();
        List<PsiFile> list2 = VcsFacade.getInstance().getChangedFilesFromDirs(this.myProject, dirs);
        if (list2 == null) {
            AbstractLayoutCodeProcessor.$$$reportNull$$$0(12);
        }
        return list2;
    }

    private List<PsiDirectory> getAllSearchableDirsFromContext() {
        ArrayList<PsiDirectory> dirs = new ArrayList<PsiDirectory>();
        if (this.myDirectory != null) {
            dirs.add(this.myDirectory);
        } else if (this.myModule != null) {
            List<PsiDirectory> allModuleDirs = FileRecursiveIterator.collectModuleDirectories(this.myModule);
            dirs.addAll(allModuleDirs);
        } else {
            List<PsiDirectory> allProjectDirs = FileRecursiveIterator.collectProjectDirectories(this.myProject);
            dirs.addAll(allProjectDirs);
        }
        return dirs;
    }

    private void runProcessFile(final @NotNull PsiFile file2) {
        if (file2 == null) {
            AbstractLayoutCodeProcessor.$$$reportNull$$$0(13);
        }
        PsiUtilCore.ensureValid((PsiElement)file2);
        Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(file2);
        if (document == null) {
            return;
        }
        if (!FileDocumentManager.getInstance().requestWriting(document, this.myProject)) {
            Messages.showMessageDialog((Project)this.myProject, (String)CoreBundle.message((String)"cannot.modify.a.read.only.file", (Object[])new Object[]{file2.getName()}), (String)CodeInsightBundle.message((String)"error.dialog.readonly.file.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            return;
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, this.getProgressTitle(), true){

            public void run(@NotNull ProgressIndicator indicator2) {
                if (indicator2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator2.setText(AbstractLayoutCodeProcessor.this.myProgressText);
                try {
                    new ProcessingTask(indicator2).performFileProcessing(file2);
                }
                catch (IndexNotReadyException e) {
                    LOG.warn((Throwable)e);
                    return;
                }
                if (AbstractLayoutCodeProcessor.this.myPostRunnable != null) {
                    ApplicationManager.getApplication().invokeLater(AbstractLayoutCodeProcessor.this.myPostRunnable);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor$1", "run"));
            }
        });
    }

    private void runProcessFiles() {
        boolean isSuccess = (Boolean)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            ProgressIndicator indicator2 = ProgressManager.getInstance().getProgressIndicator();
            return this.processFilesUnderProgress(indicator2);
        }, this.getProgressTitle(), true, this.myProject);
        if (isSuccess && this.myPostRunnable != null) {
            this.myPostRunnable.run();
        }
    }

    @NotNull
    @NlsContexts.ProgressTitle
    private String getProgressTitle() {
        AbstractLayoutCodeProcessor processor2 = this.getInitialProcessor();
        String string = processor2.myCommandName;
        if (string == null) {
            AbstractLayoutCodeProcessor.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    private AbstractLayoutCodeProcessor getInitialProcessor() {
        AbstractLayoutCodeProcessor current2 = this;
        while (current2.myPreviousCodeProcessor != null) {
            current2 = current2.myPreviousCodeProcessor;
        }
        AbstractLayoutCodeProcessor abstractLayoutCodeProcessor = current2;
        if (abstractLayoutCodeProcessor == null) {
            AbstractLayoutCodeProcessor.$$$reportNull$$$0(15);
        }
        return abstractLayoutCodeProcessor;
    }

    private static boolean canBeFormatted(@NotNull PsiFile file2) {
        if (file2 == null) {
            AbstractLayoutCodeProcessor.$$$reportNull$$$0(16);
        }
        if (!file2.isValid()) {
            return false;
        }
        if (LanguageFormatting.INSTANCE.forContext((PsiElement)file2) == null) {
            return false;
        }
        VirtualFile virtualFile2 = file2.getVirtualFile();
        if (virtualFile2 == null) {
            return true;
        }
        if (ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)virtualFile2)) {
            return false;
        }
        return !GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)virtualFile2, (Project)file2.getProject());
    }

    public void runWithoutProgress() throws IncorrectOperationException {
        new ProcessingTask((ProgressIndicator)new EmptyProgressIndicator()).performFileProcessing(this.myFile);
    }

    public boolean processFilesUnderProgress(@NotNull ProgressIndicator indicator2) {
        if (indicator2 == null) {
            AbstractLayoutCodeProcessor.$$$reportNull$$$0(17);
        }
        indicator2.setIndeterminate(false);
        ProcessingTask task2 = new ProcessingTask(indicator2);
        return task2.process();
    }

    @NotNull
    private List<AbstractLayoutCodeProcessor> getAllProcessors() {
        AbstractLayoutCodeProcessor current2 = this;
        ArrayList<AbstractLayoutCodeProcessor> all2 = new ArrayList<AbstractLayoutCodeProcessor>();
        while (current2 != null) {
            all2.add(current2);
            current2 = current2.myPreviousCodeProcessor;
        }
        Collections.reverse(all2);
        ArrayList<AbstractLayoutCodeProcessor> arrayList = all2;
        if (arrayList == null) {
            AbstractLayoutCodeProcessor.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    @NotNull
    @NlsSafe
    public static String getPresentablePath(@NotNull Project project, @NotNull PsiFile file2) {
        VirtualFile vFile;
        if (project == null) {
            AbstractLayoutCodeProcessor.$$$reportNull$$$0(19);
        }
        if (file2 == null) {
            AbstractLayoutCodeProcessor.$$$reportNull$$$0(20);
        }
        String string = (vFile = file2.getVirtualFile()) != null ? ProjectUtil.calcRelativeToProjectPath((VirtualFile)vFile, (Project)project) : file2.getName();
        if (string == null) {
            AbstractLayoutCodeProcessor.$$$reportNull$$$0(21);
        }
        return string;
    }

    private boolean acceptedByFilters(@NotNull PsiFile file2) {
        VirtualFile vFile;
        if (file2 == null) {
            AbstractLayoutCodeProcessor.$$$reportNull$$$0(22);
        }
        if ((vFile = file2.getVirtualFile()) == null) {
            return false;
        }
        for (VirtualFileFilter filter : this.myFilters) {
            if (filter.accept(file2.getVirtualFile())) continue;
            return false;
        }
        return true;
    }

    static List<TextRange> getSelectedRanges(@NotNull SelectionModel selectionModel) {
        if (selectionModel == null) {
            AbstractLayoutCodeProcessor.$$$reportNull$$$0(23);
        }
        SmartList ranges = new SmartList();
        if (selectionModel.hasSelection()) {
            TextRange range2 = TextRange.create((int)selectionModel.getSelectionStart(), (int)selectionModel.getSelectionEnd());
            ranges.add(range2);
        }
        return ranges;
    }

    void handleFileTooBigException(Logger logger, FilesTooBigForDiffException e, @NotNull PsiFile file2) {
        if (file2 == null) {
            AbstractLayoutCodeProcessor.$$$reportNull$$$0(24);
        }
        logger.info("Error while calculating changed ranges for: " + file2.getVirtualFile(), (Throwable)e);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            Notification notification = new Notification(NotificationGroup.createIdWithTitle((String)"Reformat changed text", (String)ApplicationBundle.message((String)"reformat.changed.text.file.too.big.notification.groupId", (Object[])new Object[0])), ApplicationBundle.message((String)"reformat.changed.text.file.too.big.notification.title", (Object[])new Object[0]), ApplicationBundle.message((String)"reformat.changed.text.file.too.big.notification.text", (Object[])new Object[]{file2.getName()}), NotificationType.INFORMATION);
            notification.notify(file2.getProject());
        }
    }

    @Nullable
    public LayoutCodeInfoCollector getInfoCollector() {
        return this.myInfoCollector;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 18: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 18: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previous";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressText";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 8: 
            case 13: 
            case 16: 
            case 20: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangedFilesFromContext";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getProgressTitle";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialProcessor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllProcessors";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentablePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addFileFilter";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 18: 
            case 21: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "runProcessFile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "canBeFormatted";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processFilesUnderProgress";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPresentablePath";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "acceptedByFilters";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedRanges";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "handleFileTooBigException";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 18: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ProcessingTask
    implements SequentialTask {
        private final List<AbstractLayoutCodeProcessor> myProcessors;
        private final FileRecursiveIterator myFileTreeIterator;
        private final FileRecursiveIterator myCountingIterator;
        private final ProgressIndicator myProgressIndicator;
        private int myTotalFiles;
        private int myFilesProcessed;
        private boolean myStopFormatting;
        private PsiFile next;

        ProcessingTask(ProgressIndicator indicator2) {
            if (indicator2 == null) {
                ProcessingTask.$$$reportNull$$$0(0);
            }
            this.myFileTreeIterator = (FileRecursiveIterator)ReadAction.compute(() -> AbstractLayoutCodeProcessor.this.build());
            this.myCountingIterator = (FileRecursiveIterator)ReadAction.compute(() -> AbstractLayoutCodeProcessor.this.build());
            this.myProcessors = AbstractLayoutCodeProcessor.this.getAllProcessors();
            this.myProgressIndicator = indicator2;
        }

        @Override
        public boolean isDone() {
            return this.myStopFormatting;
        }

        private void countingIteration() {
            ++this.myTotalFiles;
        }

        @Override
        public boolean iteration() {
            if (this.myStopFormatting) {
                return true;
            }
            this.updateIndicatorFraction(this.myFilesProcessed);
            if (this.next != null) {
                PsiFile file2 = this.next;
                ++this.myFilesProcessed;
                if (this.shouldProcessFile(file2).booleanValue()) {
                    this.updateIndicatorText(ApplicationBundle.message((String)"bulk.reformat.process.progress.text", (Object[])new Object[0]), AbstractLayoutCodeProcessor.getPresentablePath(AbstractLayoutCodeProcessor.this.myProject, file2));
                    DumbService.getInstance((Project)AbstractLayoutCodeProcessor.this.myProject).withAlternativeResolveEnabled(() -> this.performFileProcessing(file2));
                }
            }
            return true;
        }

        private Boolean shouldProcessFile(PsiFile file2) {
            return (Boolean)ReadAction.compute(() -> file2.isWritable() && AbstractLayoutCodeProcessor.canBeFormatted(file2) && AbstractLayoutCodeProcessor.this.acceptedByFilters(file2));
        }

        private void performFileProcessing(@NotNull PsiFile file2) {
            if (file2 == null) {
                ProcessingTask.$$$reportNull$$$0(1);
            }
            String groupId2 = AbstractLayoutCodeProcessor.this.myProcessAllFilesAsSingleUndoStep ? AbstractLayoutCodeProcessor.this.toString() : AbstractLayoutCodeProcessor.this.toString() + file2.hashCode();
            for (AbstractLayoutCodeProcessor processor2 : this.myProcessors) {
                FutureTask writeTask = processor2.needsReadActionToPrepareTask() ? (FutureTask)ReadAction.nonBlocking(() -> processor2.prepareTask(file2, AbstractLayoutCodeProcessor.this.myProcessChangedTextOnly)).executeSynchronously() : processor2.prepareTask(file2, AbstractLayoutCodeProcessor.this.myProcessChangedTextOnly);
                ProgressIndicatorProvider.checkCanceled();
                ApplicationManager.getApplication().invokeAndWait(() -> WriteCommandAction.writeCommandAction((Project)AbstractLayoutCodeProcessor.this.myProject).withName(AbstractLayoutCodeProcessor.this.myCommandName).withGroupId(groupId2).shouldRecordActionForActiveDocument(AbstractLayoutCodeProcessor.this.myProcessAllFilesAsSingleUndoStep).run(() -> writeTask.run()));
                this.checkStop(writeTask, file2);
            }
        }

        private void checkStop(FutureTask<Boolean> task2, PsiFile file2) {
            try {
                if (!task2.get().booleanValue() || task2.isCancelled()) {
                    this.myStopFormatting = true;
                }
            }
            catch (InterruptedException | ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IndexNotReadyException) {
                    LOG.warn(cause);
                    return;
                }
                LOG.error("Got unexpected exception during formatting " + file2, (Throwable)e);
            }
        }

        private void updateIndicatorText(@NotNull @NlsContexts.ProgressText String upperLabel, @NotNull @NlsContexts.ProgressDetails String downLabel) {
            if (upperLabel == null) {
                ProcessingTask.$$$reportNull$$$0(2);
            }
            if (downLabel == null) {
                ProcessingTask.$$$reportNull$$$0(3);
            }
            this.myProgressIndicator.setText(upperLabel);
            this.myProgressIndicator.setText2(downLabel);
        }

        private void updateIndicatorFraction(int processed2) {
            this.myProgressIndicator.setFraction((double)processed2 / (double)this.myTotalFiles);
        }

        @Override
        public void stop() {
            this.myStopFormatting = true;
        }

        private boolean process() {
            this.myCountingIterator.processAll((Processor<? super PsiFile>)((Processor)file2 -> {
                this.updateIndicatorText(ApplicationBundle.message((String)"bulk.reformat.prepare.progress.text", (Object[])new Object[0]), "");
                this.countingIteration();
                return !this.isDone();
            }));
            return this.myFileTreeIterator.processAll((Processor<? super PsiFile>)((Processor)file2 -> {
                this.next = file2;
                this.iteration();
                return !this.isDone();
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "upperLabel";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "downLabel";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/actions/AbstractLayoutCodeProcessor$ProcessingTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performFileProcessing";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateIndicatorText";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

