/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.DeclarativeInsertHandler2;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/codeInsight/completion/SingleInsertionDeclarativeInsertHandler;", "Lcom/intellij/codeInsight/completion/DeclarativeInsertHandler2;", "stringToInsert", "", "popupOptions", "Lcom/intellij/codeInsight/completion/DeclarativeInsertHandler2$PopupOptions;", "(Ljava/lang/String;Lcom/intellij/codeInsight/completion/DeclarativeInsertHandler2$PopupOptions;)V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "isValueAlreadyHere", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.platform.analysis.impl"})
@ApiStatus.Experimental
public final class SingleInsertionDeclarativeInsertHandler
extends DeclarativeInsertHandler2 {
    private final String stringToInsert;

    @Override
    public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Editor editor2 = context2.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"context.editor");
        boolean applyTextOperations = !this.isValueAlreadyHere(editor2);
        this.conditionalHandleInsert(context2, item, applyTextOperations);
    }

    private final boolean isValueAlreadyHere(Editor editor2) {
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        int startOffset = caretModel.getOffset();
        int valueLength = this.stringToInsert.length();
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        return document.getTextLength() >= startOffset + valueLength && Intrinsics.areEqual((Object)editor2.getDocument().getText(TextRange.create((int)startOffset, (int)(startOffset + valueLength))), (Object)this.stringToInsert);
    }

    public SingleInsertionDeclarativeInsertHandler(@NotNull String stringToInsert, @NotNull DeclarativeInsertHandler2.PopupOptions popupOptions) {
        Intrinsics.checkNotNullParameter((Object)stringToInsert, (String)"stringToInsert");
        Intrinsics.checkNotNullParameter((Object)popupOptions, (String)"popupOptions");
        super(CollectionsKt.listOf((Object)new DeclarativeInsertHandler2.RelativeTextEdit(0, 0, stringToInsert)), stringToInsert.length(), null, null, popupOptions);
        this.stringToInsert = stringToInsert;
    }
}

