/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.DependentNSReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.URLReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.xml.XmlNamespaceHelper;
import com.intellij.xml.XmlSchemaProvider;
import com.intellij.xml.index.XmlNamespaceIndex;
import com.intellij.xml.index.XsdNamespaceBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

final class XmlLocationCompletionContributor
extends CompletionContributor {
    public static final Function<Object, LookupElement> MAPPING = o -> o instanceof LookupElement ? (LookupElement)o : LookupElementBuilder.create((Object)o);

    XmlLocationCompletionContributor() {
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result2) {
        PsiReference reference2;
        if (parameters2 == null) {
            XmlLocationCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            XmlLocationCompletionContributor.$$$reportNull$$$0(1);
        }
        if ((reference2 = parameters2.getPosition().getContainingFile().findReferenceAt(parameters2.getOffset())) instanceof URLReference) {
            if (((URLReference)reference2).isSchemaLocation()) {
                Object[] objects = XmlLocationCompletionContributor.completeSchemaLocation(reference2.getElement());
                result2.addAllElements((Iterable)ContainerUtil.map((Object[])objects, MAPPING));
                if (objects.length > 0) {
                    result2.stopHere();
                }
                return;
            }
            Object[] objects = XmlLocationCompletionContributor.completeNamespace(reference2.getElement());
            result2.addAllElements((Iterable)ContainerUtil.map((Object[])objects, MAPPING));
            if (objects.length > 0) {
                result2.stopHere();
            }
            return;
        }
        if (reference2 instanceof PsiMultiReference) {
            reference2 = ((PsiMultiReference)reference2).getReferences()[0];
        }
        if (reference2 instanceof DependentNSReference) {
            MultiMap<String, String> map2 = ExternalResourceManagerEx.getInstanceEx().getUrlsByNamespace(parameters2.getOriginalFile().getProject());
            String namespace = ((DependentNSReference)reference2).getNamespaceReference().getCanonicalText();
            Collection strings = map2.get((Object)namespace);
            for (String string : strings) {
                if (namespace.equals(string)) continue;
                result2.consume(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)string), (double)100.0));
            }
            if (!strings.isEmpty()) {
                result2.stopHere();
            }
        }
    }

    private static Object[] completeNamespace(PsiElement myElement) {
        XmlFile file2 = (XmlFile)myElement.getContainingFile();
        PsiElement parent = myElement.getParent();
        HashSet list2 = new HashSet();
        for (XmlSchemaProvider provider2 : XmlSchemaProvider.EP_NAME.getExtensionList()) {
            if (!provider2.isAvailable(file2)) continue;
            list2.addAll(provider2.getAvailableNamespaces(file2, null));
        }
        if (!list2.isEmpty()) {
            return ArrayUtil.toObjectArray(list2);
        }
        HashSet set2 = new HashSet(ExternalResourceManagerEx.getInstanceEx().getUrlsByNamespace(myElement.getProject()).keySet());
        Set fromIndex = XmlNamespaceIndex.getAllResources(null, myElement.getProject()).stream().filter(resource -> "xsd".equals(resource.getFile().getExtension())).map(resource -> ((XsdNamespaceBuilder)resource.getValue()).getNamespace()).collect(Collectors.toSet());
        ContainerUtil.addAllNotNull(set2, fromIndex);
        Object[] resourceUrls = set2.toArray();
        XmlDocument document = file2.getDocument();
        assert (document != null);
        XmlTag rootTag = document.getRootTag();
        ArrayList additionalNs = new ArrayList();
        if (rootTag != null) {
            URLReference.processWsdlSchemas(rootTag, (Processor<? super XmlTag>)((Processor)xmlTag -> {
                String s = xmlTag.getAttributeValue("targetNamespace");
                if (s != null) {
                    additionalNs.add(s);
                }
                return true;
            }));
        }
        resourceUrls = ArrayUtil.mergeArrays((Object[])resourceUrls, (Object[])ArrayUtilRt.toStringArray(additionalNs));
        HashSet<String> preferred = new HashSet<String>();
        if (parent instanceof XmlAttribute && "xmlns".equals(((XmlAttribute)parent).getName())) {
            XmlNamespaceHelper helper2 = XmlNamespaceHelper.getHelper((PsiFile)file2);
            preferred.addAll(helper2.guessUnboundNamespaces(parent.getParent(), file2));
        }
        return ContainerUtil.map2Array((Object[])resourceUrls, o -> {
            LookupElementBuilder builder2 = LookupElementBuilder.create((Object)o);
            return preferred.contains(o) ? PrioritizedLookupElement.withPriority((LookupElement)builder2, (double)100.0) : builder2;
        });
    }

    private static Object[] completeSchemaLocation(PsiElement element2) {
        XmlTag tag2 = (XmlTag)element2.getParent().getParent();
        Object[] attributes2 = tag2.getAttributes();
        PsiReference[] refs = element2.getReferences();
        return ContainerUtil.mapNotNull((Object[])attributes2, attribute -> {
            String attributeValue = attribute.getValue();
            return attributeValue != null && attribute.isNamespaceDeclaration() && ContainerUtil.find((Object[])refs, ref -> ref.getCanonicalText().equals(attributeValue)) == null ? attributeValue + " " : null;
        }, (Object[])ArrayUtilRt.EMPTY_OBJECT_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/completion/XmlLocationCompletionContributor";
        objectArray[2] = "fillCompletionVariants";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

