/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xml.util.CheckEmptyTagInspection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlSmartEnterProcessor
extends SmartEnterProcessor {
    private static final Logger LOG = Logger.getInstance(XmlSmartEnterProcessor.class);

    public boolean process(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile psiFile) {
        if (project == null) {
            XmlSmartEnterProcessor.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            XmlSmartEnterProcessor.$$$reportNull$$$0(1);
        }
        if (psiFile == null) {
            XmlSmartEnterProcessor.$$$reportNull$$$0(2);
        }
        return this.completeEndTag(project, editor2, psiFile);
    }

    private boolean completeEndTag(Project project, Editor editor2, PsiFile psiFile) {
        PsiElement atCaret = this.getStatementAtCaret(editor2, psiFile);
        XmlTag tagAtCaret = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)atCaret, XmlTag.class);
        if (tagAtCaret == null) {
            return false;
        }
        try {
            ASTNode emptyTagEnd = XmlChildRole.EMPTY_TAG_END_FINDER.findChild(tagAtCaret.getNode());
            ASTNode endTagEnd = XmlChildRole.START_TAG_END_FINDER.findChild(tagAtCaret.getNode());
            Document doc = editor2.getDocument();
            if (emptyTagEnd == null && endTagEnd == null) {
                char ch;
                int insertionOffset = tagAtCaret.getTextRange().getEndOffset();
                int caretAt = editor2.getCaretModel().getOffset();
                CharSequence text2 = doc.getCharsSequence();
                int probableCommaOffset = CharArrayUtil.shiftForward((CharSequence)text2, (int)insertionOffset, (String)" \t");
                PsiElement sibling = tagAtCaret.getNextSibling();
                int caretTo = caretAt;
                if (caretAt < probableCommaOffset) {
                    XmlAttribute xmlAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)atCaret, XmlAttribute.class, (boolean)false, (Class[])new Class[]{XmlTag.class});
                    CharSequence tagNameText = null;
                    if (xmlAttribute != null) {
                        ASTNode tagName;
                        ASTNode node2 = tagAtCaret.getNode();
                        if (node2 != null && (tagName = XmlChildRole.START_TAG_NAME_FINDER.findChild(node2)) != null) {
                            tagNameText = tagName.getText();
                        }
                        XmlAttributeValue valueElement = xmlAttribute.getValueElement();
                        TextRange textRange = xmlAttribute.getTextRange();
                        int n = valueElement == null ? textRange.getStartOffset() : (caretAt = XmlSmartEnterProcessor.getClosingQuote(xmlAttribute).length() == 0 ? textRange.getEndOffset() : caretAt);
                    }
                    if (tagNameText == null) {
                        tagNameText = text2.subSequence(tagAtCaret.getTextRange().getStartOffset() + 1, caretAt);
                    }
                    PsiElement element2 = psiFile.findElementAt(probableCommaOffset);
                    XmlTag tag2 = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element2, XmlTag.class);
                    boolean shouldInsertClosingTag = this.shouldAfterWrapTextWithTag(caretAt, probableCommaOffset) || this.shouldInsertClosingTag(xmlAttribute, tagAtCaret);
                    String text2insert = this.getClosingPart(xmlAttribute, tagAtCaret, !shouldInsertClosingTag);
                    if (tag2 != null && tag2.getTextRange().getStartOffset() == probableCommaOffset) {
                        doc.insertString(caretAt, (CharSequence)text2insert);
                        if (shouldInsertClosingTag) {
                            doc.insertString(tag2.getTextRange().getEndOffset() + text2insert.length(), (CharSequence)("</" + tagAtCaret.getName() + ">"));
                        }
                        caretTo = tag2.getTextRange().getEndOffset() + text2insert.length();
                    } else {
                        doc.insertString(caretAt, (CharSequence)text2insert);
                        if (shouldInsertClosingTag) {
                            doc.insertString(probableCommaOffset + text2insert.length(), (CharSequence)("</" + tagNameText + ">"));
                        }
                        caretTo = probableCommaOffset + text2insert.length();
                    }
                } else if (sibling instanceof XmlTag && sibling.getTextRange().getStartOffset() == caretAt) {
                    XmlAttribute xmlAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)atCaret, XmlAttribute.class, (boolean)false, (Class[])new Class[]{XmlTag.class});
                    String text2insert = this.getClosingPart(xmlAttribute, tagAtCaret, false);
                    doc.insertString(caretAt, (CharSequence)text2insert);
                    if (this.shouldInsertClosingTag(xmlAttribute, tagAtCaret)) {
                        doc.insertString(sibling.getTextRange().getEndOffset() + text2insert.length(), (CharSequence)("</" + tagAtCaret.getName() + ">"));
                    }
                    caretTo = sibling.getTextRange().getEndOffset() + text2insert.length();
                } else if (probableCommaOffset >= text2.length() || (ch = text2.charAt(probableCommaOffset)) != '/' && ch != '>') {
                    XmlAttribute xmlAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)atCaret, XmlAttribute.class, (boolean)false, (Class[])new Class[]{XmlTag.class});
                    String text2insert = this.getClosingPart(xmlAttribute, tagAtCaret, true);
                    doc.insertString(insertionOffset, (CharSequence)text2insert);
                    caretTo = insertionOffset + text2insert.indexOf(62) + 1;
                }
                this.commitChanges(project, editor2, psiFile, caretTo, null);
            } else {
                XmlTag unclosedTag = XmlSmartEnterProcessor.findClosestUnclosedTag(tagAtCaret);
                if (unclosedTag == null) {
                    return false;
                }
                String closingTagString = "</" + unclosedTag.getName() + ">";
                XmlTag parentTag = unclosedTag.getParentTag();
                ASTNode parentEndTagNode = parentTag != null ? XmlChildRole.CLOSING_TAG_START_FINDER.findChild(parentTag.getNode()) : null;
                int offset = parentEndTagNode != null ? parentEndTagNode.getTextRange().getStartOffset() : unclosedTag.getTextRange().getEndOffset();
                doc.insertString(offset, (CharSequence)closingTagString);
                this.commitChanges(project, editor2, psiFile, offset, parentTag != null ? parentTag : unclosedTag);
            }
            return true;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return false;
        }
    }

    protected boolean shouldAfterWrapTextWithTag(int caretAt, int probableCommaOffset) {
        return probableCommaOffset > caretAt;
    }

    private void commitChanges(Project project, Editor editor2, PsiFile psiFile, int caretOffset, @Nullable XmlTag tagToReformat) {
        if (XmlSmartEnterProcessor.isUncommited((Project)project)) {
            this.commit(editor2);
            if (tagToReformat == null) {
                tagToReformat = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.getStatementAtCaret(editor2, psiFile), XmlTag.class);
            }
            editor2.getCaretModel().moveToOffset(caretOffset);
        }
        if (tagToReformat != null) {
            this.reformat((PsiElement)tagToReformat);
        }
        this.commit(editor2);
    }

    @Nullable
    private static XmlTag findClosestUnclosedTag(XmlTag tag2) {
        XmlTag unclosedTag = tag2;
        while (unclosedTag != null) {
            PsiElement lastChild = unclosedTag.getLastChild();
            if (XmlSmartEnterProcessor.isTagUnclosed(lastChild)) {
                return unclosedTag;
            }
            XmlTag prevTag = (XmlTag)PsiTreeUtil.getPrevSiblingOfType((PsiElement)unclosedTag, XmlTag.class);
            unclosedTag = prevTag != null ? prevTag : (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)unclosedTag, XmlTag.class);
        }
        return null;
    }

    protected static boolean isTagUnclosed(PsiElement lastChild) {
        return lastChild != null && lastChild.getNode().getElementType() != XmlTokenType.XML_TAG_END && lastChild.getNode().getElementType() != XmlTokenType.XML_EMPTY_ELEMENT_END;
    }

    protected boolean shouldInsertClosingTag(XmlAttribute xmlAttribute, XmlTag tagAtCaret) {
        return xmlAttribute == null || XmlSmartEnterProcessor.getClosingQuote(xmlAttribute).length() != 0;
    }

    protected String getClosingPart(XmlAttribute xmlAttribute, XmlTag tagAtCaret, boolean emptyTag) {
        return XmlSmartEnterProcessor.getClosingQuote(xmlAttribute) + (String)(emptyTag ? (CheckEmptyTagInspection.isTagWithEmptyEndNotAllowed(tagAtCaret) ? "></" + tagAtCaret.getName() + ">" : "/>") : ">");
    }

    @NotNull
    protected static CharSequence getClosingQuote(@Nullable XmlAttribute attribute) {
        if (attribute == null) {
            return "";
        }
        XmlAttributeValue element2 = attribute.getValueElement();
        if (element2 == null) {
            return "";
        }
        String s = element2.getText();
        if (s != null && s.length() > 0) {
            if (s.charAt(0) == '\"' && s.charAt(s.length() - 1) != '\"') {
                return "\"";
            }
            if (s.charAt(0) == '\'' && s.charAt(s.length() - 1) != '\'') {
                return "'";
            }
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "psiFile";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/completion/XmlSmartEnterProcessor";
        objectArray[2] = "process";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

