/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.GutterIconDescriptor;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.daemon.LineMarkerProviders;
import com.intellij.codeInsight.daemon.LineMarkerSettings;
import com.intellij.codeInsight.daemon.MergeableLineMarkerInfo;
import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.Divider;
import com.intellij.codeInsight.daemon.impl.LineMarkersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.PairConsumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.NotNullList;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public final class LineMarkersPass
extends TextEditorHighlightingPass {
    private static final Logger LOG = Logger.getInstance(LineMarkersPass.class);
    private volatile List<LineMarkerInfo<?>> myMarkers;
    @NotNull
    private final PsiFile myFile;
    @NotNull
    private final TextRange myPriorityBounds;
    @NotNull
    private final TextRange myRestrictRange;

    LineMarkersPass(@NotNull Project project, @NotNull PsiFile file2, @NotNull Document document, @NotNull TextRange priorityBounds, @NotNull TextRange restrictRange) {
        if (project == null) {
            LineMarkersPass.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            LineMarkersPass.$$$reportNull$$$0(1);
        }
        if (document == null) {
            LineMarkersPass.$$$reportNull$$$0(2);
        }
        if (priorityBounds == null) {
            LineMarkersPass.$$$reportNull$$$0(3);
        }
        if (restrictRange == null) {
            LineMarkersPass.$$$reportNull$$$0(4);
        }
        super(project, document, false);
        this.myMarkers = Collections.emptyList();
        this.myFile = file2;
        this.myPriorityBounds = priorityBounds;
        this.myRestrictRange = restrictRange;
    }

    @Override
    public void doApplyInformationToEditor() {
        try {
            LineMarkersUtil.setLineMarkersToEditor(this.myProject, this.getDocument(), (Segment)this.myRestrictRange, this.myMarkers, this.getId());
            DaemonCodeAnalyzerEx daemonCodeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject);
            daemonCodeAnalyzer.getFileStatusMap().markFileUpToDate(this.myDocument, this.getId());
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
    }

    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress2) {
        if (progress2 == null) {
            LineMarkersPass.$$$reportNull$$$0(5);
        }
        if (!EditorSettingsExternalizable.getInstance().areGutterIconsShown()) {
            return;
        }
        ArrayList lineMarkers = new ArrayList();
        FileViewProvider viewProvider = this.myFile.getViewProvider();
        for (Language language2 : viewProvider.getLanguages()) {
            PsiFile root2 = viewProvider.getPsi(language2);
            HighlightingLevelManager highlightingLevelManager = HighlightingLevelManager.getInstance(this.myProject);
            if (!highlightingLevelManager.shouldHighlight((PsiElement)root2)) continue;
            Divider.divideInsideAndOutsideInOneRoot(root2, Divider.toScalarRange(this.myRestrictRange), Divider.toScalarRange(this.myPriorityBounds), (Processor<? super Divider.DividedElements>)((Processor)elements -> {
                List<LineMarkerProvider> providers = LineMarkersPass.getMarkerProviders(language2, this.myProject);
                ArrayList<LineMarkerProvider> providersList = new ArrayList<LineMarkerProvider>(providers);
                LineMarkersPass.queryProviders(elements.inside, root2, providersList, (element2, info2) -> {
                    lineMarkers.add((LineMarkerInfo<?>)info2);
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (this.isValid()) {
                            LineMarkersUtil.addLineMarkerToEditorIncrementally(this.myProject, this.getDocument(), info2);
                        }
                    }, this.myProject.getDisposed());
                });
                LineMarkersPass.queryProviders(elements.outside, root2, providersList, (element2, info2) -> lineMarkers.add((LineMarkerInfo<?>)info2));
                return true;
            }));
        }
        this.myMarkers = LineMarkersPass.mergeLineMarkers(lineMarkers, this.getDocument());
        if (LOG.isDebugEnabled()) {
            LOG.debug("LineMarkersPass.doCollectInformation. lineMarkers: " + lineMarkers + "; merged: " + this.myMarkers);
        }
    }

    @NotNull
    private static List<LineMarkerInfo<?>> mergeLineMarkers(@NotNull List<LineMarkerInfo<?>> markers, @NotNull Document document) {
        if (markers == null) {
            LineMarkersPass.$$$reportNull$$$0(6);
        }
        if (document == null) {
            LineMarkersPass.$$$reportNull$$$0(7);
        }
        Int2ObjectOpenHashMap sameLineMarkers = new Int2ObjectOpenHashMap();
        for (int i2 = markers.size() - 1; i2 >= 0; --i2) {
            LineMarkerInfo<?> marker = markers.get(i2);
            if (!(marker instanceof MergeableLineMarkerInfo)) continue;
            MergeableLineMarkerInfo mergeable = (MergeableLineMarkerInfo)marker;
            markers.remove(i2);
            int line = document.getLineNumber(marker.startOffset);
            ArrayList<MergeableLineMarkerInfo> infos = (ArrayList<MergeableLineMarkerInfo>)sameLineMarkers.get(line);
            if (infos == null) {
                infos = new ArrayList<MergeableLineMarkerInfo>();
                sameLineMarkers.put(line, infos);
            }
            infos.add(mergeable);
        }
        if (sameLineMarkers.isEmpty()) {
            List<LineMarkerInfo<?>> list2 = markers;
            if (list2 == null) {
                LineMarkersPass.$$$reportNull$$$0(8);
            }
            return list2;
        }
        ArrayList result2 = new ArrayList(markers);
        for (List value2 : sameLineMarkers.values()) {
            result2.addAll(MergeableLineMarkerInfo.merge((List)value2));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            LineMarkersPass.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @NotNull
    public static List<LineMarkerProvider> getMarkerProviders(@NotNull Language language2, @NotNull Project project) {
        if (language2 == null) {
            LineMarkersPass.$$$reportNull$$$0(10);
        }
        if (project == null) {
            LineMarkersPass.$$$reportNull$$$0(11);
        }
        List forLanguage = LineMarkerProviders.getInstance().allForLanguageOrAny(language2);
        List providers = DumbService.getInstance((Project)project).filterByDumbAwareness((Collection)forLanguage);
        LineMarkerSettings settings = LineMarkerSettings.getSettings();
        List list2 = ContainerUtil.filter((Collection)providers, provider2 -> !(provider2 instanceof LineMarkerProviderDescriptor) || settings.isEnabled((GutterIconDescriptor)((LineMarkerProviderDescriptor)provider2)));
        if (list2 == null) {
            LineMarkersPass.$$$reportNull$$$0(12);
        }
        return list2;
    }

    private static void queryProviders(@NotNull List<? extends PsiElement> elements, @NotNull PsiFile containingFile, @NotNull List<? extends LineMarkerProvider> providers, @NotNull PairConsumer<? super PsiElement, ? super LineMarkerInfo<?>> consumer2) {
        PsiElement element2;
        int i2;
        if (elements == null) {
            LineMarkersPass.$$$reportNull$$$0(13);
        }
        if (containingFile == null) {
            LineMarkersPass.$$$reportNull$$$0(14);
        }
        if (providers == null) {
            LineMarkersPass.$$$reportNull$$$0(15);
        }
        if (consumer2 == null) {
            LineMarkersPass.$$$reportNull$$$0(16);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        HashSet visitedInjectedFiles = new HashSet();
        for (i2 = 0; i2 < elements.size(); ++i2) {
            element2 = elements.get(i2);
            for (int j = 0; j < providers.size(); ++j) {
                LineMarkerInfo info2;
                ProgressManager.checkCanceled();
                LineMarkerProvider provider2 = providers.get(j);
                try {
                    info2 = provider2.getLineMarkerInfo(element2);
                }
                catch (ProcessCanceledException | IndexNotReadyException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.error("During querying provider " + provider2 + " (" + provider2.getClass() + ")", (Throwable)e, new Attachment[]{new Attachment(containingFile.getViewProvider().getVirtualFile().getName(), containingFile.getText())});
                    continue;
                }
                if (info2 == null) continue;
                consumer2.consume((Object)element2, (Object)info2);
            }
        }
        for (i2 = 0; i2 < elements.size(); ++i2) {
            element2 = elements.get(i2);
            LineMarkersPass.queryLineMarkersForInjected(element2, containingFile, visitedInjectedFiles, consumer2);
        }
        NotNullList slowLineMarkers = new NotNullList();
        for (int j = 0; j < providers.size(); ++j) {
            ProgressManager.checkCanceled();
            LineMarkerProvider provider3 = providers.get(j);
            try {
                provider3.collectSlowLineMarkers(elements, (Collection)slowLineMarkers);
            }
            catch (ProcessCanceledException | IndexNotReadyException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                continue;
            }
            if (slowLineMarkers.isEmpty()) continue;
            for (int k = 0; k < slowLineMarkers.size(); ++k) {
                LineMarkerInfo slowInfo = (LineMarkerInfo)slowLineMarkers.get(k);
                PsiElement element3 = slowInfo.getElement();
                consumer2.consume((Object)element3, (Object)slowInfo);
            }
            slowLineMarkers.clear();
        }
    }

    private static void queryLineMarkersForInjected(@NotNull PsiElement element2, @NotNull PsiFile containingFile, @NotNull Set<? super PsiFile> visitedInjectedFiles, @NotNull PairConsumer<? super PsiElement, ? super LineMarkerInfo<?>> consumer2) {
        InjectedLanguageManager manager2;
        if (element2 == null) {
            LineMarkersPass.$$$reportNull$$$0(17);
        }
        if (containingFile == null) {
            LineMarkersPass.$$$reportNull$$$0(18);
        }
        if (visitedInjectedFiles == null) {
            LineMarkersPass.$$$reportNull$$$0(19);
        }
        if (consumer2 == null) {
            LineMarkersPass.$$$reportNull$$$0(20);
        }
        if ((manager2 = InjectedLanguageManager.getInstance((Project)containingFile.getProject())).isInjectedFragment(containingFile)) {
            return;
        }
        InjectedLanguageManager.getInstance((Project)containingFile.getProject()).enumerateEx(element2, containingFile, false, (injectedPsi, places) -> {
            if (!visitedInjectedFiles.add(injectedPsi)) {
                return;
            }
            Project project = injectedPsi.getProject();
            Document document = PsiDocumentManager.getInstance((Project)project).getCachedDocument(injectedPsi);
            if (!(document instanceof DocumentWindow)) {
                return;
            }
            List<PsiElement> injElements = CollectHighlightsUtil.getElementsInRange((PsiElement)injectedPsi, 0, injectedPsi.getTextLength());
            List<LineMarkerProvider> providers = LineMarkersPass.getMarkerProviders(injectedPsi.getLanguage(), project);
            LineMarkersPass.queryProviders(injElements, injectedPsi, providers, (injectedElement, injectedMarker) -> {
                GutterIconRenderer gutterRenderer = injectedMarker.createGutterRenderer();
                TextRange injectedRange = new TextRange(injectedMarker.startOffset, injectedMarker.endOffset);
                List editables = manager2.intersectWithAllEditableFragments(injectedPsi, injectedRange);
                for (TextRange editable : editables) {
                    TextRange hostRange = manager2.injectedToHost((PsiElement)injectedPsi, editable);
                    Icon icon2 = gutterRenderer == null ? null : gutterRenderer.getIcon();
                    GutterIconNavigationHandler navigationHandler = injectedMarker.getNavigationHandler();
                    LineMarkerInfo converted = icon2 == null ? new LineMarkerInfo(injectedElement, hostRange) : new LineMarkerInfo(injectedElement, hostRange, icon2, e -> injectedMarker.getLineMarkerTooltip(), navigationHandler, GutterIconRenderer.Alignment.RIGHT, () -> gutterRenderer.getAccessibleName());
                    consumer2.consume(injectedElement, (Object)converted);
                }
            });
        });
    }

    @NotNull
    public static Collection<LineMarkerInfo<?>> queryLineMarkers(@NotNull PsiFile file2, @NotNull Document document) {
        if (file2 == null) {
            LineMarkersPass.$$$reportNull$$$0(21);
        }
        if (document == null) {
            LineMarkersPass.$$$reportNull$$$0(22);
        }
        if (file2.getNode() == null) {
            List<LineMarkerInfo<?>> list2 = Collections.emptyList();
            if (list2 == null) {
                LineMarkersPass.$$$reportNull$$$0(23);
            }
            return list2;
        }
        LineMarkersPass pass2 = new LineMarkersPass(file2.getProject(), file2, document, file2.getTextRange(), file2.getTextRange());
        pass2.doCollectInformation((ProgressIndicator)new EmptyProgressIndicator());
        List<LineMarkerInfo<?>> list3 = pass2.myMarkers;
        if (list3 == null) {
            LineMarkersPass.$$$reportNull$$$0(24);
        }
        return list3;
    }

    @NotNull
    public static LineMarkerInfo<PsiElement> createMethodSeparatorLineMarker(@NotNull PsiElement startFrom, @NotNull EditorColorsManager colorsManager) {
        if (startFrom == null) {
            LineMarkersPass.$$$reportNull$$$0(25);
        }
        if (colorsManager == null) {
            LineMarkersPass.$$$reportNull$$$0(26);
        }
        LineMarkerInfo info2 = new LineMarkerInfo(startFrom, startFrom.getTextRange());
        EditorColorsScheme scheme2 = colorsManager.getGlobalScheme();
        info2.separatorColor = scheme2.getColor(CodeInsightColors.METHOD_SEPARATORS_COLOR);
        info2.separatorPlacement = SeparatorPlacement.TOP;
        LineMarkerInfo lineMarkerInfo = info2;
        if (lineMarkerInfo == null) {
            LineMarkersPass.$$$reportNull$$$0(27);
        }
        return lineMarkerInfo;
    }

    @Override
    public String toString() {
        return super.toString() + "; myBounds: " + this.myPriorityBounds;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 23: 
            case 24: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 23: 
            case 24: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 7: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priorityBounds";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restrictRange";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markers";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 23: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/LineMarkersPass";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitedInjectedFiles";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startFrom";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorsManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/LineMarkersPass";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeLineMarkers";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getMarkerProviders";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "queryLineMarkers";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethodSeparatorLineMarker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doCollectInformation";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "mergeLineMarkers";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 23: 
            case 24: 
            case 27: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getMarkerProviders";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "queryProviders";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "queryLineMarkersForInjected";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "queryLineMarkers";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createMethodSeparatorLineMarker";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 23: 
            case 24: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

