/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlQuickFixFactory;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.source.xml.SchemaPrefixReference;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.analysis.XmlAnalysisBundle;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.util.XmlTagUtil;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XmlUnboundNsPrefixInspection
extends XmlSuppressableInspectionTool {
    @NonNls
    private static final String XML = "xml";

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            XmlUnboundNsPrefixInspection.$$$reportNull$$$0(0);
        }
        return new XmlElementVisitor(){
            private Boolean isXml;

            private boolean isXmlFile(XmlElement element2) {
                if (this.isXml == null) {
                    PsiFile file2 = element2.getContainingFile();
                    this.isXml = file2 instanceof XmlFile && !InjectedLanguageManager.getInstance((Project)element2.getProject()).isInjectedFragment(file2);
                }
                return this.isXml;
            }

            public void visitXmlToken(XmlToken token2) {
                if (this.isXmlFile((XmlElement)token2) && token2.getTokenType() == XmlTokenType.XML_NAME) {
                    PsiElement parent;
                    PsiElement element2 = token2.getPrevSibling();
                    while (element2 instanceof PsiWhiteSpace) {
                        element2 = element2.getPrevSibling();
                    }
                    if (element2 instanceof XmlToken && ((XmlToken)element2).getTokenType() == XmlTokenType.XML_START_TAG_START && (parent = element2.getParent()) instanceof XmlTag && !(token2.getNextSibling() instanceof OuterLanguageElement)) {
                        XmlTag tag2 = (XmlTag)parent;
                        XmlUnboundNsPrefixInspection.this.checkUnboundNamespacePrefix((XmlElement)tag2, tag2, tag2.getNamespacePrefix(), token2, holder, isOnTheFly);
                    }
                }
            }

            public void visitXmlAttribute(XmlAttribute attribute) {
                if (!this.isXmlFile((XmlElement)attribute)) {
                    return;
                }
                String namespace = attribute.getNamespace();
                if (attribute.isNamespaceDeclaration() || "http://www.w3.org/2001/XMLSchema-instance".equals(namespace)) {
                    return;
                }
                XmlTag tag2 = attribute.getParent();
                if (tag2 == null) {
                    return;
                }
                XmlElementDescriptor elementDescriptor = tag2.getDescriptor();
                if (elementDescriptor == null || elementDescriptor instanceof AnyXmlElementDescriptor) {
                    return;
                }
                String name2 = attribute.getName();
                XmlUnboundNsPrefixInspection.this.checkUnboundNamespacePrefix((XmlElement)attribute, tag2, XmlUtil.findPrefixByQualifiedName(name2), null, holder, isOnTheFly);
            }

            public void visitXmlAttributeValue(XmlAttributeValue value2) {
                PsiReference[] references;
                for (PsiReference reference2 : references = value2.getReferences()) {
                    if (!(reference2 instanceof SchemaPrefixReference) || XmlUnboundNsPrefixInspection.XML.equals(((SchemaPrefixReference)reference2).getNamespacePrefix()) || reference2.resolve() != null) continue;
                    holder.registerProblem(reference2, XmlAnalysisBundle.message((String)"xml.inspections.unbound.namespace", (Object[])new Object[]{((SchemaPrefixReference)reference2).getNamespacePrefix()}), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
                }
            }
        };
    }

    private void checkUnboundNamespacePrefix(XmlElement element2, XmlTag context2, String namespacePrefix, XmlToken token2, ProblemsHolder holder, boolean isOnTheFly) {
        ProblemHighlightType highlightType;
        String localizedMessage;
        if (namespacePrefix.isEmpty() && (!(element2 instanceof XmlTag) || !(element2.getParent() instanceof XmlDocument)) || XML.equals(namespacePrefix)) {
            return;
        }
        String namespaceByPrefix = context2.getNamespaceByPrefix(namespacePrefix);
        if (!namespaceByPrefix.isEmpty()) {
            return;
        }
        PsiFile psiFile = context2.getContainingFile();
        if (!(psiFile instanceof XmlFile)) {
            return;
        }
        XmlFile containingFile = (XmlFile)psiFile;
        if (!HighlightingLevelManager.getInstance(containingFile.getProject()).shouldInspect((PsiElement)containingFile)) {
            return;
        }
        XmlExtension extension2 = XmlExtension.getExtension((PsiFile)containingFile);
        if (extension2.getPrefixDeclaration(context2, namespacePrefix) != null) {
            return;
        }
        String string = localizedMessage = isOnTheFly ? XmlAnalysisBundle.message((String)"xml.inspections.unbound.namespace", (Object[])new Object[]{namespacePrefix}) : XmlAnalysisBundle.message((String)"xml.inspections.unbound.namespace.no.param", (Object[])new Object[0]);
        if (namespacePrefix.isEmpty()) {
            XmlTag tag2 = (XmlTag)element2;
            if (!"http://java.sun.com/JSP/Page".equals(tag2.getNamespace()) && isOnTheFly) {
                LocalQuickFix fix2 = XmlQuickFixFactory.getInstance().createNSDeclarationIntentionFix((PsiElement)context2, namespacePrefix, token2);
                XmlUnboundNsPrefixInspection.reportTagProblem((XmlElement)tag2, localizedMessage, null, ProblemHighlightType.INFORMATION, fix2, holder);
            }
            return;
        }
        int prefixLength = namespacePrefix.length();
        TextRange range2 = new TextRange(0, prefixLength);
        HighlightInfoType infoType = extension2.getHighlightInfoType(containingFile);
        ProblemHighlightType problemHighlightType = highlightType = infoType == HighlightInfoType.ERROR ? ProblemHighlightType.ERROR : ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
        if (this.isSuppressedFor((PsiElement)element2)) {
            return;
        }
        if (element2 instanceof XmlTag) {
            LocalQuickFix fix3 = isOnTheFly ? XmlQuickFixFactory.getInstance().createNSDeclarationIntentionFix((PsiElement)context2, namespacePrefix, token2) : null;
            XmlUnboundNsPrefixInspection.reportTagProblem(element2, localizedMessage, range2, highlightType, fix3, holder);
        } else if (element2 instanceof XmlAttribute) {
            LocalQuickFix fix4 = isOnTheFly ? XmlQuickFixFactory.getInstance().createNSDeclarationIntentionFix((PsiElement)element2, namespacePrefix, token2) : null;
            XmlAttribute attribute = (XmlAttribute)element2;
            holder.registerProblem((PsiElement)attribute.getNameElement(), localizedMessage, highlightType, range2, new LocalQuickFix[]{fix4});
        } else {
            holder.registerProblem((PsiElement)element2, localizedMessage, highlightType, range2, new LocalQuickFix[0]);
        }
    }

    private static void reportTagProblem(XmlElement element2, @InspectionMessage String localizedMessage, TextRange range2, ProblemHighlightType highlightType, LocalQuickFix fix2, ProblemsHolder holder) {
        XmlToken nameToken = XmlTagUtil.getStartTagNameElement((XmlTag)((XmlTag)element2));
        if (nameToken != null) {
            holder.registerProblem((PsiElement)nameToken, localizedMessage, highlightType, range2, new LocalQuickFix[]{fix2});
        }
        if ((nameToken = XmlTagUtil.getEndTagNameElement((XmlTag)((XmlTag)element2))) != null) {
            holder.registerProblem((PsiElement)nameToken, localizedMessage, highlightType, range2, new LocalQuickFix[]{fix2});
        }
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return "XmlUnboundNsPrefix";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInsight/daemon/impl/analysis/XmlUnboundNsPrefixInspection", "buildVisitor"));
    }
}

