/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.dataflow;

import com.intellij.codeInsight.controlflow.ControlFlowUtil;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInsight.dataflow.DFALimitExceededException;
import com.intellij.codeInsight.dataflow.DfaInstance;
import com.intellij.codeInsight.dataflow.Semilattice;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.graph.DFSTBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

public class DFAEngine<E> {
    private static final Logger LOG = Logger.getInstance((String)DFAEngine.class.getName());
    private static final long TIME_LIMIT = 1000000000L;
    private final Instruction[] myFlow;
    private final DfaInstance<E> myDfa;
    private final Semilattice<E> mySemilattice;

    public DFAEngine(Instruction[] flow2, DfaInstance<E> dfa, Semilattice<E> semilattice) {
        this.myFlow = flow2;
        this.myDfa = dfa;
        this.mySemilattice = semilattice;
    }

    public List<E> performDFA() throws DFALimitExceededException {
        ArrayList<E> info2 = new ArrayList<E>(this.myFlow.length);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Performing DFA\nInstance: " + this.myDfa + " Semilattice: " + this.mySemilattice + "\nCon");
        }
        E initial = this.myDfa.initial();
        int length = this.myFlow.length;
        for (int i2 = 0; i2 < length; ++i2) {
            info2.add(i2, initial);
        }
        int limit = this.getIterationLimit();
        long startTime = System.nanoTime();
        DFSTBuilder dfsTBuilder = new DFSTBuilder(ControlFlowUtil.createGraph(this.myFlow));
        int[] instructionNumToNNumber = new int[this.myFlow.length];
        for (int i3 = 0; i3 < this.myFlow.length; ++i3) {
            instructionNumToNNumber[((Instruction)dfsTBuilder.getNodeByNNumber((int)i3)).num()] = i3;
        }
        int[] lastUpdate = new int[length];
        int count = 0;
        ArrayList<Instruction> instructionsWithBackEdges = new ArrayList<Instruction>();
        block2: for (Collection component2 : dfsTBuilder.getComponents()) {
            ArrayList<Instruction> sortedInstructions = new ArrayList<Instruction>(component2);
            sortedInstructions.sort(Comparator.comparingInt(it -> instructionNumToNNumber[it.num()]));
            instructionsWithBackEdges.clear();
            for (Instruction instruction : sortedInstructions) {
                this.applyTransferFunction(info2, instruction);
                if (!instruction.allPred().stream().anyMatch(predecessor -> instructionNumToNNumber[predecessor.num()] > instructionNumToNNumber[instruction.num()])) continue;
                instructionsWithBackEdges.add(instruction);
            }
            int iteration = 0;
            do {
                int currentIteration = ++iteration;
                boolean anyUpdates = false;
                for (Instruction instruction : instructionsWithBackEdges) {
                    if (!this.applyTransferFunction(info2, instruction)) continue;
                    lastUpdate[instruction.num()] = currentIteration;
                    anyUpdates = true;
                    ++count;
                }
                if (!anyUpdates) continue block2;
                for (Instruction instruction : sortedInstructions) {
                    if (!instruction.allPred().stream().anyMatch(it -> lastUpdate[it.num()] == currentIteration) || !this.applyTransferFunction(info2, instruction)) continue;
                    lastUpdate[instruction.num()] = currentIteration;
                    ++count;
                }
            } while (count <= limit && System.nanoTime() - startTime <= 1000000000L);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Iteration count exceeded on worklist");
            }
            throw new DFALimitExceededException("Iteration count exceeded on worklist");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Done in: " + (double)(System.nanoTime() - startTime) / 1.0E7 + "ms. Ratio: " + count / length);
        }
        return info2;
    }

    private boolean applyTransferFunction(List<E> info2, Instruction currentInstruction) {
        ProgressManager.checkCanceled();
        int currentNumber = currentInstruction.num();
        E oldE = info2.get(currentNumber);
        E joinedE = this.join(currentInstruction, info2);
        E newE = this.myDfa.fun(joinedE, currentInstruction);
        if (!this.mySemilattice.eq(newE, oldE)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Number: " + currentNumber + " old: " + oldE.toString() + " new: " + newE.toString());
            }
            info2.set(currentNumber, newE);
            return true;
        }
        return false;
    }

    private int getIterationLimit() {
        int allPred = this.myFlow.length;
        for (Instruction instruction : this.myFlow) {
            allPred += instruction.allPred().size();
        }
        return allPred * 2;
    }

    private E join(Instruction instruction, List<? extends E> info2) {
        Collection prev2 = instruction.allPred();
        ArrayList<E> prevInfos = new ArrayList<E>();
        for (Instruction i2 : prev2) {
            prevInfos.add(info2.get(i2.num()));
        }
        return this.mySemilattice.join(prevInfos);
    }
}

